/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import com.vmware.vide.vxmleditor.Schema;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.xml.sax.SAXException;

public class TagContentAssistProcessor
implements IContentAssistProcessor {
    Schema XMLschema;
    private Object XsdFileName;
    private String commentStartTag = "<!--";
    private String commentEndTag = "-->";
    public static final char[] ALL = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'k', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' '};

    public TagContentAssistProcessor(String XSDFile) {
        this.XsdFileName = XSDFile;
    }

    public void setSchemafile(Object schemaFileName) {
        this.XsdFileName = schemaFileName;
    }

    public void initializeSchemaObject() {
        this.XMLschema = new Schema();
        try {
            this.XMLschema.parseXml(this.XsdFileName);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public ICompletionProposal[] getArrayofStrings(Schema.Elem[] XSDvalues, int replacementOffset, int replacementLength, int cursorPosition, String tagvalue, boolean isElement) {
        Vector<Object> values = new Vector<Object>();
        int i = 0;
        while (i < XSDvalues.length) {
            if (XSDvalues[i] != null && XSDvalues[i].getName().toLowerCase().startsWith(tagvalue.toLowerCase())) {
                if (isElement) {
                    if (XSDvalues[i].getTagType().equalsIgnoreCase("group")) {
                        Schema.Type typ = this.getTypeOf(XSDvalues[i].getName());
                        if (typ != null) {
                            Schema.Elem[] groupElements = new Schema.Elem[typ.elems.size()];
                            groupElements = typ.elems.toArray(groupElements);
                            ICompletionProposal[] compArray = this.getArrayofStrings(groupElements, replacementOffset, replacementLength, cursorPosition, tagvalue, isElement);
                            int j = 0;
                            while (j < compArray.length) {
                                values.add(compArray[j]);
                                ++j;
                            }
                        }
                    } else {
                        values.add(new CompletionProposal("<" + XSDvalues[i].getName() + "></" + XSDvalues[i].getName() + ">", replacementOffset, replacementLength, cursorPosition + XSDvalues[i].getName().length() + 1, null, "<" + XSDvalues[i].getName() + ">", null, XSDvalues[i].getDescription()));
                    }
                } else {
                    values.add(new CompletionProposal(String.valueOf(XSDvalues[i].getName()) + "=\"\"", replacementOffset, replacementLength, cursorPosition + XSDvalues[i].getName().length() + 2, null, XSDvalues[i].getName(), null, XSDvalues[i].getDescription()));
                }
            }
            ++i;
        }
        ICompletionProposal[] a = new ICompletionProposal[values.size()];
        return values.toArray(a);
    }

    public boolean isElement(String text, int offset) {
        if (text.length() == 0) {
            return false;
        }
        return text.charAt(0) == '<';
    }

    public Schema.Type getTypeOf(String s) {
        if (s != null) {
            int i = 0;
            while (i < this.XMLschema.symbols.size()) {
                if (this.XMLschema.symbols.get(i).getName().equalsIgnoreCase(s)) {
                    return this.XMLschema.symbols.get(i).getType();
                }
                ++i;
            }
        }
        return null;
    }

    public String getexactTagReference(String tag) {
        int endtagIndex = tag.indexOf(62);
        while (endtagIndex > -1) {
            tag = tag.substring(endtagIndex + 1, tag.length());
            endtagIndex = tag.indexOf(62);
        }
        return tag;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (this.XMLschema == null) {
                this.initializeSchemaObject();
            }
            String text = viewer.getDocument().get(0, offset);
            boolean isElement = false;
            String tagValue = text.substring(text.lastIndexOf(32) + 1, offset);
            int replacementOffset = text.lastIndexOf(32) + 1;
            if (tagValue.length() > 0) {
                int indexofNewline = tagValue.lastIndexOf(10);
                if (indexofNewline > -1) {
                    tagValue = tagValue.substring(indexofNewline + 1, tagValue.length());
                    replacementOffset = text.lastIndexOf(10) + 1;
                }
                int endtagIndex = tagValue.indexOf(62);
                while (endtagIndex > -1) {
                    replacementOffset += endtagIndex + 1;
                    tagValue = tagValue.substring(endtagIndex + 1, tagValue.length());
                    endtagIndex = tagValue.indexOf(62);
                }
                isElement = this.isElement(tagValue, offset);
            }
            String stackText = text;
            if (isElement) {
                stackText = text.substring(0, text.lastIndexOf(60));
            }
            Stack<String> tagStack = this.createTagStack(stackText);
            ICompletionProposal[] values = null;
            Schema.Type typ = null;
            if (tagStack.size() != 0) {
                typ = this.getTypeOf(tagStack.peek());
            }
            if (typ != null) {
                Schema.Elem[] elements = new Schema.Elem[typ.elems.size()];
                values = isElement ? this.getArrayofStrings(typ.elems.toArray(elements), replacementOffset, tagValue.length(), tagValue.length(), tagValue.substring(1, tagValue.length()), isElement) : this.getArrayofStrings(typ.attrs.toArray(elements), replacementOffset, tagValue.length(), tagValue.length(), tagValue, isElement);
            } else {
                Schema.Elem[] symbols = new Schema.Elem[this.XMLschema.symbols.size()];
                values = this.getArrayofStrings(this.XMLschema.symbols.toArray(symbols), replacementOffset, tagValue.length(), tagValue.length(), tagValue.substring(1, tagValue.length()), isElement);
            }
            return values;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String removeCommentedCode(String text) {
        int commentStartIndex = text.indexOf(this.commentStartTag);
        while (commentStartIndex > 0) {
            int commentendIndex = text.indexOf(this.commentEndTag, commentStartIndex);
            text = String.valueOf(text.substring(0, commentStartIndex)) + text.substring(commentendIndex + this.commentEndTag.length(), text.length());
            commentStartIndex = text.indexOf(this.commentStartTag);
        }
        return text;
    }

    private Stack<String> createTagStack(String text) {
        text = this.removeCommentedCode(text);
        int startTag = text.indexOf(60);
        Stack<String> stack = new Stack<String>();
        while (startTag > -1) {
            int spaceindexIndex;
            boolean validTagEnd = false;
            int endofTagIndex = text.indexOf(62, startTag + 1);
            String tag = "";
            tag = endofTagIndex > 0 ? text.substring(startTag + 1, endofTagIndex) : text.substring(startTag + 1, text.length());
            if (tag.contains("/")) {
                validTagEnd = true;
            }
            if ((spaceindexIndex = tag.indexOf(32)) > 0) {
                endofTagIndex = startTag + 1 + spaceindexIndex;
                tag = text.substring(startTag + 1, endofTagIndex);
            }
            tag = tag.trim();
            if (stack.size() != 0) {
                if (tag.startsWith("/")) {
                    stack.pop();
                } else if (!(tag.contains("/") || tag.contains("?") || tag.contains("!") || tag.length() == 0 || validTagEnd)) {
                    stack.push(tag.substring(0, tag.length()));
                }
            } else if (!(tag.contains("/") || tag.contains("?") || tag.contains("!") || tag.length() == 0 || validTagEnd)) {
                stack.push(tag.substring(0, tag.length()));
            }
            startTag = endofTagIndex > 0 ? text.indexOf(60, endofTagIndex) : endofTagIndex;
        }
        return stack;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ALL;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public String getErrorMessage() {
        return "Error";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

