/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.newwizard;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.manager.AbstractProjectIdentity;
import com.vmware.vide.project.wizard.newwizard.NewCategoryPage;
import com.vmware.vide.project.wizard.newwizard.ProjectInfoPage;
import com.vmware.vide.project.wizard.newwizard.ProjectPropertyPage;
import com.vmware.vide.project.wizard.ui.DevkitProjectWizardPage;
import com.vmware.vide.project.wizard.vibwizard.VIBInfoWizardPage;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ProjectNewWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_TITLE = "New VMware Development Kit Project";
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-newwizard-project";
    private NewCategoryPage selpage;
    private ProjectInfoPage projinfopage;
    private ProjectPropertyPage projpropertypage;
    private VIBInfoWizardPage vibinfopage;

    public ProjectNewWizard() {
        this.setWindowTitle(WIZARD_TITLE);
        new ArrayList();
    }

    public void addPages() {
        super.addPages();
        this.selpage = new NewCategoryPage();
        this.projinfopage = new ProjectInfoPage();
        this.projpropertypage = new ProjectPropertyPage();
        this.vibinfopage = new VIBInfoWizardPage();
        this.addPage((IWizardPage)this.selpage);
        this.addPage((IWizardPage)this.projinfopage);
        this.addPage((IWizardPage)this.projpropertypage);
        this.addPage((IWizardPage)this.vibinfopage);
        if (this.getShell() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.vmware.vide.project.help.context-newwizard-project");
        }
    }

    public boolean performFinish() {
        boolean result = this.projinfopage.createProject();
        if (result) {
            AbstractProjectIdentity identity = this.projinfopage.getProjectData().getDevkitInfo().getProjectIdentity();
            this.switchPerspective(identity.getName(), identity.getProjectPerspectiveID());
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(WIZARD_TITLE);
    }

    public IWizardPage getNextPage(IWizardPage currentpage) {
        Object nextpage = super.getNextPage(currentpage);
        if (nextpage instanceof ProjectInfoPage && currentpage instanceof NewCategoryPage) {
            this.projinfopage.setProjectData(this.selpage.getSelectedProjectData());
        } else if (nextpage instanceof ProjectPropertyPage && currentpage instanceof ProjectInfoPage) {
            ProjectData projdata = this.projinfopage.getProjectData();
            if (projdata.getOrderedUserInputs().size() > 0) {
                this.projpropertypage.updateProjectProperty(projdata);
            } else {
                this.vibinfopage.updateVIBData(projdata.getVIBData(), projdata.getPropertyValues(null));
                nextpage = this.vibinfopage;
            }
        } else if (nextpage instanceof VIBInfoWizardPage) {
            ProjectData projdata = currentpage instanceof ProjectInfoPage ? this.projinfopage.getProjectData() : this.projpropertypage.getProjectData();
            this.vibinfopage.updateVIBData(projdata.getVIBData(), projdata.getPropertyValues(null));
        }
        return nextpage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        IWizardPage[] pages;
        if (!super.canFinish()) {
            return false;
        }
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage p = iWizardPageArray[n2];
            if (p instanceof DevkitProjectWizardPage && !((DevkitProjectWizardPage)p).okToFinish()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void switchPerspective(String name, String perspectiveid) {
        if (name == null || name.isEmpty() || perspectiveid == null || perspectiveid.isEmpty() || this.isPerspectiveOpened(perspectiveid)) {
            return;
        }
        IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
        String keepperspective = store.getString("KEEP_SWITCH_PERSPECTIVE_MODE");
        String perspectivemode = store.getString("SWITCH_PERSPECTIVE_MODE");
        if (keepperspective.equals("always") && perspectivemode.equals("No")) {
            return;
        }
        if (keepperspective.isEmpty() || !keepperspective.equals("always")) {
            String question = "This kind of project is associated with the " + name + " perspective.  Do you want to open this perspective now?";
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)"Open Associated Perspective", (String)question, null, (boolean)false, (IPreferenceStore)store, (String)"KEEP_SWITCH_PERSPECTIVE_MODE");
            int returnvalue = dialog.getReturnCode();
            store.setValue("SWITCH_PERSPECTIVE_MODE", returnvalue == 2 ? "YES" : "No");
            if (returnvalue == 3) {
                return;
            }
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective(perspectiveid, workbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    private boolean isPerspectiveOpened(String perspectiveid) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveDescriptor perdesc = workbench.getActiveWorkbenchWindow().getActivePage().getPerspective();
        return perdesc != null && perdesc.getId().equals(perspectiveid);
    }
}

