/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.parser;

import com.vmware.vide.project.wbis.exception.InvalidXmlException;
import com.vmware.vide.project.wbis.generator.ConfigTemplateGenerator;
import com.vmware.vide.project.wbis.model.input.AbstractSdkObject;
import com.vmware.vide.project.wbis.model.input.SdkLibraries;
import com.vmware.vide.project.wbis.model.input.SdkSamples;
import com.vmware.vide.project.wbis.parser.SdkLibrariesParser;
import com.vmware.vide.project.wbis.parser.SdkSamplesParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlParser {
    private static final Logger logger = LoggerFactory.getLogger(XmlParser.class);
    private static final String XML_EXTENSION = ".xml";
    private static final String FILE_NAME = "config-template.xml";
    private File xmlFile = null;
    List<SdkLibraries> sdkLibraries = new ArrayList<SdkLibraries>();
    List<SdkSamples> sdkSamples = new ArrayList<SdkSamples>();

    public XmlParser(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public XmlParser(File inputDirectory, File outputDirectory) throws Exception {
        logger.info("Scanning input directory " + inputDirectory + " for template files");
        if (inputDirectory.isDirectory()) {
            File[] fileArray = inputDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().toLowerCase().endsWith(XML_EXTENSION)) {
                    XmlParser parser = new XmlParser(f);
                    AbstractSdkObject sdkObj = parser.parse();
                    if (sdkObj instanceof SdkLibraries) {
                        this.sdkLibraries.add((SdkLibraries)sdkObj);
                    } else if (sdkObj instanceof SdkSamples) {
                        this.sdkSamples.add((SdkSamples)sdkObj);
                    }
                }
                ++n2;
            }
        } else {
            logger.warn(inputDirectory + " is not a directory. Please enter a valid directory");
        }
        if (this.sdkSamples.size() == 0 || this.sdkLibraries.size() == 0) {
            logger.warn("No template files found ");
            return;
        }
        if (outputDirectory != null) {
            outputDirectory.mkdir();
        }
        ConfigTemplateGenerator writer = new ConfigTemplateGenerator(this.sdkLibraries, this.sdkSamples, outputDirectory);
        File file = new File(outputDirectory, FILE_NAME);
        writer.write(file);
    }

    private AbstractSdkObject parse() throws InvalidXmlException {
        this.validateXml(this.xmlFile);
        SdkLibrariesParser sdkLibrariesParser = new SdkLibrariesParser();
        SdkSamplesParser sdkSamplesParser = new SdkSamplesParser();
        if (sdkLibrariesParser.parse(this.xmlFile)) {
            return sdkLibrariesParser.getSdkLibraries();
        }
        if (sdkSamplesParser.parse(this.xmlFile)) {
            return sdkSamplesParser.getSdkSamples();
        }
        throw new InvalidXmlException("Not a supported xml file type.");
    }

    private void validateXml(File xmlFile) throws InvalidXmlException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new InvalidXmlException(e.getMessage(), e);
        }
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public List<SdkLibraries> getSdkLibraries() {
        return this.sdkLibraries;
    }

    public List<SdkSamples> getSdkSamples() {
        return this.sdkSamples;
    }
}

