/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wbis.generator;

import com.vmware.vide.project.wbis.generator.IProjectGenerator;
import com.vmware.vide.project.wbis.model.input.DependencySet;
import com.vmware.vide.project.wbis.model.input.MavenDependency;
import com.vmware.vide.project.wbis.model.input.SdkLibraries;
import com.vmware.vide.project.wbis.model.input.SdkSample;
import com.vmware.vide.project.wbis.model.output.maven.Project;
import com.vmware.vide.utils.xml.JaxbUtils;
import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProject
implements IProjectGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MavenProject.class);
    private static final String FILE_NAME = "pom.xml";

    @Override
    public void generate(File destination, SdkSample sample, List<SdkLibraries> librariesList, IProgressMonitor monitor) throws Exception {
        logger.info("Generating pom.xml for " + sample.getName() + " sample ");
        Project project = new Project();
        project.setModelVersion("4.0.0");
        project.setGroupId("com.vmware.sdk");
        project.setArtifactId(sample.getName());
        project.setVersion(String.valueOf(sample.getVersion()) + "-SNAPSHOT");
        project.setPackaging("jar");
        List<String> dependencyTypes = this.getDependencyTypes(sample);
        Project.Dependencies dependencies = new Project.Dependencies();
        for (SdkLibraries lib : librariesList) {
            List<DependencySet> dependencySets = this.getDependencySets(lib);
            for (DependencySet dependencySet : dependencySets) {
                if (!dependencyTypes.contains(dependencySet.getId())) continue;
                List<MavenDependency> dependenciesList = this.getDependencies(dependencySet);
                for (MavenDependency dependency : dependenciesList) {
                    dependencies.getDependency().add(this.generateDependencyElement(dependency.getArtifactId(), dependency.getGroupId(), dependency.getVersion()));
                }
            }
        }
        project.setDependencies(dependencies);
        try {
            File fXmlFile = new File(destination.toString(), FILE_NAME);
            JaxbUtils.toJaxbFormattedXml(Project.class, (File)fXmlFile, (Object)project, (boolean)false, (boolean)false);
            logger.info("Successfully generated pom.xml for " + sample.getName() + " sample ");
        }
        catch (JAXBException e) {
            logger.error("JAXBException while trying to generate pom file", (Throwable)e);
        }
        catch (ClassCastException e) {
            logger.error("ClassCastException while trying to generate pom file", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception while trying to generate pom file", (Throwable)e);
        }
    }

    private Project.Dependencies.Dependency generateDependencyElement(String artifactId, String groupId, String version) {
        Project.Dependencies.Dependency dependency = new Project.Dependencies.Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setGroupId(groupId);
        dependency.setVersion(version);
        return dependency;
    }

    private List<String> getDependencyTypes(SdkSample sample) {
        return sample.getProjectDependency();
    }

    private List<DependencySet> getDependencySets(SdkLibraries library) {
        return library.getDependencySet();
    }

    private List<MavenDependency> getDependencies(DependencySet dependencySet) {
        List<MavenDependency> dependencies = dependencySet.getMavenDependency();
        return dependencies;
    }
}

