/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard.project;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.config.wizard.project.Template;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import com.vmware.vide.utils.net.NetworkHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ProjectFile {
    private static ILog logger = ProjectPlugin.getDefault().getLog();
    private static final String TAG_OP = "op";
    private static final String OP_AND = "and";
    private static final String OP_OR = "or";
    private static final String OP_NOT = "not";
    private static final String TAG_CONDITIONS = "conditions";
    private static final String TAG_COND = "cond";
    private static final String TAG_VALUE_TEXT = "value_text";
    private static final String TAG_VALUE_PATTERN = "value_pattern";
    private static final String URL_SEPARATOR = "/";
    public static final String FILE_WRITABLE = "w";
    public static final String FILE_READABLE = "r";
    public static final String FILE_EXECUTABLE = "x";
    private static final String FMT_TAG_ALREADY_SPECIFIED = "The tag [%s] is already specified.";
    private static final String FMT_UNEXPECTED_TAG = "Unexpected tag [%s] in conditions.";
    private static final String MSG_INTERNAL_ERR = "Internal error when processing the conditions tag.";
    private static final String TYPE_PROPERTY_EXISTS = "property_exists";
    private static final String TYPE_PROPERTY_VALUE = "property_value";
    private static final Set<String> CONDITION_TYPES = new HashSet<String>();
    private static final String[] file_permission_types;
    private static final String[] binfile_extensions;
    private final File thefile;
    private final ArrayList<ReplaceText> replacetexts;
    private final ArrayList<Condition> conditions;
    private final String destpath;
    private final String destfilename;
    private final boolean isprojectfile;
    private final boolean binary;
    private final String[] linkedresource_files;
    private final String linkedresource_destpath;
    private final String[] filepermissions;
    private boolean isRemote;
    private final String remoteFile;

    static {
        CONDITION_TYPES.add(TYPE_PROPERTY_EXISTS);
        CONDITION_TYPES.add(TYPE_PROPERTY_VALUE);
        file_permission_types = new String[]{FILE_WRITABLE, FILE_READABLE, FILE_EXECUTABLE};
        binfile_extensions = new String[]{".zip", ".tar", ".gz", ".tgz", ".o", ".out", ".jar", ".png"};
    }

    public ProjectFile(File file, boolean isprojectfile, boolean binary, String destpath, String destfilename, String[] filepermissions, String linkedresource_destpath, String[] linkedresource_files, List<Object> texts, List<Object> conds, String remoteFile) {
        this.thefile = file;
        this.isprojectfile = isprojectfile;
        this.binary = binary;
        this.destpath = destpath;
        this.destfilename = destfilename;
        this.filepermissions = filepermissions;
        this.linkedresource_destpath = linkedresource_destpath;
        this.linkedresource_files = linkedresource_files;
        this.remoteFile = remoteFile;
        this.replacetexts = new ArrayList();
        int i = 0;
        while (i < texts.size()) {
            String var = ConfigUtil.lookupString((Object)texts.get(i), (String)"property_variable");
            String text = ConfigUtil.lookupString((Object)texts.get(i), (String)"text_pattern");
            String replace = ConfigUtil.lookupString((Object)texts.get(i), (String)"replace_pattern");
            String appendline_before = ConfigUtil.lookupString((Object)texts.get(i), (String)"appendline_before");
            String appendline_after = ConfigUtil.lookupString((Object)texts.get(i), (String)"appendline_after");
            ArrayList replaceConds = ConfigUtil.lookupList((Object)texts.get(i), (String)TAG_CONDITIONS);
            ConditionNode replaceConditions = null;
            if (replaceConds != null && !replaceConds.isEmpty()) {
                replaceConditions = this.parseConditionsRoot(replaceConds);
            }
            if (text != null && !text.isEmpty()) {
                this.replacetexts.add(new ReplaceText(text, replace, var, appendline_before, appendline_after, replaceConditions));
            }
            ++i;
        }
        this.conditions = new ArrayList();
        for (Object cond : conds) {
            String op;
            String value;
            String property;
            String type = ConfigUtil.lookupString((Object)cond, (String)"type");
            Condition condition = new Condition(type, property = ConfigUtil.lookupString((Object)cond, (String)"property"), value = ConfigUtil.lookupString((Object)cond, (String)TYPE_PROPERTY_VALUE), op = ConfigUtil.lookupString((Object)cond, (String)TAG_OP));
            if (condition.isValid()) {
                this.conditions.add(condition);
                continue;
            }
            String src = remoteFile != null ? remoteFile : file.getName();
            String msg = String.format("Invalid condition is found in the templatefile tag for [%s].", src);
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
        }
        if (this.thefile != null) {
            this.isRemote = false;
        }
        if (this.remoteFile != null) {
            this.isRemote = true;
        }
    }

    private ConditionNode parseConditionsRoot(Object o) {
        if (o instanceof List) {
            List conditions = (List)o;
            if (conditions.size() == 1) {
                if (conditions.get(0) instanceof List) {
                    return this.parseConditions(conditions.get(0));
                }
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", MSG_INTERNAL_ERR));
            } else {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Multiple conditions at the top level."));
            }
        }
        return null;
    }

    private ConditionNode parseConditions(Object o) {
        ConditionNode node = null;
        if (o instanceof List) {
            node = new ConditionNode(null, null);
            for (Object obj : (List)o) {
                if (obj instanceof Map) {
                    String msg;
                    ConditionNode n;
                    Map m = (Map)obj;
                    if (m.containsKey(TAG_CONDITIONS)) {
                        n = this.parseConditions(m.get(TAG_CONDITIONS));
                        if (n == null) continue;
                        node.nodes.add(n);
                        continue;
                    }
                    if (m.containsKey(TAG_COND)) {
                        n = this.parseCond(m.get(TAG_COND));
                        if (n == null) continue;
                        node.nodes.add(n);
                        continue;
                    }
                    if (m.containsKey(TAG_OP)) {
                        if (node.operator == null) {
                            node.operator = (String)m.get(TAG_OP);
                            continue;
                        }
                        msg = String.format(FMT_TAG_ALREADY_SPECIFIED, TAG_OP);
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                        continue;
                    }
                    msg = String.format(FMT_UNEXPECTED_TAG, m.keySet().iterator().next());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", MSG_INTERNAL_ERR));
            }
            if (node != null && node.operator == null) {
                node.operator = OP_AND;
            }
        }
        return node;
    }

    private ConditionNode parseCond(Object o) {
        LeafConditionNode node = null;
        if (o instanceof List) {
            node = new LeafConditionNode();
            for (Object oo : (List)o) {
                if (oo instanceof Map) {
                    String msg;
                    Map m = (Map)oo;
                    if (m.containsKey(TAG_VALUE_TEXT)) {
                        if (node.value_text == null) {
                            node.value_text = (String)m.get(TAG_VALUE_TEXT);
                            continue;
                        }
                        msg = String.format(FMT_TAG_ALREADY_SPECIFIED, TAG_VALUE_TEXT);
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                        continue;
                    }
                    if (m.containsKey(TAG_VALUE_PATTERN)) {
                        if (node.value_pattern == null) {
                            node.value_pattern = (String)m.get(TAG_VALUE_PATTERN);
                            continue;
                        }
                        msg = String.format(FMT_TAG_ALREADY_SPECIFIED, TAG_VALUE_PATTERN);
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                        continue;
                    }
                    if (m.containsKey(TAG_OP)) {
                        if (node.operator == null) {
                            node.operator = (String)m.get(TAG_OP);
                            continue;
                        }
                        msg = String.format(FMT_TAG_ALREADY_SPECIFIED, TAG_OP);
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                        continue;
                    }
                    msg = String.format(FMT_UNEXPECTED_TAG, m.keySet().iterator().next());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", MSG_INTERNAL_ERR));
            }
            if (node != null && (node.value_text == null || node.value_pattern == null)) {
                String msg = String.format("Missing [%s] and/or [%s] in %s tag.", TAG_VALUE_TEXT, TAG_VALUE_PATTERN, TAG_COND);
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                return null;
            }
        }
        return node;
    }

    private boolean isBinaryInWhiteList() {
        String name = this.thefile != null ? this.thefile.getName() : this.remoteFile;
        String[] stringArray = binfile_extensions;
        int n = binfile_extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (name.endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isBinaryFile(File file) throws IOException {
        if (this.isBinary() || this.isBinaryInWhiteList()) {
            return true;
        }
        return Utils.isBinaryFile(file);
    }

    public boolean isProjectFile() {
        return this.isprojectfile;
    }

    private boolean isBinary() {
        return this.binary;
    }

    private boolean isRemoteTemplateFile() {
        return this.isRemote;
    }

    public boolean isFileNeeded(ProjectData pdata, IProject project) {
        if (this.conditions != null && this.conditions.size() > 0) {
            for (Condition condition : this.conditions) {
                if (condition.isSatisfied(pdata)) continue;
                return false;
            }
        }
        return true;
    }

    public File copyFileToProjectDir(ProjectData pdata, IProject project, Map<String, String> properties) throws VIDEProjectException {
        if (project == null) {
            throw Utils.createFileAccessException("Insufficient project information ", null);
        }
        File file = this.isRemoteTemplateFile() ? this.getRemoteTemplateFile() : this.thefile;
        String filename = null;
        File destfile = null;
        try {
            try {
                Object projectpath = project.getLocation();
                String curdestpath = this.destpath;
                if (curdestpath != null) {
                    if (curdestpath.indexOf("{{") != -1) {
                        curdestpath = Utils.replaceContent(curdestpath, properties);
                    }
                    projectpath = new File(curdestpath).isAbsolute() ? new Path(curdestpath) : projectpath.append(curdestpath);
                }
                if (!projectpath.toFile().exists() && !projectpath.toFile().mkdirs()) {
                    throw Utils.createFileAccessException("Unable to create the file " + projectpath.toString(), null);
                }
                filename = this.isRemoteTemplateFile() ? new File(new URL(this.remoteFile).getFile()).getName() : this.thefile.getName();
                if (this.destfilename != null) {
                    filename = this.destfilename.indexOf("{{") != -1 ? Utils.replaceContent(this.destfilename, properties) : this.destfilename;
                }
                destfile = new File(projectpath.addTrailingSeparator().append(filename).toOSString());
                if (this.isBinaryFile(file) ? !Utils.copyFile(file, destfile, true, true) : !this.copyTextFile(project, pdata, file, destfile, true)) {
                    throw Utils.createFileAccessException("Unable to create the file " + destfile.getName(), null);
                }
                if (this.filepermissions != null && this.filepermissions.length > 0) {
                    int i = 0;
                    while (i < this.filepermissions.length) {
                        if (this.filepermissions[i].equals(FILE_EXECUTABLE)) {
                            destfile.setExecutable(true, false);
                        } else if (this.filepermissions[i].equals(FILE_READABLE)) {
                            destfile.setReadable(true, false);
                        } else if (this.filepermissions[i].equals(FILE_WRITABLE)) {
                            destfile.setWritable(true, false);
                        }
                        ++i;
                    }
                }
                this.createLinkedResourceInProject(project, (IPath)projectpath, destfile, properties);
            }
            catch (Exception e) {
                String msg = "Unable to access the file " + (file != null ? file.getName() : "");
                throw Utils.createFileAccessException(msg, e);
            }
        }
        finally {
            if (this.isRemoteTemplateFile() && file != null) {
                file.delete();
            }
        }
        return destfile;
    }

    private boolean copyTextFile(IProject project, ProjectData pdata, File srcfile, File destfile, boolean overwrite) throws VIDEProjectException {
        if (destfile == null || !overwrite && destfile.exists()) {
            return false;
        }
        String filecontent = Utils.getFileContent(srcfile, true);
        if (filecontent == null) {
            return false;
        }
        if (filecontent.indexOf("{{") != -1) {
            filecontent = Utils.replaceContent(filecontent, pdata.getPropertyValues(project));
        }
        if (this.replacetexts != null && this.replacetexts.size() > 0) {
            filecontent = this.replacePropertyValues(project, pdata, filecontent);
        }
        Writer fwriter = null;
        IOException err = null;
        try {
            try {
                fwriter = new BufferedWriter(new FileWriter(destfile));
                fwriter.write(filecontent);
            }
            catch (IOException e) {
                err = e;
                throw Utils.createFileAccessException("Unable to access the file " + srcfile.getName(), e);
            }
        }
        catch (Throwable throwable) {
            if (fwriter != null) {
                try {
                    fwriter.close();
                }
                catch (IOException e) {
                    try {
                        fwriter.close();
                    }
                    catch (IOException iOException) {}
                    if (err == null) {
                        err = e;
                    }
                    throw Utils.createFileAccessException("Unable to access the file " + srcfile.getName(), err);
                }
            }
            throw throwable;
        }
        if (fwriter != null) {
            try {
                fwriter.close();
            }
            catch (IOException e) {
                try {
                    fwriter.close();
                }
                catch (IOException iOException) {}
                if (err == null) {
                    err = e;
                }
                throw Utils.createFileAccessException("Unable to access the file " + srcfile.getName(), err);
            }
        }
        return true;
    }

    private String replacePropertyValues(IProject project, ProjectData pdata, String content) {
        int i = 0;
        while (i < this.replacetexts.size()) {
            content = this.replacetexts.get(i).replaceContent(project, pdata, content);
            ++i;
        }
        return content;
    }

    private File getRemoteTemplateFile() throws VIDEProjectException {
        URLConnection connection = null;
        try {
            connection = NetworkHelper.getUrlConnection((String)this.remoteFile);
        }
        catch (IOException e) {
            throw Utils.createFileAccessException(String.format("Failed connecting [%s].", this.remoteFile), e);
        }
        return this.downloadFile(connection);
    }

    private File downloadFile(URLConnection connection) {
        File f;
        block29: {
            String filename = new File(connection.getURL().getFile()).getName();
            f = null;
            InputStream in = null;
            try {
                f = File.createTempFile(filename, ".tmp");
                f.deleteOnExit();
                in = connection.getInputStream();
                Throwable throwable = null;
                Object var6_9 = null;
                try (FileOutputStream out = new FileOutputStream(f);){
                    int n;
                    byte[] b = new byte[1024];
                    while ((n = in.read(b)) != -1) {
                        out.write(b, 0, n);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                f.delete();
                f = null;
                String msg = e.getMessage();
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e));
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block29;
                }
                catch (IOException e2) {
                    String msg2 = String.format("Failed to close the input stream for [%s].", connection.getURL().toString());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg2, (Throwable)e2));
                }
                break block29;
            }
            catch (IOException e) {
                try {
                    String msg = String.format("Failed to copy the file [%s] -> [%s].", connection.getURL().toString(), f.getAbsolutePath());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e));
                    f.delete();
                    f = null;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e3) {
                        String msg = String.format("Failed to close the input stream for [%s].", connection.getURL().toString());
                        logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e3));
                    }
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block29;
                }
                catch (IOException e4) {
                    String msg = String.format("Failed to close the input stream for [%s].", connection.getURL().toString());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e4));
                }
                break block29;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                String msg = String.format("Failed to close the input stream for [%s].", connection.getURL().toString());
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e));
            }
        }
        return f;
    }

    public static List<Template> getTemplates(Object config, String sourcePath) {
        ArrayList<Template> templates = new ArrayList<Template>();
        ArrayList nodes = ConfigUtil.lookupList((Object)config, (String)"templatefile");
        if (nodes != null && nodes.size() > 0) {
            for (Object node : nodes) {
                String[] stringArray;
                String file = ConfigUtil.lookupString(node, (String)"file");
                String destpath = ConfigUtil.lookupString(node, (String)"destpath");
                String destfilename = ConfigUtil.lookupString(node, (String)"destfilename");
                String srcpath = ConfigUtil.lookupString(node, (String)"sourcepath");
                String filepermissiontext = ConfigUtil.lookupString(node, (String)"file_permission");
                boolean isprojectfile = ConfigUtil.lookupBoolean(node, (String)"projectfile", (String)"true", (boolean)false);
                boolean isRemote = ConfigUtil.lookupBoolean(node, (String)"remote", (String)"true", (boolean)false);
                boolean isrecursive = ConfigUtil.lookupBoolean(node, (String)"recursive", (String)"true", (boolean)false);
                boolean binary = ConfigUtil.lookupBoolean(node, (String)"binary", (String)"true", (boolean)false);
                boolean ignore_no_src = ConfigUtil.lookupBoolean(node, (String)"ignore_no_src", (String)"true", (boolean)false);
                String linkedresource_destpath = ConfigUtil.lookupString(node, (String)"linkedresource_destpath");
                String linkedresource_file = ConfigUtil.lookupString(node, (String)"linkedresource_file");
                if (linkedresource_file == null) {
                    stringArray = new String[]{};
                } else if (linkedresource_file.contains(";")) {
                    stringArray = linkedresource_file.split(";");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = linkedresource_file;
                }
                String[] linkedresource_files = stringArray;
                ArrayList texts = ConfigUtil.lookupList(node, (String)"replacetext");
                if (srcpath == null && file == null) {
                    String msg = String.format("%s and %s are not specified in the templatefile.", "sourcepath", "file");
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                    continue;
                }
                ArrayList conditions = ConfigUtil.lookupList(node, (String)"condition");
                for (Object o : conditions) {
                    String type = ConfigUtil.lookupString(o, (String)"type");
                    if (CONDITION_TYPES.contains(type)) continue;
                    StringBuilder sb = new StringBuilder();
                    if (srcpath != null) {
                        sb.append("sourcepath").append('=').append(srcpath);
                    }
                    if (file != null) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append("file").append('=').append(file);
                    }
                    String msg = String.format("The condition for the templatefile [%s] has invalid type [%s].", sb.toString(), type);
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                }
                Template template = new Template(sourcePath, file, destpath, destfilename, srcpath, filepermissiontext, isprojectfile, isRemote, isrecursive, binary, linkedresource_destpath, linkedresource_files, texts, conditions, ignore_no_src);
                templates.add(template);
            }
        }
        return templates;
    }

    public static List<ProjectFile> getProjectFiles(IProject project, List<Template> templates, ProjectData projectData) {
        ArrayList<ProjectFile> projfiles = new ArrayList<ProjectFile>();
        Hashtable<String, String> properties = projectData.getPropertyValues(project);
        if (templates != null && !templates.isEmpty()) {
            File srcpathfile = null;
            for (Template t : templates) {
                String srcpath = ProjectFile.safeReplace(t.getSourcepath(), properties);
                String file = ProjectFile.safeReplace(t.getFile(), properties);
                String permission = ProjectFile.safeReplace(t.getFilePermission(), properties);
                String destpath = ProjectFile.safeReplace(t.getDestpath(), properties);
                String destfile = ProjectFile.safeReplace(t.getDestfilename(), properties);
                boolean isprojectfile = t.isProjectfile();
                boolean binary = t.isBinary();
                List<Object> replacements = t.getReplacetexts();
                List<Object> conditions = t.getConditions();
                List<ProjectFile> files = null;
                try {
                    if (t.isRemote()) {
                        if (srcpath == null) {
                            System.out.println("Warning: sourcepath is not specified for the remote.");
                            continue;
                        }
                        files = ProjectFile.getFiles(srcpath, file, isprojectfile, binary, destpath, destfile, permission, replacements, conditions);
                    } else {
                        String rootsrcpath = ProjectFile.safeReplace(t.getBaseSourcePath(), properties);
                        if (srcpath != null) {
                            if (srcpathfile == null || !srcpathfile.toString().equals(srcpath)) {
                                srcpathfile = new File(srcpath);
                            }
                        } else if (srcpathfile == null && rootsrcpath != null) {
                            srcpathfile = new File(rootsrcpath);
                        }
                        if (!srcpathfile.exists() || !srcpathfile.isDirectory()) {
                            throw Utils.createFileAccessException("Unable to access the file " + srcpathfile.toString(), null);
                        }
                        files = ProjectFile.getFiles(srcpathfile, file, false, t.isRecursive(), isprojectfile, binary, t.ignoreNoSrc(), destpath, destfile, permission, t.getLinkedresourceDestpath(), t.getLinkedresourceFiles(), replacements, conditions);
                    }
                }
                catch (VIDEProjectException e) {
                    System.out.println(e.getMessage());
                }
                if (files == null) continue;
                projfiles.addAll(files);
            }
        }
        return projfiles;
    }

    private static String safeReplace(String content, Map<String, String> properties) {
        if (content == null) {
            return null;
        }
        return Utils.replaceContent(content, properties);
    }

    private static FilePatterns getFilePatterns(String text) {
        String[] patternTexts = null;
        if (text != null && !text.trim().isEmpty()) {
            patternTexts = text.split(";");
            FilePatterns filePatterns = new FilePatterns(patternTexts.length);
            int index = 0;
            String[] stringArray = patternTexts;
            int n = patternTexts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String pattern = ProjectFile.generateFilePattern(s);
                filePatterns.patterns[index] = Pattern.compile(pattern);
                filePatterns.matched[index] = false;
                ++index;
                ++n2;
            }
            return filePatterns;
        }
        return null;
    }

    private static String generateFilePattern(String s) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < s.length()) {
            if (s.substring(index).startsWith("**")) {
                sb.append(".*");
                index += 2;
                continue;
            }
            if (s.charAt(index) == '*') {
                sb.append("[\\w-]*");
            } else if (s.charAt(index) == '.') {
                sb.append("\\.");
            } else {
                sb.append(s.charAt(index));
            }
            ++index;
        }
        return sb.toString();
    }

    private static List<ProjectFile> getFiles(File templatepath, String text, boolean isdirectory, boolean isrecursive, boolean isprojectfile, boolean binary, boolean ignore_no_src, String destpath, String destfilename, String filepermissiontext, String linkedresource_destpath, String[] linkedresource_files, List<Object> texts, List<Object> conditions) throws VIDEProjectException {
        ArrayList<ProjectFile> projfiles = new ArrayList<ProjectFile>();
        if (templatepath == null) {
            throw Utils.createFileAccessException("Unable to access the file ", null);
        }
        FilePatterns filePatterns = ProjectFile.getFilePatterns(text);
        Hashtable<String, ArrayList<String>> ptable = ProjectFile.getFilePermissionTable(filepermissiontext);
        File[] files = templatepath.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                if (ProjectFile.isFilePatternMatched(files[i].getName(), filePatterns)) {
                    String[] permissions = ProjectFile.getFilePermissionUpdates(files[i].getName(), ptable);
                    projfiles.add(new ProjectFile(files[i], isprojectfile, binary, destpath, destfilename, permissions, linkedresource_destpath, linkedresource_files, texts, conditions, null));
                }
            } else if (isrecursive) {
                String subdestpath = destpath;
                if (subdestpath == null) {
                    subdestpath = files[i].getName();
                } else if (!new File(subdestpath).isAbsolute()) {
                    subdestpath = subdestpath.concat(File.separator).concat(files[i].getName());
                }
                List<ProjectFile> subfiles = ProjectFile.getFiles(files[i], text, isdirectory, isrecursive, isprojectfile, binary, ignore_no_src, subdestpath, destfilename, filepermissiontext, linkedresource_destpath, linkedresource_files, texts, conditions);
                if (subfiles.size() > 0) {
                    projfiles.addAll(subfiles);
                }
            }
            ++i;
        }
        if (filePatterns != null && !isrecursive && !ignore_no_src) {
            i = 0;
            while (i < filePatterns.matched.length) {
                if (!filePatterns.matched[i]) {
                    ILog log = ProjectPlugin.getDefault().getLog();
                    String msg = String.format("Could not find [%s] in [%s]", filePatterns.patterns[i].toString(), templatepath.getAbsolutePath());
                    Status status = new Status(2, "com.vmware.vide.project", msg);
                    log.log((IStatus)status);
                }
                ++i;
            }
        }
        return projfiles;
    }

    private static List<ProjectFile> getFiles(String url, String filenames, boolean isprojectfile, boolean binary, String destpath, String destfilename, String filepermissiontext, List<Object> texts, List<Object> conditions) throws VIDEProjectException {
        String[] files;
        ArrayList<ProjectFile> projfiles = new ArrayList<ProjectFile>();
        if (filenames == null || filenames.isEmpty()) {
            throw Utils.createFileAccessException("Unable to access the file ", null);
        }
        Hashtable<String, ArrayList<String>> ptable = ProjectFile.getFilePermissionTable(filepermissiontext);
        String[] stringArray = files = filenames.split(";");
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            String file = !url.endsWith(URL_SEPARATOR) ? String.valueOf(url) + URL_SEPARATOR + f : String.valueOf(url) + f;
            String[] permissions = ProjectFile.getFilePermissionUpdates(f, ptable);
            projfiles.add(new ProjectFile(null, isprojectfile, binary, destpath, destfilename, permissions, null, new String[0], texts, conditions, file));
            ++n2;
        }
        return projfiles;
    }

    private static boolean isFilePatternMatched(String filename, FilePatterns filepatterns) {
        if (filepatterns == null) {
            return true;
        }
        int i = 0;
        while (i < filepatterns.patterns.length) {
            if (filepatterns.patterns[i].matcher(filename).matches()) {
                filepatterns.matched[i] = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isFileMatched(String filename, String[] filepatterns) {
        if (filepatterns == null || filepatterns.length == 0) {
            return true;
        }
        int i = 0;
        while (i < filepatterns.length) {
            if (Pattern.matches(filepatterns[i], filename)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Hashtable<String, ArrayList<String>> getFilePermissionTable(String text) {
        Hashtable<String, ArrayList<String>> filepermissions = new Hashtable<String, ArrayList<String>>();
        if (text != null && !text.isEmpty()) {
            String[] group = null;
            group = text.indexOf("|") != -1 ? text.split("|") : new String[]{text};
            int i = 0;
            while (i < group.length) {
                String permissiontype = null;
                String grouptext = null;
                int j = 0;
                while (j < file_permission_types.length) {
                    if (group[i].startsWith(file_permission_types[j])) {
                        permissiontype = file_permission_types[j];
                        if (group[i].length() <= permissiontype.length() + 1) break;
                        grouptext = group[i].substring(permissiontype.length() + 1);
                        break;
                    }
                    ++j;
                }
                if (permissiontype != null && grouptext != null && !grouptext.isEmpty()) {
                    String[] filetypes = null;
                    filetypes = grouptext.indexOf(";") != -1 ? grouptext.split(";") : new String[]{grouptext};
                    ArrayList<String> types = new ArrayList<String>();
                    int j2 = 0;
                    while (j2 < filetypes.length) {
                        if (!filetypes[i].isEmpty()) {
                            types.add(filetypes[j2].replace("*", "[\\w-]+").trim());
                        }
                        ++j2;
                    }
                    if (filepermissions.containsKey(permissiontype)) {
                        filepermissions.get(permissiontype).addAll(types);
                    } else {
                        filepermissions.put(permissiontype, types);
                    }
                }
                ++i;
            }
        }
        return filepermissions;
    }

    public static String[] getFilePermissionUpdates(String filename, Hashtable<String, ArrayList<String>> filepermissiontable) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (filename != null && filepermissiontable != null && filepermissiontable.size() > 0) {
            Enumeration<String> e = filepermissiontable.keys();
            while (e.hasMoreElements()) {
                String permission = e.nextElement();
                ArrayList<String> files = filepermissiontable.get(permission);
                if (files.size() <= 0 || !ProjectFile.isFileMatched(filename, files.toArray(new String[files.size()]))) continue;
                permissions.add(permission);
            }
        }
        return permissions.toArray(new String[permissions.size()]);
    }

    public boolean createLinkedResourceInProject(IProject project, IPath destpath, File destfile, Map<String, String> properties) {
        if (destpath == null || project == null) {
            return false;
        }
        if (destpath.equals((Object)project.getLocation())) {
            return true;
        }
        String linkedfoldername = this.linkedresource_destpath;
        if (linkedfoldername != null && !linkedfoldername.isEmpty()) {
            IPath pysicalfolder;
            linkedfoldername = Utils.replaceContent(linkedfoldername, properties);
            IPath linkedfolder = project.getLocation().append(linkedfoldername);
            IPath iPath = pysicalfolder = this.linkedresource_files.length == 0 ? linkedfolder.removeLastSegments(1) : linkedfolder;
            if (!pysicalfolder.toFile().exists()) {
                pysicalfolder.toFile().mkdirs();
                try {
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (this.linkedresource_files.length == 0) {
                IFolder link = project.getFolder(linkedfoldername);
                return ProjectFile.createLinkedResource((IResource)link, destpath);
            }
        }
        if (this.linkedresource_files.length > 0) {
            boolean result = true;
            String[] stringArray = this.linkedresource_files;
            int n = this.linkedresource_files.length;
            int n2 = 0;
            while (n2 < n) {
                String linkedfile;
                IFile link;
                String filename = stringArray[n2];
                if (filename.contains("{{")) {
                    filename = Utils.replaceContent(filename, properties);
                }
                filename = filename.replace(".", "\\.").replace("*", ".+");
                if (destfile.getName().matches(filename) && !ProjectFile.createLinkedResource((IResource)(link = project.getFile(linkedfile = linkedfoldername != null ? new Path(linkedfoldername).append(destfile.getName()).toString() : destfile.getName())), destpath.append(destfile.getName()))) {
                    result = false;
                }
                ++n2;
            }
            return result;
        }
        return true;
    }

    private static boolean createLinkedResource(IResource resourcelink, IPath location) {
        if (resourcelink == null || location == null) {
            return false;
        }
        if (!location.toFile().exists()) {
            return false;
        }
        if (resourcelink.exists() && resourcelink.isLinked()) {
            if (!resourcelink.getRawLocation().equals((Object)location)) {
                System.err.println("Unable to overwrite a linked file or folder resource for " + location.toString() + ".  A file with the same name already exists (" + resourcelink.getRawLocation().toString() + ")");
                return false;
            }
            return true;
        }
        try {
            if (resourcelink instanceof IFolder) {
                ((IFolder)resourcelink).createLink(location, 0, (IProgressMonitor)new NullProgressMonitor());
            } else if (resourcelink instanceof IFile) {
                ((IFile)resourcelink).createLink(location, 0, (IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (CoreException e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    private class Condition {
        String condtype = null;
        String condproperty = null;
        String condvalue = null;
        boolean negate = false;

        public Condition(String type, String property, String value, String op) {
            if (CONDITION_TYPES.contains(type)) {
                this.condtype = type;
                if (property != null && !property.isEmpty()) {
                    this.condproperty = property;
                }
                if (value != null && !value.isEmpty()) {
                    this.condvalue = value;
                }
                if (op != null) {
                    this.negate = op.equals(ProjectFile.OP_NOT);
                }
            }
        }

        public boolean isValid() {
            if (this.condtype != null) {
                if (this.condtype.equals(ProjectFile.TYPE_PROPERTY_EXISTS)) {
                    return this.condproperty != null;
                }
                if (this.condtype.equals(ProjectFile.TYPE_PROPERTY_VALUE)) {
                    return this.condproperty != null && this.condvalue != null;
                }
            }
            return false;
        }

        public boolean isSatisfied(ProjectData data) {
            if (data != null) {
                if (this.condtype.equals(ProjectFile.TYPE_PROPERTY_EXISTS)) {
                    boolean exists;
                    boolean bl = exists = data.getPropertyValue(this.condproperty, null) != null;
                    return this.negate ? !exists : exists;
                }
                if (this.condtype.equals(ProjectFile.TYPE_PROPERTY_VALUE)) {
                    boolean match;
                    String value = data.getPropertyValue(this.condproperty, null);
                    boolean bl = match = (value = Utils.replaceContent(value, data.getPropertyValues(null))) != null && value.equals(this.condvalue);
                    return this.negate ? !match : match;
                }
            }
            return false;
        }
    }

    private class ConditionNode {
        String operator;
        List<ConditionNode> nodes = new ArrayList<ConditionNode>();

        private ConditionNode() {
        }

        boolean isNotOp() {
            return ProjectFile.OP_NOT.equals(this.operator);
        }

        boolean isAndOp() {
            return ProjectFile.OP_AND.equals(this.operator);
        }

        /* synthetic */ ConditionNode(ConditionNode conditionNode, ConditionNode conditionNode2) {
            this();
        }
    }

    private static class FilePatterns {
        final Pattern[] patterns;
        final boolean[] matched;

        FilePatterns(int num) {
            this.patterns = new Pattern[num];
            this.matched = new boolean[num];
        }
    }

    private class LeafConditionNode
    extends ConditionNode {
        String value_text;
        String value_pattern;

        private LeafConditionNode() {
        }
    }

    private class ReplaceText {
        private static final String WARN_NO_PATTERN = "Warning: could not find the pattern[%s] in [%s].";
        private final String text_pattern;
        private final String replace_pattern;
        private final String property_var;
        private final String appendline_before;
        private final String appendline_after;
        private final ConditionNode replaceConditions;

        public ReplaceText(String text, String replace, String property, String before, String after, ConditionNode replaceConditions) {
            this.text_pattern = this.Dequotes(text);
            this.replace_pattern = this.Dequotes(replace);
            this.property_var = property;
            this.appendline_before = this.Dequotes(before);
            this.appendline_after = this.Dequotes(after);
            this.replaceConditions = replaceConditions;
        }

        private String Dequotes(String s) {
            if (s != null && this.isQuoted(s)) {
                return s.substring(1, s.length() - 1);
            }
            return s;
        }

        private boolean isQuoted(String s) {
            char c;
            int len = s.length();
            return len >= 2 && (c = s.charAt(0)) == s.charAt(len - 1) && (c == '\'' || c == '\"');
        }

        public String replaceContent(IProject project, ProjectData pdata, String content) {
            if (this.replaceConditions != null && !this.evalConditions(project, pdata)) {
                return content;
            }
            String replace_text = "";
            String pvalue = null;
            if (this.isAppendContent()) {
                StringBuilder before = new StringBuilder();
                if (this.appendline_before != null) {
                    before.append("\n");
                    before.append(Utils.replaceContent(this.appendline_before, pdata.getPropertyValues(project)));
                    before.append("\n");
                }
                StringBuilder after = new StringBuilder();
                if (this.appendline_after != null) {
                    after.append("\n");
                    after.append(Utils.replaceContent(this.appendline_after, pdata.getPropertyValues(project)));
                    after.append("\n");
                }
                int[] occurred = new int[1];
                String translated = Utils.appendString(content, this.text_pattern, before.toString(), after.toString(), occurred);
                if (occurred[0] == 0) {
                    System.out.println(String.format(WARN_NO_PATTERN, this.text_pattern, ProjectFile.this.thefile.getAbsolutePath()));
                }
                return translated;
            }
            if (this.property_var != null && !this.property_var.isEmpty()) {
                pvalue = pdata.getPropertyValue(this.property_var, project);
            }
            if (this.replace_pattern != null) {
                String pattern = this.replace_pattern;
                if (pattern.contains("{{")) {
                    pattern = Utils.replaceContent(pattern, pdata.getPropertyValues(project));
                }
                replace_text = pattern.contains("{{VALUE}}") && pvalue != null && !pvalue.isEmpty() ? pattern.replace("{{VALUE}}", pvalue) : pattern;
            } else if (pvalue != null) {
                replace_text = pvalue;
            }
            if (this.text_pattern != null) {
                if (content.indexOf(this.text_pattern) != -1) {
                    content = content.replace(this.text_pattern, replace_text);
                } else {
                    System.out.println(String.format(WARN_NO_PATTERN, this.text_pattern, ProjectFile.this.thefile.getAbsolutePath()));
                }
            }
            return content;
        }

        private boolean evaluateNode(IProject project, ProjectData pdata, ConditionNode node) {
            boolean result = node.isAndOp();
            for (ConditionNode cond : node.nodes) {
                if (cond instanceof LeafConditionNode) {
                    LeafConditionNode leaf = (LeafConditionNode)cond;
                    String pattern = Utils.replaceContent(leaf.value_pattern, pdata.getPropertyValues(project));
                    String text = Utils.replaceContent(leaf.value_text, pdata.getPropertyValues(project));
                    result = leaf.isNotOp() ? !text.matches(pattern) : text.matches(pattern);
                } else {
                    result = this.evaluateNode(project, pdata, cond);
                }
                if (node.isAndOp()) {
                    if (result) continue;
                    return false;
                }
                if (!result) continue;
                return true;
            }
            return result;
        }

        private boolean evalConditions(IProject project, ProjectData pdata) {
            return this.evaluateNode(project, pdata, this.replaceConditions);
        }

        public boolean isAppendContent() {
            return (this.appendline_before != null && !this.appendline_before.isEmpty() || this.appendline_after != null && !this.appendline_after.isEmpty()) && this.text_pattern != null && !this.text_pattern.isEmpty();
        }
    }
}

