/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.project.config.devkit.AbstractCommandRunner;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.utils.symbol.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShellCommandRunner
extends AbstractCommandRunner {
    public static final String COMMAND_ID = "shcommand";
    private static ShellCommandRunner shellcommand = new ShellCommandRunner();

    public ShellCommandRunner() {
        super(COMMAND_ID);
    }

    public static ShellCommandRunner getDefault() {
        return shellcommand;
    }

    @Override
    public IStatus execute(Shell shell, IProject project, String command, int sequence, Map<String, String> commandproperties, Map<String, String> envs, IProgressMonitor monitor) throws Exception {
        if (command == null || command.isEmpty()) {
            throw Utils.createCommandExecutionException("Insufficient information ", null);
        }
        try {
            String stdoutput;
            monitor.beginTask(command, 100);
            this.writeMsgInDefaultConsole("$ ".concat(command), null);
            ProcessBuilder procbuilder = new ProcessBuilder(StringUtil.convertCommandLineToCommandAndArgs((String)command));
            procbuilder.directory(this.getExecPath(project, commandproperties));
            Map<String, String> environments = procbuilder.environment();
            this.configureEnvironments(environments, envs);
            monitor.worked(10);
            Process process = procbuilder.start();
            final BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Thread erroutthread = new Thread(){
                Color red = null;

                @Override
                public void run() {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Display display = Display.getCurrent();
                            if (display != null) {
                                red = display.getSystemColor(3);
                            }
                        }
                    });
                    try {
                        String erroutput;
                        while ((erroutput = error.readLine()) != null) {
                            ShellCommandRunner.this.writeMsgInDefaultConsole(erroutput, this.red);
                        }
                    }
                    catch (IOException e) {
                        System.err.print(e.getMessage());
                    }
                }
            };
            erroutthread.start();
            monitor.worked(10);
            BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((stdoutput = output.readLine()) != null) {
                this.writeMsgInDefaultConsole(stdoutput, null);
            }
            monitor.worked(80);
            if (project != null) {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    private File getExecPath(IProject project, Map<String, String> commandproperties) {
        File execpath;
        File projectpath = project.getLocation().toFile();
        String pathname = commandproperties.get("ExecutePath");
        if (pathname == null || pathname.isEmpty()) {
            return projectpath;
        }
        if (pathname.indexOf("PROJECT_PATH") >= 0) {
            HashMap<String, String> projproperties = new HashMap<String, String>();
            projproperties.put("PROJECT_PATH", projectpath.getAbsolutePath());
            pathname = Utils.replaceContent(pathname, projproperties);
        }
        if ((execpath = new File(pathname)).exists() && execpath.isDirectory()) {
            return execpath;
        }
        return projectpath;
    }
}

