/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectNaturePath {
    private static final String TAG_TYPE = "type";
    private static final String TAG_TITLE = "title";
    private static final String TAG_DESC = "description";
    private static final String TAG_NAME = "name";
    private static final String TAG_STORE = "store";
    private static final String TAG_INIT = "init";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_FILTER_NAME = "filter_name";
    private static final String TAG_EXISTS = "exists";
    private static final String ERR_INSUFFICIENT_INFO = "Insufficient information [%s]";
    private static final String ERR_MISSING_FILTER_NAME = "Filter name is not specified for the filter [%s].";
    private static final String TAG_PREFIX = "projectnature.path.";
    private String natureid;
    private String type;
    private String title;
    private String desc;
    private String name;
    private boolean store;
    private String init;
    private String filter;
    private String filter_name;
    private boolean exists;

    public ProjectNaturePath(String natureid, Map<String, String> path) throws VIDEProjectException {
        this.natureid = natureid;
        this.type = path.get(TAG_TYPE);
        this.title = path.get(TAG_TITLE);
        if (this.title == null || this.title.isEmpty()) {
            throw Utils.createProjectNatureException(String.format(ERR_INSUFFICIENT_INFO, "projectnature.path.title"), null);
        }
        this.desc = path.get(TAG_DESC);
        this.name = path.get(TAG_NAME);
        if (this.name == null || this.name.isEmpty()) {
            throw Utils.createProjectNatureException(String.format(ERR_INSUFFICIENT_INFO, "projectnature.path.name"), null);
        }
        this.store = Boolean.parseBoolean(path.get(TAG_STORE));
        this.init = path.get(TAG_INIT);
        if (this.init == null || this.init.isEmpty()) {
            throw Utils.createProjectNatureException(String.format(ERR_INSUFFICIENT_INFO, "projectnature.path.init"), null);
        }
        this.filter = path.get(TAG_FILTER);
        this.filter_name = path.get(TAG_FILTER_NAME);
        if (this.filter != null && !this.filter.isEmpty() && (this.filter_name == null || this.filter_name.isEmpty())) {
            throw Utils.createProjectNatureException(String.format(ERR_MISSING_FILTER_NAME, this.filter), null);
        }
        this.exists = Boolean.parseBoolean(path.get(TAG_EXISTS));
    }

    public String getInitialPath() {
        IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
        String path = store.getString(this.getKey());
        if (path.isEmpty()) {
            return this.init;
        }
        return path;
    }

    public void updateInitialPath(String path) {
        if (this.store) {
            IPreferenceStore store = ProjectPlugin.getDefault().getPreferenceStore();
            store.setValue(this.getKey(), path);
        }
    }

    private String getKey() {
        return String.valueOf(this.natureid) + "." + this.name;
    }

    public boolean isDir() {
        return this.type.equals("dir");
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStore() {
        return this.store;
    }

    public String getInit() {
        return this.init;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getFilterName() {
        return this.filter_name;
    }

    public boolean isRequired() {
        return this.exists;
    }
}

