/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.devkit.ProjectMenu;
import com.vmware.vide.project.config.resource.AbstractProjectResource;
import com.vmware.vide.project.config.resource.FileResource;
import com.vmware.vide.project.config.resource.ProjectPropertyResource;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import org.eclipse.core.resources.IProject;

public class MenuResource {
    public static final int CREATE_WHEN_UNAVAILABLE = 0;
    public static final int CREATE_WHEN_ALWAYS = 1;
    private ProjectMenu parent;
    private String resourceid;
    private String name;
    private boolean create;
    private int create_when;
    private boolean create_ask;
    private boolean required;
    private AbstractProjectResource resourceinfo;

    public MenuResource(ProjectMenu parent, Object config) {
        this.parent = parent;
        this.resourceid = ConfigUtil.lookupString((Object)config, (String)"type");
        this.name = ConfigUtil.lookupString((Object)config, (String)"name");
        String resouce_create = ConfigUtil.lookupString((Object)config, (String)"create_when");
        if (resouce_create != null) {
            if (resouce_create.equals("always")) {
                this.create = true;
                this.create_when = 1;
                this.create_ask = false;
            } else if (resouce_create.equals("always_ask")) {
                this.create = true;
                this.create_when = 1;
                this.create_ask = true;
            } else if (resouce_create.equals("unavailable")) {
                this.create = true;
                this.create_when = 0;
                this.create_ask = false;
            } else if (resouce_create.equals("unavailable_ask")) {
                this.create = true;
                this.create_when = 0;
                this.create_ask = true;
            } else {
                this.create = false;
            }
        } else {
            this.create = false;
        }
        this.required = ConfigUtil.lookupBoolean((Object)config, (String)"required", (String)"true", (boolean)false);
        this.resourceinfo = this.getResource();
    }

    public boolean isValid() {
        return this.resourceid != null;
    }

    public boolean isAvailable(IProject project) {
        if (this.resourceinfo == null) {
            this.resourceinfo = this.getResource();
        }
        if (this.resourceinfo != null) {
            return this.resourceinfo.isAvailable(project);
        }
        return false;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canCreate() {
        return this.create;
    }

    private STATUS createIfNotAvailable(IProject project) {
        if (this.resourceinfo == null) {
            this.resourceinfo = this.getResource();
        }
        if (this.resourceinfo != null) {
            if (this.resourceinfo.isAvailable(project)) {
                return STATUS.OK;
            }
            if (!this.create) {
                return STATUS.ERROR;
            }
            try {
                return this.resourceinfo.createDefault(project, this.getCreateWhen(), this.isCreateAsk());
            }
            catch (VIDEProjectException e) {
                Utils.openDialog(e);
            }
        }
        return STATUS.ERROR;
    }

    private AbstractProjectResource getResource() {
        try {
            if (this.resourceid.equals("file")) {
                return new FileResource(this.name);
            }
            if (this.resourceid.equals("project_property")) {
                return new ProjectPropertyResource(this.name);
            }
            return this.parent.getResource(this.resourceid);
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    private boolean isCreateAsk() {
        return this.create_ask;
    }

    public int getCreateWhen() {
        return this.create_when;
    }

    public boolean isCreateAlways() {
        return this.create_when == 1;
    }

    private boolean isCreateUnavailable() {
        return this.create_when == 0;
    }

    public STATUS createResources(IProject project) {
        if (this.isCreateUnavailable()) {
            return this.createIfNotAvailable(project);
        }
        try {
            return this.resourceinfo.createDefault(project, this.getCreateWhen(), this.isCreateAsk());
        }
        catch (VIDEProjectException e) {
            Utils.openDialog(e);
            return STATUS.ERROR;
        }
    }

    public static enum STATUS {
        OK,
        ERROR,
        USERCANCEL;

    }
}

