/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;

public abstract class UpdateAPIReferenceList
implements IStartup {
    private final List<String> symlinkDirs = new ArrayList<String>();
    private File bundleDir;

    public abstract String getReferenceListDir();

    public abstract String getBaseDir();

    public abstract String getDirectoryPattern();

    public abstract String getIndexFileRelativePath();

    public abstract String getReferenceListFileName();

    public abstract String getTitle();

    public abstract IndexFile createIndexFile(File var1, Matcher var2);

    public abstract String getIndexTitle(IndexFile var1);

    public abstract String getProviderId();

    public void earlyStartup() {
        File base = new File(this.getBaseDir());
        if (!base.exists()) {
            return;
        }
        final Pattern pattern = Pattern.compile(this.getDirectoryPattern());
        final ArrayList<IndexFile> indexFiles = new ArrayList<IndexFile>();
        base.listFiles(new FileFilter(){

            @Override
            public boolean accept(File devkitDir) {
                File f;
                Matcher m = pattern.matcher(devkitDir.getName());
                if (m.matches() && (f = new File(String.valueOf(devkitDir.getPath()) + '/' + UpdateAPIReferenceList.this.getIndexFileRelativePath(devkitDir.getAbsolutePath()))).exists() && f.isFile()) {
                    IndexFile indexFile = UpdateAPIReferenceList.this.createIndexFile(f, m);
                    indexFiles.add(indexFile);
                    return true;
                }
                return false;
            }
        });
        this.generateReferenceListFile(indexFiles);
    }

    public String getIndexFileRelativePath(String parent) {
        return this.getIndexFileRelativePath();
    }

    protected String getRelativePath(IndexFile file) {
        Path base = new Path(this.getBaseDir());
        Path p = new Path(file.file.getAbsolutePath());
        IPath path = p.makeRelativeTo((IPath)base);
        return path.toPortableString();
    }

    private void generateReferenceListFile(List<IndexFile> indexFiles) {
        File listFile;
        block11: {
            File listDir = new File(this.getReferenceListDir());
            if (!listDir.exists() && !listDir.mkdirs()) {
                return;
            }
            this.bundleDir = this.getBundleDir();
            if (this.bundleDir == null) {
                return;
            }
            listDir.setWritable(true, false);
            listFile = new File(String.valueOf(this.getReferenceListDir()) + '/' + this.getReferenceListFileName());
            PrintWriter writer = null;
            try {
                try {
                    writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
                    writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                    writer.println("<html>");
                    writer.println("<head>");
                    writer.print("<title>");
                    writer.print(this.getTitle());
                    writer.println("</title>");
                    writer.println("</head>");
                    writer.println("<body>");
                    for (IndexFile index : indexFiles) {
                        writer.println("<li>");
                        writer.print("<a href=\"");
                        String relativePath = this.getRelativePath(index);
                        this.createSymLinkToIndexFileDirectory(this.bundleDir, index, relativePath);
                        this.symlinkDirs.add(new File(relativePath).getParent());
                        writer.print(relativePath);
                        writer.print("\">");
                        writer.print(this.getIndexTitle(index));
                        writer.println("</a>");
                        writer.println("</li>");
                    }
                    writer.println("</body>");
                    writer.println("</html>");
                }
                catch (IOException iOException) {
                    String name = "Clean up help plug-in directory [" + this.bundleDir.getAbsolutePath() + "].";
                    Runtime.getRuntime().addShutdownHook(new Cleanup(name));
                    if (writer != null) {
                        writer.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                String name = "Clean up help plug-in directory [" + this.bundleDir.getAbsolutePath() + "].";
                Runtime.getRuntime().addShutdownHook(new Cleanup(name));
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            String name = "Clean up help plug-in directory [" + this.bundleDir.getAbsolutePath() + "].";
            Runtime.getRuntime().addShutdownHook(new Cleanup(name));
            if (writer != null) {
                writer.close();
            }
        }
        listFile.setWritable(true, false);
    }

    protected void createSymLinkToIndexFileDirectory(File bundleDir, IndexFile index, String relativePath) {
        File file = new File(bundleDir, new File(relativePath).getPath());
        File linkDir = file.getParentFile();
        if (linkDir.exists()) {
            return;
        }
        File dir = linkDir.getParentFile();
        dir.mkdirs();
        try {
            Files.createSymbolicLink(linkDir.toPath(), index.getFile().getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException iOException) {}
    }

    protected File getBundleDir() {
        File dir = null;
        String bundleName = this.getProviderId();
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            try {
                dir = FileLocator.getBundleFile((Bundle)bundle);
                if (!dir.isDirectory()) {
                    return null;
                }
            }
            catch (IOException iOException) {}
        }
        return dir;
    }

    class Cleanup
    extends Thread {
        Cleanup(String name) {
            super(name);
        }

        @Override
        public void run() {
            if (UpdateAPIReferenceList.this.bundleDir == null) {
                return;
            }
            for (String symlinkDir : UpdateAPIReferenceList.this.symlinkDirs) {
                try {
                    java.nio.file.Path symlinkPath = new File(UpdateAPIReferenceList.this.bundleDir, symlinkDir).toPath();
                    Files.delete(symlinkPath);
                    java.nio.file.Path dir = symlinkPath.getParent();
                    while (UpdateAPIReferenceList.this.bundleDir.toPath().compareTo(dir) != 0) {
                        Files.delete(dir);
                        dir = dir.getParent();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public class IndexFile {
        String buildNumber;
        String versionNumber;
        File file;

        public IndexFile(File f, String versionNumber, String buildNumber) {
            this.file = f;
            this.buildNumber = buildNumber;
            this.versionNumber = versionNumber;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public File getFile() {
            return this.file;
        }
    }
}

