/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy.debug.ui;

import com.vmware.vide.deploy.AutoDeployOperation;
import com.vmware.vide.deploy.AutoDeployOperationData;
import com.vmware.vide.deploy.DeployExportSettingsWizard;
import com.vmware.vide.deploy.FileDeploySelectionDialog;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.IFileDeployExportDataReader;
import com.vmware.vide.deploy.debug.DebuggerAutoDeployOperation;
import com.vmware.vide.deploy.debug.DebuggerFileExportDataReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AutoDeployTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_ID = "com.vmware.vide.debug.autodeploy.tab";
    private static final String AUTO_DEPLOY_TAB_TITLE = "&Auto Deploy Settings";
    public static final String AUTO_DEPLOY_OPERATIONS_TABLE_NAME = "AutoDeployOperationsTable";
    private static final String AUTO_DEPLOY_OPERATIONS_GROUP_NAME = "Auto deploy operations";
    private static final String COPY_FROM_BUTTON_TEXT = "&Copy from ...";
    private static final String EDIT_OPERATION_BUTTON_TEXT = "&Edit Operation...";
    private static final String NEW_OPERATION_BUTTON_TEXT = "&New Operation...";
    private static final String DELETE_BUTTON_TEXT = "&Delete";
    private static final String UP_BUTTON_TEXT = "&Up";
    private static final String DOWN_BUTTON_TEXT = "&Down";
    private static final String COPY_FROM_BUTTON_DESC = "Copy a deploy operation from the workspace.";
    private static final String EDIT_OPERATION_BUTTON_DESC = "Edit the selected auto deploy operation.";
    private static final String NEW_OPERATION_BUTTON_DESC = "Add a new auto deploy operation.";
    private static final String DELETE_BUTTON_DESC = "Delete the selected auto deploy operation.";
    private static final String UP_BUTTON_DESC = "Move up the selected auto deploy operation.";
    private static final String DOWN_BUTTON_DESC = "Move down the selected auto deploy operation.";
    private static final String CHECK_ALL_BUTTON_TEXT = "Check &All";
    private static final String UNCHECK_ALL_BUTTON_TEXT = "&Uncheck All";
    private static final String CHECK_ALL_BUTTON_DESC = "Check all auto deploy operations.";
    private static final String UNCHECK_ALL_BUTTON_DESC = "Uncheck all auto deploy operations.";
    private static final String ATTR = "com.vmware.vide.debug.autodeploy.attr.";
    public static final int DEBUG_AUTO_DEPLOY_ORDER_DISABLE_PROJECT_AUTO_DEPLOY = 0;
    public static final int DEBUG_AUTO_DEPLOY_ORDER_AFTER_PROJECT_AUTO_DEPLOY = 1;
    public static final int DEBUT_AUTO_DEPLOY_ORDER_BEFORE_PROJECT_AUTO_DEPLOY = 2;
    public static final int DEBUG_AUTO_DEPLOY_ORDER_DEFAULT = 1;
    public static final String DEBUG_AUTO_DEPLOY_OPERATIONS_ATTR = "com.vmware.vide.debug.autodeploy.attr.operations";
    private static final String DEFAULT_OP_PREFIX = "op";
    private CheckboxTableViewer fAutoDeployOperationsTable;
    private Button fCopyFromButton;
    private Button fEditCommandsButton;
    private Button fNewOperationButton;
    private Button fDeleteButton;
    private Button fUpButton;
    private Button fDownButton;
    private boolean okUpdatePage = true;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setFont(parent.getFont());
        this.createAutoDeployOperationsGroup(comp);
    }

    private void createAutoDeployOperationsGroup(Composite parent) {
        Group group = this.createGroup(parent, AUTO_DEPLOY_OPERATIONS_GROUP_NAME, 2, 1, 1808);
        ScrolledComposite sc = new ScrolledComposite((Composite)group, 768);
        this.fAutoDeployOperationsTable = CheckboxTableViewer.newCheckList((Composite)sc, (int)67618);
        Control table = this.fAutoDeployOperationsTable.getControl();
        table.setFont(parent.getFont());
        table.setData("name", (Object)AUTO_DEPLOY_OPERATIONS_TABLE_NAME);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 7;
        gd.heightHint = this.fAutoDeployOperationsTable.getTable().getItemHeight() * 7;
        sc.setLayoutData((Object)gd);
        sc.setContent(table);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.fAutoDeployOperationsTable.setContentProvider((IContentProvider)new AutoDeployOperationsContentProvider());
        this.fAutoDeployOperationsTable.setLabelProvider((IBaseLabelProvider)new AutoDeployOperationsLabelProvider());
        this.fAutoDeployOperationsTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object o = event.getElement();
                if (o instanceof DebuggerAutoDeployOperation) {
                    ((DebuggerAutoDeployOperation)o).setEnable(event.getChecked());
                }
                AutoDeployTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAutoDeployOperationsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AutoDeployTab.this.updatePageBySelection(event);
            }
        });
        this.fAutoDeployOperationsTable.getTable().addMouseTrackListener((MouseTrackListener)new MouseHoverListener());
        this.fNewOperationButton = this.createPushButton((Composite)group, NEW_OPERATION_BUTTON_TEXT, NEW_OPERATION_BUTTON_DESC);
        this.fNewOperationButton.addSelectionListener((SelectionListener)new NewButtonListener());
        this.fEditCommandsButton = this.createPushButton((Composite)group, EDIT_OPERATION_BUTTON_TEXT, EDIT_OPERATION_BUTTON_DESC);
        this.fEditCommandsButton.setEnabled(false);
        this.fEditCommandsButton.addSelectionListener((SelectionListener)new EditOperationButtonListener());
        this.fCopyFromButton = this.createPushButton((Composite)group, COPY_FROM_BUTTON_TEXT, COPY_FROM_BUTTON_DESC);
        this.fCopyFromButton.addSelectionListener((SelectionListener)new CopyButtonListener());
        this.fDeleteButton = this.createPushButton((Composite)group, DELETE_BUTTON_TEXT, DELETE_BUTTON_DESC);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.addSelectionListener((SelectionListener)new DeleteButtonListener());
        this.fUpButton = this.createPushButton((Composite)group, UP_BUTTON_TEXT, UP_BUTTON_DESC);
        this.fUpButton.setEnabled(false);
        this.fUpButton.addSelectionListener((SelectionListener)new UpDownButtonsListener());
        this.fDownButton = this.createPushButton((Composite)group, DOWN_BUTTON_TEXT, DOWN_BUTTON_DESC);
        this.fDownButton.setEnabled(false);
        this.fDownButton.addSelectionListener((SelectionListener)new UpDownButtonsListener());
        new Button((Composite)group, 0).setVisible(false);
        Composite checks = new Composite((Composite)group, 0);
        checks.setFont(group.getFont());
        checks.setLayout((Layout)new GridLayout(3, true));
        CheckButtonListener listener = new CheckButtonListener();
        Button b = this.createPushButton(checks, CHECK_ALL_BUTTON_TEXT, CHECK_ALL_BUTTON_DESC);
        b.addSelectionListener((SelectionListener)listener);
        b = this.createPushButton(checks, UNCHECK_ALL_BUTTON_TEXT, UNCHECK_ALL_BUTTON_DESC);
        b.addSelectionListener((SelectionListener)listener);
    }

    private Button createPushButton(Composite parent, String name, String desc) {
        Button b = super.createPushButton(parent, name, null);
        b.setToolTipText(desc);
        return b;
    }

    public Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private void updatePageBySelection(SelectionChangedEvent event) {
        IStructuredSelection iss = (IStructuredSelection)this.fAutoDeployOperationsTable.getSelection();
        if (iss.isEmpty()) {
            this.fDeleteButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
            this.fEditCommandsButton.setEnabled(false);
        } else if (iss.size() == 1) {
            this.fDeleteButton.setEnabled(true);
            if (this.fAutoDeployOperationsTable.getTable().getItemCount() == 1) {
                this.fUpButton.setEnabled(false);
                this.fDownButton.setEnabled(false);
            } else {
                if (this.fAutoDeployOperationsTable.getTable().getSelectionIndex() == 0) {
                    this.fUpButton.setEnabled(false);
                } else {
                    this.fUpButton.setEnabled(true);
                }
                if (this.fAutoDeployOperationsTable.getTable().getSelectionIndex() == this.fAutoDeployOperationsTable.getTable().getItemCount() - 1) {
                    this.fDownButton.setEnabled(false);
                } else {
                    this.fDownButton.setEnabled(true);
                }
            }
            this.fEditCommandsButton.setEnabled(true);
        } else if (iss.size() > 1) {
            this.fDeleteButton.setEnabled(true);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
            this.fEditCommandsButton.setEnabled(false);
        }
    }

    private int getTheFirstSelectionIndex() {
        if (this.fAutoDeployOperationsTable.getTable().getSelectionCount() == 0) {
            return -1;
        }
        int[] indices = this.fAutoDeployOperationsTable.getTable().getSelectionIndices();
        Arrays.sort(indices);
        return indices[0];
    }

    private void moveItem(int oldIndex, int newIndex) {
        Object o = this.fAutoDeployOperationsTable.getElementAt(oldIndex);
        this.fAutoDeployOperationsTable.remove(o);
        this.fAutoDeployOperationsTable.insert(o, newIndex);
        this.fAutoDeployOperationsTable.getTable().setSelection(newIndex);
        this.sendElementSelectionEvent(newIndex);
    }

    private void sendElementSelectionEvent(int index) {
        Event event = new Event();
        event.index = index;
        this.fAutoDeployOperationsTable.getTable().notifyListeners(13, event);
    }

    private void insertOperation(AutoDeployOperationData data, boolean enable) {
        DebuggerAutoDeployOperation o = new DebuggerAutoDeployOperation(data, enable);
        this.fAutoDeployOperationsTable.insert((Object)o, this.getTheFirstSelectionIndex());
        this.fAutoDeployOperationsTable.setChecked((Object)o, enable);
        this.updateLaunchConfigurationDialog();
    }

    private ArrayList<String> getAutoDeployOperationsList() {
        ArrayList<String> ops = new ArrayList<String>();
        int i = 0;
        while (i < this.fAutoDeployOperationsTable.getTable().getItemCount()) {
            Object o = this.fAutoDeployOperationsTable.getElementAt(i);
            if (o instanceof DebuggerAutoDeployOperation) {
                ops.add(((DebuggerAutoDeployOperation)o).toInitializeString());
            } else {
                System.err.println("Unsupported data element: " + o);
            }
            ++i;
        }
        return ops;
    }

    private void setAutoDeployOperationsList(ArrayList<String> initStrings) {
        Iterator<String> iterator = initStrings.iterator();
        while (iterator.hasNext()) {
            DebuggerAutoDeployOperation operation = new DebuggerAutoDeployOperation();
            String initStr = iterator.next();
            if (operation.initializeFromString(initStr) == null) continue;
            this.fAutoDeployOperationsTable.add((Object)operation);
            this.fAutoDeployOperationsTable.setChecked((Object)operation, operation.isEnabled());
        }
    }

    private ArrayList<DebuggerAutoDeployOperation> getDebuggerAutoDeployOperations() {
        ArrayList<DebuggerAutoDeployOperation> ops = new ArrayList<DebuggerAutoDeployOperation>();
        int i = 0;
        while (i < this.fAutoDeployOperationsTable.getTable().getItemCount()) {
            Object o = this.fAutoDeployOperationsTable.getElementAt(i);
            if (o instanceof DebuggerAutoDeployOperation) {
                ops.add((DebuggerAutoDeployOperation)o);
            }
            ++i;
        }
        return ops;
    }

    private void clearAutoDeployOperations() {
        this.fAutoDeployOperationsTable.setAllChecked(true);
        Object[] objects = this.fAutoDeployOperationsTable.getCheckedElements();
        this.fAutoDeployOperationsTable.remove(objects);
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.okToUpdate()) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private void setOkToUpdate(boolean state) {
        this.okUpdatePage = state;
    }

    private boolean okToUpdate() {
        return this.okUpdatePage;
    }

    public String getName() {
        return AUTO_DEPLOY_TAB_TITLE;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.setOkToUpdate(false);
            ArrayList operations = new ArrayList();
            try {
                operations = (ArrayList)config.getAttribute(DEBUG_AUTO_DEPLOY_OPERATIONS_ATTR, new ArrayList());
            }
            catch (Exception e) {
                System.err.println("Failed to get the attr: com.vmware.vide.debug.autodeploy.attr.operations");
                e.printStackTrace();
            }
            this.clearAutoDeployOperations();
            this.setAutoDeployOperationsList(operations);
        }
        finally {
            this.setOkToUpdate(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configWC) {
        configWC.setAttribute(DEBUG_AUTO_DEPLOY_OPERATIONS_ATTR, this.getAutoDeployOperationsList());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configWC) {
        configWC.setAttribute(DEBUG_AUTO_DEPLOY_OPERATIONS_ATTR, new ArrayList());
    }

    public String getId() {
        return TAB_ID;
    }

    private String getDefaultOperationName() {
        TableItem[] items;
        String opName = DEFAULT_OP_PREFIX;
        HashSet<String> names = new HashSet<String>();
        TableItem[] tableItemArray = items = this.fAutoDeployOperationsTable.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            names.add(item.getText());
            ++n2;
        }
        int i = 0;
        while (names.contains(opName)) {
            opName = DEFAULT_OP_PREFIX + ++i;
        }
        return opName;
    }

    private IStructuredSelection getCurrentSelections() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection s = ww.getSelectionService().getSelection();
        if (s instanceof IStructuredSelection) {
            return (IStructuredSelection)s;
        }
        return null;
    }

    class AutoDeployOperationsContentProvider
    implements IStructuredContentProvider {
        AutoDeployOperationsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class AutoDeployOperationsLabelProvider
    implements ITableLabelProvider {
        AutoDeployOperationsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DebuggerAutoDeployOperation) {
                return ((DebuggerAutoDeployOperation)element).getName();
            }
            System.err.println("Unsupported data element " + element);
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class CachedDebuggerAutoDeployOperationsDatabase
    implements IAutoDeployOperationsDatabase {
        private final ArrayList<DebuggerAutoDeployOperation> operations;

        CachedDebuggerAutoDeployOperationsDatabase() {
            this.operations = AutoDeployTab.this.getDebuggerAutoDeployOperations();
        }

        @Override
        public AutoDeployOperation[] getAutoDeployOperations() {
            AutoDeployOperation[] ops = new AutoDeployOperation[this.operations.size()];
            int i = 0;
            while (i < ops.length) {
                ops[i] = new AutoDeployOperation(this.operations.get(i).getName(), this.operations.get(i).getPreCommands(), this.operations.get(i).getPreCommands());
                ++i;
            }
            return ops;
        }

        @Override
        public IFileDeployExportDataReader getFileDeployExportDataReader(String name) {
            for (DebuggerAutoDeployOperation op : this.operations) {
                if (!op.getName().equals(name)) continue;
                return new DebuggerFileExportDataReader(op);
            }
            return null;
        }

        @Override
        public IFileDeployExportDataReader[] getAllFileDeployExportDataReaders() {
            IFileDeployExportDataReader[] readers = new DebuggerFileExportDataReader[this.operations.size()];
            int i = 0;
            while (i < readers.length) {
                readers[i] = new DebuggerFileExportDataReader(this.operations.get(i));
                ++i;
            }
            return readers;
        }
    }

    class CheckButtonListener
    extends SelectionAdapter {
        CheckButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget w = e.widget;
            if (w instanceof Button) {
                boolean state = ((Button)w).getText().equals(AutoDeployTab.CHECK_ALL_BUTTON_TEXT);
                AutoDeployTab.this.fAutoDeployOperationsTable.setAllChecked(state);
                this.changeAllstate(state);
                AutoDeployTab.this.updateLaunchConfigurationDialog();
            }
        }

        private void changeAllstate(boolean state) {
            int i = 0;
            while (i < AutoDeployTab.this.fAutoDeployOperationsTable.getTable().getItemCount()) {
                Object o = AutoDeployTab.this.fAutoDeployOperationsTable.getElementAt(i);
                if (o instanceof DebuggerAutoDeployOperation) {
                    ((DebuggerAutoDeployOperation)o).setEnable(state);
                }
                ++i;
            }
        }
    }

    class CopyButtonListener
    implements SelectionListener {
        CopyButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FileDeploySelectionDialog dlg = new FileDeploySelectionDialog(e.display.getActiveShell());
            int rc = dlg.open();
            if (rc != 0) {
                return;
            }
            AutoDeployOperationData data = new AutoDeployOperationData(dlg.getOperationData());
            AutoDeployTab.this.insertOperation(data, true);
        }
    }

    class DeleteButtonListener
    implements SelectionListener {
        DeleteButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection iss = (IStructuredSelection)AutoDeployTab.this.fAutoDeployOperationsTable.getSelection();
            if (!iss.isEmpty()) {
                AutoDeployTab.this.fAutoDeployOperationsTable.remove(iss.toArray());
                AutoDeployTab.this.updateLaunchConfigurationDialog();
            }
        }
    }

    class EditOperationButtonListener
    implements SelectionListener {
        EditOperationButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection iss = (IStructuredSelection)AutoDeployTab.this.fAutoDeployOperationsTable.getSelection();
            Object o = iss.getFirstElement();
            DebuggerAutoDeployOperation data = null;
            if (!(o instanceof DebuggerAutoDeployOperation)) {
                System.err.println("Unsupported data element: " + o);
                return;
            }
            data = (DebuggerAutoDeployOperation)o;
            DeployExportSettingsWizard wd = new DeployExportSettingsWizard(new CachedDebuggerAutoDeployOperationsDatabase(), data);
            wd.initFromConfiguration(null, false);
            WizardDialog wdlg = new WizardDialog(e.display.getActiveShell(), (IWizard)wd);
            int rc = wdlg.open();
            if (rc != 0) {
                return;
            }
            AutoDeployOperationData newData = wd.getOperationData();
            data.setAllData(newData);
            AutoDeployTab.this.fAutoDeployOperationsTable.refresh(o);
            int index = AutoDeployTab.this.fAutoDeployOperationsTable.getTable().getSelectionIndex();
            AutoDeployTab.this.sendElementSelectionEvent(index);
            AutoDeployTab.this.updateLaunchConfigurationDialog();
        }
    }

    class MouseHoverListener
    implements MouseTrackListener {
        MouseHoverListener() {
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
            Object o;
            int index;
            Widget w = e.widget;
            if (w == AutoDeployTab.this.fAutoDeployOperationsTable.getTable() && (index = e.y / AutoDeployTab.this.fAutoDeployOperationsTable.getTable().getItemHeight()) < AutoDeployTab.this.fAutoDeployOperationsTable.getTable().getItemCount() && (o = AutoDeployTab.this.fAutoDeployOperationsTable.getElementAt(index)) instanceof DebuggerAutoDeployOperation) {
                AutoDeployTab.this.fAutoDeployOperationsTable.getTable().setToolTipText(((DebuggerAutoDeployOperation)o).getInformationText());
            }
        }
    }

    class NewButtonListener
    implements SelectionListener {
        NewButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AutoDeployOperationData data0 = new AutoDeployOperationData(AutoDeployTab.this.getDefaultOperationName(), new ArrayList<IResource>(), "", "", false, "", "");
            DeployExportSettingsWizard wd = new DeployExportSettingsWizard(new CachedDebuggerAutoDeployOperationsDatabase(), data0);
            wd.initFromConfiguration(AutoDeployTab.this.getCurrentSelections(), true);
            WizardDialog wdlg = new WizardDialog(e.display.getActiveShell(), (IWizard)wd);
            int rc = wdlg.open();
            if (rc != 0) {
                return;
            }
            AutoDeployOperationData data = wd.getOperationData();
            AutoDeployTab.this.insertOperation(data, true);
        }
    }

    class UpDownButtonsListener
    implements SelectionListener {
        UpDownButtonsListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int oldIndex = AutoDeployTab.this.fAutoDeployOperationsTable.getTable().getSelectionIndex();
            int lastIndex = AutoDeployTab.this.fAutoDeployOperationsTable.getTable().getItemCount() - 1;
            int newIndex = -1;
            if (e.widget == AutoDeployTab.this.fUpButton) {
                if (oldIndex > 0) {
                    newIndex = oldIndex - 1;
                }
            } else if (e.widget == AutoDeployTab.this.fDownButton && oldIndex >= 0 && oldIndex < lastIndex) {
                newIndex = oldIndex + 1;
            }
            if (newIndex != -1 && newIndex != oldIndex) {
                AutoDeployTab.this.moveItem(oldIndex, newIndex);
            }
        }
    }
}

