/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy.debug;

import com.vmware.vide.deploy.AutoDeployOperation;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.IFileDeployExportDataReader;
import com.vmware.vide.deploy.debug.DebuggerAutoDeployOperation;
import com.vmware.vide.deploy.debug.DebuggerFileExportDataReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DebuggerAutoDeployOperationsDatabase
implements IAutoDeployOperationsDatabase {
    private final HashMap<String, DebuggerFileExportDataReader> autoDeployOperationTable = new HashMap();
    private AutoDeployOperation[] autoDeployOperations = new AutoDeployOperation[0];

    public DebuggerAutoDeployOperationsDatabase(ILaunchConfiguration config) {
        this.createDatabase(config);
    }

    @Override
    public AutoDeployOperation[] getAutoDeployOperations() {
        return this.autoDeployOperations;
    }

    @Override
    public IFileDeployExportDataReader getFileDeployExportDataReader(String name) {
        return this.autoDeployOperationTable.get(name);
    }

    private void createDatabase(ILaunchConfiguration config) {
        try {
            List list = config.getAttribute("com.vmware.vide.debug.autodeploy.attr.operations", new ArrayList());
            ArrayList<AutoDeployOperation> operations = new ArrayList<AutoDeployOperation>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DebuggerAutoDeployOperation op = new DebuggerAutoDeployOperation();
                String initStr = (String)iterator.next();
                if (op.initializeFromString(initStr) == null || !op.isEnabled()) continue;
                String name = op.getName();
                if (this.autoDeployOperationTable.containsKey(name)) {
                    int count = 0;
                    do {
                        name = String.valueOf(op.getName()) + "_" + count;
                        ++count;
                    } while (this.autoDeployOperationTable.containsKey(name));
                }
                this.autoDeployOperationTable.put(name, new DebuggerFileExportDataReader(op));
                operations.add(new AutoDeployOperation(name, op.getPreCommands(), op.getPostCommands()));
            }
            this.autoDeployOperations = operations.toArray(new AutoDeployOperation[operations.size()]);
        }
        catch (CoreException e) {
            System.err.println("Failed to get the attribute com.vmware.vide.debug.autodeploy.attr.operations");
            e.printStackTrace();
        }
    }

    @Override
    public IFileDeployExportDataReader[] getAllFileDeployExportDataReaders() {
        return this.autoDeployOperationTable.values().toArray(new DebuggerFileExportDataReader[this.autoDeployOperationTable.size()]);
    }
}

