/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy.debug;

import com.vmware.vide.deploy.AutoDeployOperationData;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DebuggerAutoDeployOperation
extends AutoDeployOperationData {
    private static final char T_NAME = '0';
    private static final char T_TARGET = '1';
    private static final char T_TTYPE = '2';
    private static final char T_RESOURCE = '3';
    private static final char T_DIR_OPTION = '4';
    private static final char T_PRECOMMAND = '5';
    private static final char T_POSTCOMMAND = '6';
    private static final char T_ENABLE = '7';
    private static final char RT_PROJECT = 'P';
    private static final char RT_FOLDER = 'F';
    private static final char RT_FILE = 'L';
    private static final int LEN_FIELD_LENGTH = 5;
    private static final int MAX_STRING_LENGTH = 99999;
    private static final String emptyString = new String();
    boolean enable;

    public DebuggerAutoDeployOperation(String name, ArrayList<IResource> resources, String targetDestination, String targetType, boolean createEntireDirs, String preCommands, String postCommands, boolean enable) {
        super(name, resources, targetDestination, targetType, createEntireDirs, preCommands, postCommands);
        this.enable = enable;
    }

    public DebuggerAutoDeployOperation(AutoDeployOperationData data, boolean enable) {
        super(data);
        this.enable = enable;
    }

    public DebuggerAutoDeployOperation() {
        super(emptyString, null, emptyString, emptyString, false, emptyString, emptyString);
        this.enable = false;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnable(boolean state) {
        this.enable = state;
    }

    public DebuggerAutoDeployOperation initializeFromString(String initStr) {
        int index = 0;
        int[] next = new int[1];
        IResource resource = null;
        if (this.getResources() == null) {
            this.setResources(new ArrayList<IResource>());
        }
        while (index < initStr.length()) {
            switch (initStr.charAt(index)) {
                case '0': {
                    this.setName(this.extractString(initStr, index + 1, next));
                    break;
                }
                case '1': {
                    this.setTargetDestination(this.extractString(initStr, index + 1, next));
                    break;
                }
                case '2': {
                    this.setTargetType(this.extractString(initStr, index + 1, next));
                    break;
                }
                case '3': {
                    resource = this.extractResource(initStr, index + 1, next);
                    if (resource == null) break;
                    this.getResources().add(resource);
                    break;
                }
                case '4': {
                    this.setCreateEntireDirs(this.extractBoolean(initStr, index + 1, next));
                    break;
                }
                case '5': {
                    this.setPreCommands(this.extractString(initStr, index + 1, next));
                    break;
                }
                case '6': {
                    this.setPostCommands(this.extractString(initStr, index + 1, next));
                    break;
                }
                case '7': {
                    this.setEnable(this.extractBoolean(initStr, index + 1, next));
                    break;
                }
                default: {
                    System.err.println("Bad type [" + initStr.charAt(index) + "] in the initial string at " + index);
                    return null;
                }
            }
            index = next[0];
        }
        return this;
    }

    private String extractString(String str, int start, int[] next) {
        int strBegin = start + 5;
        Integer i = new Integer(str.substring(start, strBegin));
        int len = i;
        next[0] = strBegin + len;
        return str.substring(strBegin, next[0]);
    }

    private boolean extractBoolean(String str, int start, int[] next) {
        String s = this.extractString(str, start, next);
        return Boolean.parseBoolean(s);
    }

    private IResource extractResource(String str, int start, int[] next) {
        String s = this.extractString(str, start, next);
        Path path = new Path(s.substring(1));
        IFolder r = null;
        IWorkspace w = ResourcesPlugin.getWorkspace();
        if (w != null) {
            if (s.charAt(0) == 'F') {
                r = w.getRoot().getFolder((IPath)path);
            } else if (s.charAt(0) == 'L') {
                r = w.getRoot().getFile((IPath)path);
            } else if (s.charAt(0) == 'P') {
                r = w.getRoot().getProject(path.lastSegment());
            }
        }
        return r;
    }

    public String toInitializeString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("0" + this.formFromString(this.getName()));
        buffer.append("1" + this.formFromString(this.getTargetDestination()));
        buffer.append("2" + this.formFromString(this.getTargetType()));
        buffer.append(this.formFromResources(this.getResources()));
        buffer.append("4" + this.formFromBoolean(this.getCreateEntireDirs()));
        buffer.append("5" + this.formFromString(this.getPreCommands()));
        buffer.append("6" + this.formFromString(this.getPostCommands()));
        buffer.append("7" + this.formFromBoolean(this.isEnabled()));
        return buffer.toString();
    }

    private String formFromString(String str) {
        int len = str.length();
        if (len > 99999) {
            System.err.println("Too long string (" + len + " > " + 99999 + "). " + "Truncate it to " + 99999 + "characters.");
            return "99999" + str.substring(0, 99999);
        }
        DecimalFormat f = new DecimalFormat("0");
        f.setMinimumIntegerDigits(5);
        return String.valueOf(f.format(len)) + str;
    }

    private String formFromBoolean(boolean b) {
        return this.formFromString(Boolean.toString(b));
    }

    private String formFromResources(ArrayList<IResource> resources) {
        StringBuffer buffer = new StringBuffer();
        for (IResource r : resources) {
            if (r.getType() == 1) {
                buffer.append("3" + this.formFromString("L" + r.getFullPath().toString()));
                continue;
            }
            if (r.getType() == 2) {
                buffer.append("3" + this.formFromString("F" + r.getFullPath().toString()));
                continue;
            }
            if (r.getType() != 4) continue;
            buffer.append("3" + this.formFromString("P" + r.getFullPath().toString()));
        }
        return buffer.toString();
    }
}

