/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.IFileDeployExportDataReader;
import com.vmware.vide.target.api.ICommandOutputChangedEvent;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.TargetManagerPlugin;
import java.io.File;
import java.util.Date;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IRemoteContainer;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FileDeployUtilities {
    public static String getTargetFolderName(UniFilePlus sel) {
        if (sel.remoteFile.getHost() != null) {
            return String.valueOf(sel.remoteFile.getHost().getAliasName()) + ":" + sel.getPath();
        }
        return sel.getPath();
    }

    public static File getFolder(String folderName) {
        IRemoteFile remoteFolder = FileDeployUtilities.parseForIRemoteFile(folderName);
        if (remoteFolder != null) {
            return new UniFilePlus(remoteFolder);
        }
        return null;
    }

    public static File getFolderOrCreate(String folderName) {
        IRemoteFile remoteFolder = FileDeployUtilities.parseForIRemoteFile(folderName);
        if (remoteFolder != null) {
            if (!remoteFolder.exists()) {
                try {
                    if (remoteFolder instanceof FakeRemoteFile) {
                        ((FakeRemoteFile)remoteFolder).mkdirs();
                    } else {
                        remoteFolder.getParentRemoteFileSubSystem().createFolder(remoteFolder, null);
                    }
                }
                catch (SystemMessageException systemMessageException) {}
                return FileDeployUtilities.getFolder(folderName);
            }
            return new UniFilePlus(remoteFolder);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static File getFolderOrCreateFullPath(String folderName) {
        block5: {
            remoteFolder = FileDeployUtilities.parseForIRemoteFile(folderName);
            folders = new Stack<IRemoteFile>();
            if (remoteFolder == null) break block5;
            if (!(remoteFolder instanceof FakeRemoteFile)) ** GOTO lbl12
            fakeRemoteFile = (FakeRemoteFile)remoteFolder;
            if (fakeRemoteFile.mkdirs()) {
                return FileDeployUtilities.getFolder(folderName);
            }
            return null;
lbl-1000:
            // 1 sources

            {
                folders.push(remoteFolder);
                remoteFolder = remoteFolder.getParentRemoteFile();
lbl12:
                // 2 sources

                ** while (!remoteFolder.exists())
            }
lbl13:
            // 2 sources

            while (!folders.isEmpty()) {
                remoteFolder = (IRemoteFile)folders.pop();
                try {
                    remoteFolder.getParentRemoteFileSubSystem().createFolder(remoteFolder, null);
                }
                catch (SystemMessageException v0) {
                    return null;
                }
            }
            return FileDeployUtilities.getFolder(folderName);
        }
        return null;
    }

    public static boolean isValidTarget(String folderName) {
        IHost sc = Utilities.parseForSystemConnection((String)folderName);
        return sc != null;
    }

    public static boolean createTarget(String folderName, String targetType) {
        int index = folderName.indexOf(":");
        if (index != -1) {
            String targetName = folderName.substring(0, index);
            ITargetManager tm = TargetManagerPlugin.getTheTargetManager();
            ITarget target = tm.createTarget(targetType, targetName, targetName);
            if (target != null) {
                return true;
            }
        }
        return false;
    }

    public static ITarget getTargetByName(String folderName) {
        int index = folderName.indexOf(":");
        String targetName = index != -1 ? folderName.substring(0, index) : "LOCALHOST";
        return FileDeployUtilities.getTargetByAnyName(targetName);
    }

    public static String getTargetTypeByName(String folderName) {
        ITarget t = FileDeployUtilities.getTargetByName(folderName);
        if (t != null) {
            return t.getTargetType();
        }
        return "unknown";
    }

    public static String firstFindTargetTypeInFileDeployOperations(IFileDeployExportDataReader[] dataReaders, String destination) {
        IFileDeployExportDataReader[] iFileDeployExportDataReaderArray = dataReaders;
        int n = dataReaders.length;
        int n2 = 0;
        while (n2 < n) {
            IFileDeployExportDataReader reader = iFileDeployExportDataReaderArray[n2];
            if (reader.getTargetDestination().equals(destination)) {
                return reader.getTargetType();
            }
            ++n2;
        }
        int index = destination.indexOf(58);
        if (index != -1) {
            IFileDeployExportDataReader[] iFileDeployExportDataReaderArray2 = dataReaders;
            int n3 = dataReaders.length;
            n = 0;
            while (n < n3) {
                IFileDeployExportDataReader reader = iFileDeployExportDataReaderArray2[n];
                String dst = reader.getTargetDestination();
                if (index == dst.indexOf(58) && destination.substring(0, index).equals(dst.substring(0, index))) {
                    return reader.getTargetDestination();
                }
                ++n;
            }
        }
        return null;
    }

    private static TargetTypeSelectionDialog createTargetTypeSelectionDialog(Shell shell, String dstName) {
        String name = "LOCALHOST";
        int index = dstName.indexOf(58);
        if (index != -1) {
            name = dstName.substring(0, index);
        }
        FileDeployUtilities fileDeployUtilities = new FileDeployUtilities();
        fileDeployUtilities.getClass();
        return fileDeployUtilities.new TargetTypeSelectionDialog(shell, name);
    }

    public static String getDestinationTargetType(Shell shell, String dstName, IFileDeployExportDataReader[] readers) {
        String ttype = FileDeployUtilities.getTargetTypeByName(dstName);
        if (ttype.equals("unknown") && (ttype = FileDeployUtilities.firstFindTargetTypeInFileDeployOperations(readers, dstName)) == null) {
            TargetTypeSelectionDialog dlg = FileDeployUtilities.createTargetTypeSelectionDialog(shell, dstName);
            dlg.open();
            ttype = dlg.getTargetType();
        }
        return ttype;
    }

    public static String getDestinationTargetType(String dstName, IFileDeployExportDataReader[] readers) {
        String ttype = FileDeployUtilities.getTargetTypeByName(dstName);
        if (ttype.equals("unknown") && (ttype = FileDeployUtilities.firstFindTargetTypeInFileDeployOperations(readers, dstName)) == null) {
            ttype = "unknown";
        }
        return ttype;
    }

    public static ITargetFile getTargetFile(String folderName) {
        ITargetFile targetFolder = (ITargetFile)FileDeployUtilities.parseForIRemoteFile(folderName);
        return targetFolder;
    }

    private static ITarget getTargetByAnyName(String targetName) {
        ITargetManager tm = TargetManagerPlugin.getTheTargetManager();
        if (tm == null) {
            return null;
        }
        ITarget[] targets = tm.getTargets();
        if (targets.length == 0) {
            return null;
        }
        ITarget[] iTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITarget t = iTargetArray[n2];
            if (t.getHostName().equalsIgnoreCase(targetName)) {
                return t;
            }
            if (t.getName().equals(targetName)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static ITarget getLocalHost() {
        return FileDeployUtilities.getTargetByAnyName("LOCALHOST");
    }

    public static IRemoteFile parseForIRemoteFile(String targetFolderName) {
        class CmdListener
        implements ICommandOutputListener {
            public boolean sawESXi = false;

            CmdListener() {
            }

            public void commandOutputChanged(ICommandOutputChangedEvent event) {
                String[] outputs;
                String[] stringArray = outputs = event.getOutputLines();
                int n = outputs.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.contains("ESXi")) {
                        this.sawESXi = true;
                    }
                    ++n2;
                }
            }
        }
        CmdListener listener;
        ITarget target;
        block15: {
            block13: {
                target = FileDeployUtilities.getTargetByName(targetFolderName);
                if (!target.isConnected()) {
                    try {
                        target.connect(null);
                    }
                    catch (Exception e) {
                        String msg = e.getMessage();
                        if (!msg.contains("Failed to connect SFTP subsystem")) break block13;
                        return null;
                    }
                }
            }
            if (target.getHostName().equalsIgnoreCase("LOCALHOST")) {
                return Utilities.parseForIRemoteFile((String)targetFolderName);
            }
            IRemoteFile targetFile = null;
            try {
                IHost[] hosts;
                ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                IHost[] iHostArray = hosts = registry.getHosts();
                int n = hosts.length;
                int n2 = 0;
                while (n2 < n) {
                    IHost host = iHostArray[n2];
                    if (host.getHostName().equalsIgnoreCase(target.getHostName())) {
                        targetFile = RemoteFileUtility.getFileSubSystem((IHost)host).getRemoteFileObject(targetFolderName, null);
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
            if (targetFile != null) {
                return Utilities.parseForIRemoteFile((String)targetFolderName);
            }
            listener = new CmdListener();
            try {
                ITargetManager tm = TargetManagerPlugin.getTheTargetManager();
                if (tm != null) break block15;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        target.executeCommand("/sbin/vmkvsitools vmware -v", (ICommandOutputListener)listener, (IProgressMonitor)new NullProgressMonitor());
        if (listener.sawESXi) {
            return FileDeployUtilities.createFakeRemoteFile(targetFolderName, target);
        }
        return null;
    }

    private static IRemoteFile createFakeRemoteFile(String folderName, ITarget target) {
        String result;
        class CmdListener
        implements ICommandOutputListener {
            private String llResult = "";

            CmdListener() {
            }

            public void commandOutputChanged(ICommandOutputChangedEvent event) {
                String[] outputs;
                String[] stringArray = outputs = event.getOutputLines();
                int n = outputs.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.matches("^[cdl-][r-][w-][sStxX-][r-][w-][sStxX-][r-][w-][sStxX-]\\s.*")) {
                        this.llResult = s;
                    }
                    ++n2;
                }
            }

            public String getResult() {
                return this.llResult;
            }

            public void setResult(String s) {
                this.llResult = s;
            }
        }
        CmdListener listener;
        String folder;
        String targetName;
        block11: {
            int exist;
            block10: {
                block9: {
                    int index = folderName.indexOf(58);
                    if (index == -1) {
                        return null;
                    }
                    targetName = folderName.substring(0, index);
                    folder = folderName.substring(index + 1, folderName.length());
                    if (targetName.isEmpty() || folder.isEmpty() || folder.charAt(0) != '/') {
                        return null;
                    }
                    listener = new CmdListener();
                    try {
                        ITargetManager tm = TargetManagerPlugin.getTheTargetManager();
                        if (tm != null) break block9;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                exist = target.executeCommand("[ -e " + folder + " ]", null, (IProgressMonitor)new NullProgressMonitor());
                if (exist != 0) break block10;
                int retval = target.executeCommand("ls --color=never -ld " + folder, (ICommandOutputListener)listener, (IProgressMonitor)new NullProgressMonitor());
                if (retval != 0) {
                    return null;
                }
            }
            if (exist == 1) {
                listener.setResult(Boolean.toString(false));
                break block11;
            }
            return null;
        }
        if ((result = listener.getResult()).isEmpty()) {
            return null;
        }
        FileDeployUtilities fileDeployUtilities = new FileDeployUtilities();
        fileDeployUtilities.getClass();
        return fileDeployUtilities.new FakeRemoteFile(targetName, folder, result, target);
    }

    class FakeRemoteFile
    implements IRemoteFile {
        private String fileInfo;
        private String targetName;
        private String fullpath;
        private ITarget target;

        public FakeRemoteFile(String targetName, String fullpath, String fileInfo, ITarget target) {
            this.fileInfo = fileInfo;
            this.targetName = targetName;
            this.fullpath = fullpath;
            this.target = target;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public ITarget getTarget() {
            return this.target;
        }

        public boolean mkdirs() {
            block3: {
                try {
                    ITargetManager tm = TargetManagerPlugin.getTheTargetManager();
                    if (tm != null) break block3;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            this.target.executeCommand("mkdir -p " + this.fullpath, null, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }

        public boolean canRead() {
            return this.fileInfo.matches("^.r.*");
        }

        public boolean canWrite() {
            return this.fileInfo.matches("^..w.*");
        }

        public int compareTo(Object other) throws ClassCastException {
            return 0;
        }

        public boolean exists() {
            return !this.fileInfo.equals(Boolean.toString(false));
        }

        public String getAbsolutePath() {
            return this.fullpath;
        }

        public String getAbsolutePathPlusConnection() {
            return null;
        }

        public RemoteFileFilterString[] getAllFilterStrings() {
            return null;
        }

        public String getCanonicalPath() {
            return null;
        }

        public String getClassification() {
            return null;
        }

        public String getComment() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public String getExtension() {
            return null;
        }

        public Object getFile() {
            return null;
        }

        public RemoteFileFilterString getFilterString() {
            return null;
        }

        public IHost getHost() {
            return null;
        }

        public IHostFile getHostFile() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Date getLastModifiedDate() {
            return null;
        }

        public long getLength() {
            return 0L;
        }

        public String getLineSeparator() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getParentName() {
            return null;
        }

        public String getParentNoRoot() {
            return null;
        }

        public String getParentPath() {
            return null;
        }

        public IRemoteFile getParentRemoteFile() {
            if (this.isRoot()) {
                return this;
            }
            Path path = new Path(this.fullpath);
            return FileDeployUtilities.createFakeRemoteFile(String.valueOf(this.targetName) + ":" + path.removeLastSegments(1).toOSString(), this.target);
        }

        public IRemoteFileSubSystem getParentRemoteFileSubSystem() {
            return null;
        }

        public IHostFilePermissions getPermissions() {
            return null;
        }

        public String getRoot() {
            return "/";
        }

        public String getSeparator() {
            return "/";
        }

        public char getSeparatorChar() {
            return '/';
        }

        public boolean isAncestorOf(IRemoteFile file) {
            return false;
        }

        public boolean isArchive() {
            return false;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isDescendantOf(IRemoteFile file) {
            return false;
        }

        public boolean isDirectory() {
            return this.fileInfo.charAt(0) == 'd';
        }

        public boolean isExecutable() {
            return false;
        }

        public boolean isFile() {
            return false;
        }

        public boolean isHidden() {
            return this.fileInfo.charAt(0) == '-';
        }

        public boolean isLink() {
            return this.fileInfo.charAt(0) == 'l';
        }

        public boolean isRoot() {
            return this.fullpath.equals("/");
        }

        public boolean isText() {
            return false;
        }

        public boolean showBriefPropertySet() {
            return false;
        }

        public boolean showReadOnlyProperty() {
            return false;
        }

        public void copyContentsTo(IRemoteContainer container) {
        }

        public Object[] getContents(ISystemContentsType contentsType, String filter) {
            return null;
        }

        public boolean hasContents(ISystemContentsType contentsType, String filter) {
            return false;
        }

        public void replaceContent(Object oldObject, Object newObject) {
        }

        public void setContents(ISystemContentsType contentsType, String filter, Object[] con) {
        }

        public Object[] getContents(ISystemContentsType contentsType) {
            return null;
        }

        public boolean hasContents(ISystemContentsType contentsType) {
            return false;
        }

        public boolean isStale() {
            return false;
        }

        public void markStale(boolean isStale) {
        }

        public void markStale(boolean isStale, boolean clearCache) {
        }

        public Object[] getProperties(String[] keys) {
            return null;
        }

        public Object getProperty(String key) {
            return null;
        }

        public boolean isPropertyStale(String key) {
            return false;
        }

        public void markAllPropertiesStale() {
        }

        public void markPropertyStale(String key) {
        }

        public void setProperties(String[] keys, Object[] values) {
        }

        public void setProperty(String key, Object value) {
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }
    }

    public class TargetTypeSelectionDialog
    extends MessageDialog {
        private static final int WIDTH_HINT = 250;
        private static final String BUTTON_LABEL_OK = " OK ";
        private static final String DIALOG_TITLE = "Select Target Type";
        private static final String DIALOG_MESSAGE = "Please select a target type for the remote host: ";
        private int selected;

        public TargetTypeSelectionDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        public TargetTypeSelectionDialog(Shell shell, String hostname) {
            super(shell, DIALOG_TITLE, null, DIALOG_MESSAGE + hostname, 3, new String[]{BUTTON_LABEL_OK}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout());
            comp.setLayoutData((Object)new GridData(272));
            comp.setFont(parent.getFont());
            final Combo combo = new Combo(comp, 12);
            GridData data = new GridData(768);
            data.widthHint = 250;
            combo.setLayoutData((Object)data);
            String[] types = new String[]{"ESX", "Linux", "Localhost"};
            combo.setItems(types);
            combo.select(0);
            this.selected = 0;
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TargetTypeSelectionDialog.this.selected = combo.getSelectionIndex();
                }
            });
            return comp;
        }

        public String getTargetType() {
            switch (this.selected) {
                case 0: {
                    return "esx";
                }
                case 1: {
                    return "ssh";
                }
                case 2: {
                    return "localhost";
                }
            }
            return "esx";
        }
    }
}

