/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.Activator;
import com.vmware.vide.deploy.AutoDeployOperationData;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.WizardDeployEditCommandPage;
import com.vmware.vide.deploy.WizardDeployFileExportPage2;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DeployExportSettingsWizard
extends Wizard
implements IExportWizard {
    private static final String DEFAULT_AUTO_DEPLOY_OPERATION_TITLE = "Auto Deploy Operation";
    private static final String NEW_AUTO_DEPLOY_OPERATION_TITLE = "New Auto Deploy Operation";
    private static final String EDIT_AUTO_DEPLOY_OPERATION_TITLE = "Edit Auto Deploy Operation";
    private static final String IDE_WORKBENCH_ID = "org.eclipse.ui.ide";
    private static final String IDE_WORKBENCH_WIZARD_ICONPATH = "/icons/full/wizban/";
    private IStructuredSelection selection;
    private WizardDeployFileExportPage2 mainPage;
    private WizardDeployEditCommandPage editCommandPage;
    private AutoDeployOperationData data;
    private AutoDeployOperationData workingData;
    private final IAutoDeployOperationsDatabase database;
    private boolean newWizard = false;

    public DeployExportSettingsWizard(IAutoDeployOperationsDatabase database, AutoDeployOperationData data) {
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("DeployExportSettingsWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("DeployExportSettingsWizard");
        }
        this.setDialogSettings(section);
        this.database = database;
        this.workingData = data;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardDeployFileExportPage2(this.selection, this.database, this.workingData);
        this.addPage((IWizardPage)this.mainPage);
        this.editCommandPage = new WizardDeployEditCommandPage("EditCommandsPage", this.workingData);
        this.addPage((IWizardPage)this.editCommandPage);
    }

    public boolean performFinish() {
        if ("unknown".equals(this.workingData.getTargetType())) {
            this.workingData.setTargetType(this.mainPage.getTargetType());
        }
        this.data = new AutoDeployOperationData(this.workingData);
        return this.mainPage.finish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object selectedResource;
        IEditorPart currentEditor;
        IWorkbenchPage page;
        this.selection = selection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)selection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        if (this.selection.isEmpty() && workbench.getActiveWorkbenchWindow() != null && (page = workbench.getActiveWorkbenchWindow().getActivePage()) != null && (currentEditor = page.getActiveEditor()) != null && (selectedResource = currentEditor.getEditorInput().getAdapter(IResource.class)) != null) {
            this.selection = new StructuredSelection(selectedResource);
        }
        this.setWindowTitle(DEFAULT_AUTO_DEPLOY_OPERATION_TITLE);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)IDE_WORKBENCH_ID, (String)"/icons/full/wizban/exportdir_wiz.png"));
    }

    public void initFromConfiguration(IStructuredSelection selection, boolean newWizard) {
        this.selection = selection;
        this.newWizard = newWizard;
        if (newWizard) {
            this.setWindowTitle(NEW_AUTO_DEPLOY_OPERATION_TITLE);
            if (selection != null) {
                for (Object o : selection) {
                    IResource r;
                    if (o instanceof IResource) {
                        if (!this.isSupportedResource((IResource)o)) continue;
                        this.workingData.getResources().add((IResource)o);
                        continue;
                    }
                    if (!(o instanceof IAdaptable) || !this.isSupportedResource(r = (IResource)((IAdaptable)o).getAdapter(IResource.class))) continue;
                    this.workingData.getResources().add(r);
                }
            }
        } else {
            this.setWindowTitle(EDIT_AUTO_DEPLOY_OPERATION_TITLE);
        }
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)IDE_WORKBENCH_ID, (String)"/icons/full/wizban/exportdir_wiz.png"));
    }

    private boolean isSupportedResource(IResource r) {
        if (r == null) {
            return false;
        }
        int type = r.getType();
        return type == 4 || type == 2 || type == 1;
    }

    public AutoDeployOperationData getOperationData() {
        return this.data;
    }

    public boolean isNewWizard() {
        return this.newWizard;
    }
}

