/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeployCommandDialog
extends Dialog {
    public static final String DETAILS_BUTTON_LABEL = "&Details>>";
    public static final String CLOSE_DETAILS_BUTTON_LABEL = "<<&Close Details";
    private AutoDeployCommandsPair returnValue;
    private Shell shell;
    private Text preCommands;
    private Text postCommands;
    private String operationDetails;
    private boolean showDetails = false;
    private Text detailInfo;

    public DeployCommandDialog(Shell parent) {
        super(parent, 67696);
        this.setText("Deploy Commands");
    }

    public AutoDeployCommandsPair open(List opList, Point location, AutoDeployOperation autoOp, String opDetails) {
        this.operationDetails = opDetails;
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setLocation(location.x, location.y);
        this.shell.setText(this.getText());
        this.createContents(this.shell, autoOp);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnValue;
    }

    private void createContents(final Shell shell, AutoDeployOperation autoOp) {
        shell.setLayout((Layout)new GridLayout(1, false));
        final Composite composite1 = new Composite((Composite)shell, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite1.setLayout((Layout)layout);
        GridData data = new GridData(768);
        Label opLabel = new Label(composite1, 0);
        opLabel.setLayoutData((Object)data);
        opLabel.setText("Deploy operation: " + autoOp.getName());
        final Button detailButton = new Button(composite1, 8);
        detailButton.setText(DETAILS_BUTTON_LABEL);
        detailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point dialogSize = shell.getSize();
                Point oldSize = shell.computeSize(-1, -1);
                if (DeployCommandDialog.this.showDetails) {
                    if (DeployCommandDialog.this.detailInfo != null) {
                        DeployCommandDialog.this.detailInfo.dispose();
                    }
                    detailButton.setText(DeployCommandDialog.DETAILS_BUTTON_LABEL);
                    DeployCommandDialog.this.showDetails = false;
                } else {
                    detailButton.setText(DeployCommandDialog.CLOSE_DETAILS_BUTTON_LABEL);
                    DeployCommandDialog.this.detailInfo = new Text(composite1, 2058);
                    DeployCommandDialog.this.detailInfo.setText(DeployCommandDialog.this.operationDetails);
                    GridData layoutData = new GridData();
                    layoutData.horizontalSpan = 2;
                    DeployCommandDialog.this.detailInfo.setLayoutData((Object)layoutData);
                    DeployCommandDialog.this.showDetails = true;
                    composite1.layout();
                }
                Point newSize = shell.computeSize(-1, -1);
                shell.setSize(new Point(dialogSize.x + (newSize.x - oldSize.x), dialogSize.y + (newSize.y - oldSize.y)));
            }
        });
        Composite composite2 = new Composite((Composite)shell, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label preLabel = new Label(composite2, 0);
        preLabel.setText("Pre deploy commands");
        preLabel.setLayoutData((Object)new GridData(32));
        this.preCommands = new Text(composite2, 2818);
        this.preCommands.setLayoutData((Object)new GridData(1808));
        this.preCommands.setText(autoOp.getPreCommands());
        Composite composite3 = new Composite((Composite)shell, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(1808));
        Label postLabel = new Label(composite3, 0);
        postLabel.setText("Post deploy commands");
        postLabel.setLayoutData((Object)new GridData(32));
        this.postCommands = new Text(composite3, 2818);
        this.postCommands.setLayoutData((Object)new GridData(1808));
        this.postCommands.setText(autoOp.getPostCommands());
        Composite composite4 = new Composite((Composite)shell, 0);
        composite4.setLayout((Layout)new GridLayout(3, false));
        Button clearAllButton = new Button(composite4, 8);
        clearAllButton.setText("Clear All");
        clearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DeployCommandDialog.this.preCommands.setText("");
                DeployCommandDialog.this.postCommands.setText("");
            }
        });
        Button okButton = new Button(composite4, 8);
        okButton.setText("  OK  ");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployCommandDialog.this.returnValue = new AutoDeployCommandsPair(DeployCommandDialog.this.getPreDeployCommands(), DeployCommandDialog.this.getPostDeployCommands());
                shell.close();
            }
        });
        Button cancelButton = new Button(composite4, 8);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployCommandDialog.this.returnValue = null;
                shell.close();
            }
        });
        Point size = shell.computeSize(-1, -1);
        size.y += this.postCommands.getLineHeight() * 4;
        shell.setSize(size);
    }

    private String getPreDeployCommands() {
        return this.preCommands.getText();
    }

    private String getPostDeployCommands() {
        return this.postCommands.getText();
    }

    public class AutoDeployCommandsPair {
        private String preCommands;
        private String postCommands;

        private AutoDeployCommandsPair(String pre, String post) {
            this.preCommands = pre;
            this.postCommands = post;
        }

        public String getPreCommands() {
            return this.preCommands;
        }

        public String getPostCommands() {
            return this.postCommands;
        }
    }
}

