/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.ui;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.UserInputEnableCondition;
import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.wizard.ui.UserInputWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class UserInputGroupComposite
extends ScrolledComposite {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    private static final String SORTRULE_TITLE = "title";
    private final Composite inputcomposite;
    private final ArrayList<UserInputWidget> curinputwidgets = new ArrayList();
    private String inputgroupstatus = null;
    private boolean inputdataupdated = false;

    public UserInputGroupComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(1, false));
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.inputcomposite = new Composite((Composite)this, 16);
        this.setContent((Control)this.inputcomposite);
        this.inputcomposite.setLayout((Layout)new GridLayout(3, false));
        this.inputcomposite.setLayoutData((Object)new GridData(1808));
        this.inputcomposite.setFont(parent.getFont());
        this.inputcomposite.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof UserInputWidget.UserInputWidgetEvent) {
                    UserInputGroupComposite.this.getInputGroupStatus(true);
                    UserInputGroupComposite.this.inputcomposite.getParent().notifyListeners(24, event);
                }
            }
        });
        this.setMinSize(new Point(parent.getSize().x - parent.getBorderWidth() * 2, 80));
        this.setVisible(true);
    }

    public UserInputGroupComposite(Composite parent) {
        this(parent, 2816);
    }

    public void createUserInputs(VIBData vibdata, Map<String, String> properties, String qualifier, Map<QualifiedName, String> persistentProp) {
        this.createUserInputs(vibdata.getUserInputs(), properties, vibdata.getSortRule(), qualifier, persistentProp);
    }

    public void createUserInputs(LinkedHashMap<String, UserInput> inputs, Map<String, String> properties, String sortrule, String qualifier, Map<QualifiedName, String> persistentProp) {
        this.cleanUserInputs();
        if (inputs == null || inputs.size() == 0) {
            this.inputcomposite.setVisible(false);
            this.setVisible(false);
            return;
        }
        Map<String, UserInput> sortedinputs = this.getSortedUserInput(inputs, sortrule);
        for (UserInput input : sortedinputs.values()) {
            try {
                UserInputWidget inputwidget = new UserInputWidget(this.inputcomposite, input, properties, qualifier, persistentProp, this);
                if (!inputwidget.isWidgetValid()) continue;
                this.curinputwidgets.add(inputwidget);
                input.setEnabled(true);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        for (UserInputWidget inputWidget : this.curinputwidgets) {
            UserInput input = inputWidget.getInputData();
            if (!input.hasEnableConditions()) continue;
            Iterator<UserInputEnableCondition> itor = input.getEnableConditions().iterator();
            while (itor.hasNext()) {
                UserInputEnableCondition condition = itor.next();
                boolean found = false;
                for (UserInputWidget widget : this.curinputwidgets) {
                    if (!condition.getTitle().equals(widget.getInputData().getTitle())) continue;
                    widget.addStateChangeListener(inputWidget);
                    found = true;
                    break;
                }
                if (found) continue;
                String msg = String.format("Userinput [%s] specifies missing title [%s] in %s element.", inputWidget.getInputData().getTitle(), condition.getTitle(), "enable_when");
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                itor.remove();
            }
        }
        for (UserInputWidget widget : this.curinputwidgets) {
            widget.fireStateChanged();
        }
        this.setMinSize(this.getCurrentInputGroupSize());
        this.setVisible(true);
        this.inputcomposite.setVisible(true);
        this.inputcomposite.layout();
        this.inputcomposite.pack(true);
    }

    public int getHeightGap() {
        Point size = this.getSize();
        Point point = this.getCurrentInputGroupSize();
        return point.y - size.y;
    }

    public void updateDefaultValueOfUserInputs(Map<String, String> properties) {
        if (this.curinputwidgets == null || this.curinputwidgets.size() == 0) {
            return;
        }
        for (UserInputWidget widget : this.curinputwidgets) {
            widget.updateDefaultValueOfUserInput(properties);
        }
    }

    public boolean isInputDataUpdated() {
        return this.inputdataupdated;
    }

    public String getInputGroupStatus(boolean refresh) {
        if (!refresh && this.inputgroupstatus != null) {
            return this.inputgroupstatus;
        }
        boolean haserror = false;
        boolean haswarning = false;
        boolean hasinformational = false;
        for (UserInputWidget widget : this.curinputwidgets) {
            if (widget.getInputData().isInputValueError()) {
                haserror = true;
                break;
            }
            if (widget.getInputData().isInputValueWarning()) {
                haswarning = true;
                continue;
            }
            if (!widget.getInputData().isInputValueInformational()) continue;
            hasinformational = true;
        }
        this.inputgroupstatus = haserror ? "error" : (haswarning ? "warning" : (hasinformational ? "informational" : "normal"));
        return this.inputgroupstatus;
    }

    public boolean hasInputGroupError() {
        return this.getInputGroupStatus(false).equals("error");
    }

    public boolean hasInputGroupWarning() {
        return this.getInputGroupStatus(false).equals("warning");
    }

    public boolean hasInputGroupInformational() {
        return this.getInputGroupStatus(false).equals("informational");
    }

    public boolean allInputGroupNormal() {
        return this.getInputGroupStatus(false).equals("normal");
    }

    private Map<String, UserInput> getSortedUserInput(final LinkedHashMap<String, UserInput> inputs, String sortrule) {
        if (sortrule == null || !sortrule.equalsIgnoreCase(SORTRULE_TITLE)) {
            return inputs;
        }
        TreeMap<String, UserInput> titleSort = new TreeMap<String, UserInput>(new Comparator<String>(){

            @Override
            public int compare(String k1, String k2) {
                return ((UserInput)inputs.get(k1)).getFullTitle().compareTo(((UserInput)inputs.get(k2)).getFullTitle());
            }
        });
        titleSort.putAll(inputs);
        return titleSort;
    }

    private void cleanUserInputs() {
        Control[] controls;
        if (this.curinputwidgets != null && this.curinputwidgets.size() > 0) {
            for (UserInputWidget widget : this.curinputwidgets) {
                widget.dispose();
            }
        }
        if ((controls = this.inputcomposite.getChildren()) != null && controls.length > 0) {
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
        }
        this.curinputwidgets.clear();
        this.inputdataupdated = false;
    }

    private Point getCurrentInputGroupSize() {
        int height = 0;
        int width = 0;
        int border = 7;
        for (UserInputWidget widget : this.curinputwidgets) {
            Point size = widget.getSize();
            if (size.x > width) {
                width = size.x;
            }
            height += size.y + border;
        }
        return new Point(width, height);
    }

    List<UserInputWidget> getCurrentInputWidgets() {
        return this.curinputwidgets;
    }
}

