/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib.ui;

import com.vmware.vide.project.utils.NullReaderThread;
import com.vmware.vide.project.utils.PatternReaderThread;
import com.vmware.vide.project.vib.BulletinFileInfo;
import com.vmware.vide.project.vib.PropertyManager;
import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.VIBPropertyChangedEvent;
import com.vmware.vide.project.vib.VIBPropertyListener;
import com.vmware.vide.project.vib.ui.IVIBFormPage;
import com.vmware.vide.project.vib.ui.UIBlock;
import com.vmware.vide.project.vib.ui.VIBEditor;
import com.vmware.vide.vxmleditor.Activator;
import com.vmware.vide.vxmleditor.Schema;
import com.vmware.vide.vxmleditor.model.XMLNode;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Node;

public class BulletinSpecificPage
extends FormPage
implements IVIBFormPage {
    private static final String PAGE_ID = "com.vmware.vide.project.vib.BulletinSpecificPage";
    private static final String PAGE_TITLE = "Bulletin Input";
    private static final String VIBINFO_SECTION = "Metadata Information";
    private static final String UNMODIFIABLE_MARKER = "[";
    private static final String[] VIB_FILTER_NAMES = new String[]{"VIB Package Fiels (*.vib)", "All Files (*.*)"};
    private static final String[] VIB_EXTS = new String[]{"*.vib", "*.*"};
    private static final String VIBAUTHOR = "vibauthor";
    private static final String BIN_VIBAUTHOR = "bin/vibauthor";
    private static final String VIBTOOLS_DIR_PATTERN = "vibtools-.*-(\\d+)";
    private static final String VIBLIST_NODE_PATH = "bulletin.vibList";
    private static final String BUILDERS_MARKER = " FILLED BY DEVKIT ";
    private static final String VIBID_NODE_NAME = "vibID";
    private static final String VMWARE_DIR = "/opt/vmware";
    private static final String VIBID_EXTRACT_PATTERN = "VIB ID:\\s+([^\\s]+)";
    private static final String DEFAULT_VIBAUTHOR_COMMAND_PATH = "/opt/vmware/vibtools/bin/vibauthor";
    private static final String DESC_ADD_BUTTON = "Pops up the file selection dialog to select VIB package file(s). Extracts VIB ID(s) from the selected VIB package file(s) and adds the extracted VIB ID(s) to the list box.";
    private static final String TITLE_VIB_PACKAGE_SELECT_DIALOG = "Select VIB Package File";
    private static final String DESC_VIBIDS = "Specify VIB IDs that address the content or issue solved by this bulletin. \"Add...\" button will assist to fill VIB IDs by extracting VIB IDs from existing VIB package files.";
    private String prevFilterPath = "";
    private List<UIBlock> uiblocks;
    private boolean modified = false;
    private BulletinFileInfo fileInfo;
    private VIBEditor vibeditor;
    private List<VIBProperty> mainProperties = new ArrayList<VIBProperty>();
    private org.eclipse.swt.widgets.List listVIBID;
    private Button buttonUp;
    private Button buttonDown;
    private Button buttonDelete;
    private VIBPropertyListener propertyListener;
    private Set<VIBProperty> errorSet;

    public BulletinSpecificPage(VIBEditor editor, BulletinFileInfo fileInfo) {
        super((FormEditor)editor, PAGE_ID, PAGE_TITLE);
        this.uiblocks = new ArrayList<UIBlock>();
        this.fileInfo = fileInfo;
        this.vibeditor = editor;
        VIBProperty[] vIBPropertyArray = fileInfo.getPropertyManager().getAllProperties();
        int n = vIBPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty prop = vIBPropertyArray[n2];
            if (!prop.isHyperlinkWidget() && prop.isBulletin()) {
                this.mainProperties.add(prop);
            }
            ++n2;
        }
    }

    private void findErorOnpage() {
        for (VIBProperty property : this.mainProperties) {
            if (!property.isTextWidget() || property.getInputFormat() == null) continue;
            String propString = property.getPropertyValue();
            if (propString == null) {
                propString = "";
            }
            if (propString.matches(property.getInputFormat())) {
                this.removeErrorOnPage(property);
                continue;
            }
            this.addErrorOnPage(property);
        }
    }

    public void dispose() {
        this.fileInfo.getPropertyManager().removeVIBPropertyListener(this.propertyListener);
        super.dispose();
    }

    public boolean isDirty() {
        return this.modified;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.modified = false;
    }

    @Override
    public void setDirty(boolean b) {
        this.modified = b;
    }

    @Override
    public VIBEditor getVIBEditor() {
        return this.vibeditor;
    }

    @Override
    public VIBFileInfo getVIBFileInfo() {
        return this.fileInfo;
    }

    public void refresh() {
        for (UIBlock uiblock : this.uiblocks) {
            uiblock.refresh(this.fileInfo);
        }
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        ScrolledForm form = mform.getForm();
        FormToolkit toolkit = mform.getToolkit();
        form.setText(PAGE_TITLE);
        form.setBackgroundImage(Activator.getDefault().getImage("from_background.gif"));
        toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        toolkit.decorateFormHeading(form.getForm());
        IMessageManager msgmanager = mform.getMessageManager();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 6;
        layout.horizontalSpacing = 20;
        form.getBody().setLayout((Layout)layout);
        GridData griddata = new GridData(1808);
        griddata.widthHint = 800;
        griddata.heightHint = 300;
        form.setLayoutData((Object)griddata);
        this.createMainPropertySection(form, msgmanager, toolkit);
        this.createVIBIDSection(form, msgmanager, toolkit);
        msgmanager.update();
    }

    private void createMainPropertySection(ScrolledForm form, IMessageManager mmanager, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 322);
        section.setText(VIBINFO_SECTION);
        Composite parent = toolkit.createComposite((Composite)section);
        section.setClient((Control)parent);
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout();
        glayout.horizontalSpacing = 10;
        glayout.numColumns = 3;
        glayout.marginTop = 10;
        parent.setLayout((Layout)glayout);
        toolkit.paintBordersFor(parent);
        for (VIBProperty property : this.mainProperties) {
            this.uiblocks.add(new UIBlock(this, toolkit, parent, mmanager, property));
        }
        section.setExpanded(false);
        section.setExpanded(true);
    }

    private void createVIBIDSection(ScrolledForm form, IMessageManager mmanager, FormToolkit toolkit) {
        final Composite parent = toolkit.createComposite(form.getBody());
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout();
        glayout.horizontalSpacing = 10;
        glayout.numColumns = 2;
        parent.setLayout((Layout)glayout);
        toolkit.paintBordersFor(parent);
        Section section = toolkit.createSection(parent, 450);
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        section.setText("VIB IDs");
        section.setDescription(DESC_VIBIDS);
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.listVIBID = new org.eclipse.swt.widgets.List(composite, 2818);
        gd = new GridData(4, 0, true, false);
        gd.verticalSpan = 4;
        gd.widthHint = 200;
        gd.heightHint = this.listVIBID.getItemHeight() * 4;
        this.listVIBID.setLayoutData((Object)gd);
        this.listVIBID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BulletinSpecificPage.this.updateButtons();
            }
        });
        this.listVIBID.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                BulletinSpecificPage.this.listVIBID.setToolTipText(null);
            }

            public void mouseHover(MouseEvent e) {
                int index;
                Widget w = e.widget;
                if (w == BulletinSpecificPage.this.listVIBID && (index = e.y / BulletinSpecificPage.this.listVIBID.getItemHeight()) < BulletinSpecificPage.this.listVIBID.getItemCount()) {
                    String id = BulletinSpecificPage.this.listVIBID.getItem(index);
                    if (id.startsWith(BulletinSpecificPage.UNMODIFIABLE_MARKER)) {
                        id = "Preserved by the builder for the current VIB. \n" + id;
                    }
                    BulletinSpecificPage.this.listVIBID.setToolTipText(id);
                }
            }
        });
        Button buttonAdd = this.createButton(toolkit, composite, "Add...");
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] ids = BulletinSpecificPage.this.importVIBIDs(parent.getShell());
                if (BulletinSpecificPage.this.addVIBIDsToList(ids)) {
                    BulletinSpecificPage.this.updateButtons();
                    BulletinSpecificPage.this.setDirty(true);
                    BulletinSpecificPage.this.vibeditor.firePropertyChange();
                    BulletinSpecificPage.this.updateVIBIDNodes();
                }
            }
        });
        buttonAdd.setToolTipText(DESC_ADD_BUTTON);
        this.buttonDelete = this.createButton(toolkit, composite, "Delete");
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = BulletinSpecificPage.this.listVIBID.getSelectionIndices();
                indexes = BulletinSpecificPage.this.validateRemovables(indexes);
                BulletinSpecificPage.this.listVIBID.remove(indexes);
                BulletinSpecificPage.this.listVIBID.deselectAll();
                BulletinSpecificPage.this.updateButtons();
                BulletinSpecificPage.this.setDirty(true);
                BulletinSpecificPage.this.vibeditor.firePropertyChange();
                BulletinSpecificPage.this.updateVIBIDNodes();
            }
        });
        this.buttonUp = this.createButton(toolkit, composite, "Up");
        this.buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = BulletinSpecificPage.this.listVIBID.getSelectionIndex();
                String prev = BulletinSpecificPage.this.listVIBID.getItem(i - 1);
                BulletinSpecificPage.this.listVIBID.setItem(i - 1, BulletinSpecificPage.this.listVIBID.getItem(i));
                BulletinSpecificPage.this.listVIBID.setItem(i, prev);
                BulletinSpecificPage.this.listVIBID.deselect(i);
                BulletinSpecificPage.this.listVIBID.select(i - 1);
                BulletinSpecificPage.this.updateButtons();
                BulletinSpecificPage.this.setDirty(true);
                BulletinSpecificPage.this.vibeditor.firePropertyChange();
                BulletinSpecificPage.this.updateVIBIDNodes();
            }
        });
        this.buttonDown = this.createButton(toolkit, composite, "Down");
        this.buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = BulletinSpecificPage.this.listVIBID.getSelectionIndex();
                String next = BulletinSpecificPage.this.listVIBID.getItem(i + 1);
                BulletinSpecificPage.this.listVIBID.setItem(i + 1, BulletinSpecificPage.this.listVIBID.getItem(i));
                BulletinSpecificPage.this.listVIBID.setItem(i, next);
                BulletinSpecificPage.this.listVIBID.deselect(i);
                BulletinSpecificPage.this.listVIBID.select(i + 1);
                BulletinSpecificPage.this.updateButtons();
                BulletinSpecificPage.this.setDirty(true);
                BulletinSpecificPage.this.vibeditor.firePropertyChange();
                BulletinSpecificPage.this.updateVIBIDNodes();
            }
        });
        this.listVIBID.setItems(this.getVIBIDs());
        this.propertyListener = new VIBPropertyListener(){

            @Override
            public void changed(VIBPropertyChangedEvent event) {
                BulletinSpecificPage.this.updateUnmodifiableVIBID(event.property);
            }
        };
        this.fileInfo.getPropertyManager().addVIBPropertyListener(this.propertyListener);
    }

    private Button createButton(FormToolkit toolkit, Composite comp, String label) {
        Button b = toolkit.createButton(comp, label, 8);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        b.setLayoutData((Object)gd);
        return b;
    }

    private boolean canUp() {
        return this.listVIBID.getSelectionIndex() != 0;
    }

    private boolean canDown() {
        return this.listVIBID.getSelectionIndex() < this.listVIBID.getItemCount() - 1;
    }

    private boolean canDelete() {
        return this.canDelete(this.listVIBID.getSelectionIndex());
    }

    private boolean canDelete(int index) {
        return !this.listVIBID.getItem(index).startsWith("UNMODIFIABLE_MARKER");
    }

    private void updateButtons() {
        int count = this.listVIBID.getSelectionCount();
        if (count == 0) {
            this.buttonUp.setEnabled(false);
            this.buttonDown.setEnabled(false);
            this.buttonDelete.setEnabled(false);
        } else if (count == 1) {
            this.buttonUp.setEnabled(this.canUp());
            this.buttonDown.setEnabled(this.canDown());
            this.buttonDelete.setEnabled(this.canDelete());
        } else {
            this.buttonUp.setEnabled(false);
            this.buttonDown.setEnabled(false);
            this.buttonDelete.setEnabled(true);
        }
    }

    private int[] validateRemovables(int[] indexes) {
        ArrayList<Integer> validIndexes = new ArrayList<Integer>();
        Object object = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = object[n2];
            if (this.canDelete(i)) {
                validIndexes.add(new Integer(i));
            }
            ++n2;
        }
        int[] indexArray = new int[validIndexes.size()];
        int i = 0;
        object = validIndexes.iterator();
        while (object.hasNext()) {
            Integer validIndex = (Integer)object.next();
            indexArray[i] = validIndex;
            ++i;
        }
        return indexArray;
    }

    private String[] getVIBIDs() {
        ArrayList<String> vibIDs = new ArrayList<String>();
        XMLNode node = this.fileInfo.findXMLNodeByPath(VIBLIST_NODE_PATH);
        if (node != null) {
            XMLNode[] children = node.getChildrenWithComments();
            boolean devkitFill = false;
            XMLNode[] xMLNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                XMLNode n3 = xMLNodeArray[n2];
                Node nn = n3.getNode();
                if (nn.getNodeType() == 8 && BUILDERS_MARKER.trim().equals(nn.getTextContent().trim())) {
                    devkitFill = true;
                }
                if (nn.getNodeType() == 1) {
                    if (devkitFill) {
                        devkitFill = false;
                        vibIDs.add(this.getUnmodifiableVIBID());
                    } else {
                        vibIDs.add(nn.getTextContent());
                    }
                }
                ++n2;
            }
        }
        return vibIDs.toArray(new String[vibIDs.size()]);
    }

    private String[] importVIBIDs(Shell shell) {
        List<Object> vibIDs = new ArrayList();
        FileDialog dlg = new FileDialog(shell, 2);
        dlg.setText(TITLE_VIB_PACKAGE_SELECT_DIALOG);
        dlg.setFilterExtensions(VIB_EXTS);
        dlg.setFilterNames(VIB_FILTER_NAMES);
        if (this.prevFilterPath == null || this.prevFilterPath.isEmpty()) {
            IPath path = this.fileInfo.getVIBFile().getLocation();
            dlg.setFilterPath(path.removeLastSegments(1).toOSString());
        } else {
            dlg.setFilterPath(this.prevFilterPath);
        }
        String fn = dlg.open();
        if (fn != null) {
            String[] fileNames = dlg.getFileNames();
            String base = dlg.getFilterPath();
            if (base.charAt(base.length() - 1) != '/') {
                base = String.valueOf(base) + '/';
            }
            ArrayList<String> vibFiles = new ArrayList<String>();
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                StringBuilder sb = new StringBuilder(base);
                sb.append(name);
                vibFiles.add(sb.toString());
                ++n2;
            }
            vibIDs = this.extractVIBIDs(shell, vibFiles);
            if (vibIDs.size() > 0) {
                this.prevFilterPath = dlg.getFilterPath();
            }
        }
        return vibIDs.toArray(new String[vibIDs.size()]);
    }

    private List<String> extractVIBIDs(Shell shell, List<String> vibFiles) {
        boolean answer;
        ArrayList<String> vibIDs = new ArrayList<String>();
        String vibCommand = this.getVIBCommand();
        if (vibCommand == null && (answer = MessageDialog.openQuestion((Shell)shell, (String)"Cannot Find Vibauthor Tool", (String)"Do you want to specify a vibauthor tool and proceed ?"))) {
            FileDialog dlg = new FileDialog(shell, 4096);
            dlg.setFilterPath(VMWARE_DIR);
            dlg.setFilterExtensions(new String[]{"*vibauthor*", "*"});
            String fn = dlg.open();
            if (fn != null) {
                File cmd = new File(fn);
                if (cmd.canExecute()) {
                    vibCommand = cmd.getAbsolutePath();
                } else {
                    MessageDialog.openError((Shell)shell, (String)"Bad Executable Error", (String)String.format("[%s] is not executable.", fn));
                }
            }
        }
        if (vibCommand != null) {
            Pattern pattern = Pattern.compile(VIBID_EXTRACT_PATTERN);
            for (String vibFile : vibFiles) {
                ProcessBuilder pb = new ProcessBuilder(vibCommand, "-i", "-v", vibFile);
                try {
                    Matcher m;
                    Process proc = pb.start();
                    NullReaderThread nullReader = new NullReaderThread(proc.getErrorStream());
                    nullReader.start();
                    PatternReaderThread patternReader = new PatternReaderThread(proc.getInputStream(), pattern, false);
                    patternReader.start();
                    proc.waitFor();
                    nullReader.join();
                    patternReader.join();
                    List<String> lines = patternReader.getMatchedLines();
                    if (lines.size() != 1 || !(m = pattern.matcher(lines.get(0))).matches()) continue;
                    vibIDs.add(m.group(1));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return vibIDs;
    }

    private String getVIBCommand() {
        String base = VMWARE_DIR;
        String defaultCommand = DEFAULT_VIBAUTHOR_COMMAND_PATH;
        File vmware_dir = new File(base);
        if (vmware_dir.isDirectory()) {
            VibToolFilter filter = new VibToolFilter();
            vmware_dir.listFiles(filter);
            File f = filter.getGratest();
            if (f != null) {
                return f.getAbsolutePath();
            }
            String p = System.getenv("PATH");
            String[] paths = new String[]{p};
            if (p.contains(":")) {
                paths = p.split(":");
            }
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.charAt(path.length() - 1) != '/') {
                    path = String.valueOf(path) + '/';
                }
                if ((f = new File(String.valueOf(path) + VIBAUTHOR)).canExecute()) {
                    return f.getAbsolutePath();
                }
                ++n2;
            }
            if (new File(defaultCommand).canExecute()) {
                return defaultCommand;
            }
        }
        return null;
    }

    private boolean addVIBIDsToList(String[] ids) {
        boolean changed = false;
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(this.listVIBID.getItems()));
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!items.contains(id)) {
                items.add(id);
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            this.listVIBID.setItems(items.toArray(new String[items.size()]));
        }
        return changed;
    }

    private String getUnmodifiableVIBID() {
        return String.format("[Filled By Build : %s]", this.getCalculatedVIBID());
    }

    private String getCalculatedVIBID() {
        PropertyManager pm = this.fileInfo.getPropertyManager();
        String vendor = pm.getProperty("vib.vendor").getPropertyValue();
        String name = pm.getProperty("vib.name").getPropertyValue();
        String version = pm.getProperty("vib.version").getPropertyValue();
        return String.format("%s_%s_%s_%s", vendor, "bootbank", name, version);
    }

    private void updateUnmodifiableVIBID(VIBProperty property) {
        String name;
        int index = this.getIndexOfUnmodifiableVIBID();
        if (index != -1 && ("vib.vendor".equals(name = property.getNodeNames()) || "vib.name".equals(name) || "vib.version".equals(name))) {
            this.listVIBID.setItem(index, this.getUnmodifiableVIBID());
        }
    }

    private int getIndexOfUnmodifiableVIBID() {
        int i = 0;
        while (i < this.listVIBID.getItemCount()) {
            if (this.listVIBID.getItem(i).startsWith(UNMODIFIABLE_MARKER)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateVIBIDNodes() {
        XMLNode xn = this.fileInfo.findXMLNodeByPath(VIBLIST_NODE_PATH);
        if (xn != null) {
            XMLNode[] children;
            XMLNode[] xMLNodeArray = children = xn.getChildrenWithComments();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                XMLNode x = xMLNodeArray[n2];
                xn.removeChildNodeIncludingComment(x);
                ++n2;
            }
            Object[] objects = xn.getSchemaElements();
            Schema.Elem elem = null;
            Object[] objectArray = objects;
            int n3 = objects.length;
            int n4 = 0;
            while (n4 < n3) {
                Object o = objectArray[n4];
                if (o instanceof Schema.Elem) {
                    elem = (Schema.Elem)o;
                    if (elem.name.equals(VIBID_NODE_NAME)) break;
                }
                ++n4;
            }
            if (elem == null) {
                return;
            }
            objectArray = this.listVIBID.getItems();
            n3 = objectArray.length;
            n4 = 0;
            while (n4 < n3) {
                Object id = objectArray[n4];
                if (((String)id).startsWith(UNMODIFIABLE_MARKER)) {
                    xn.appendCommentNode(BUILDERS_MARKER);
                    id = "";
                }
                xn.appendChildNode((Object)elem, (String)id);
                ++n4;
            }
        }
    }

    @Override
    public void addErrorOnPage(VIBProperty errorProperty) {
        this.errorSet.add(errorProperty);
    }

    @Override
    public void removeErrorOnPage(VIBProperty errorProperty) {
        this.errorSet.remove(errorProperty);
    }

    @Override
    public Set<VIBProperty> getErrorSet() {
        if (this.errorSet == null) {
            this.errorSet = new HashSet<VIBProperty>();
            this.findErorOnpage();
        }
        return this.errorSet;
    }

    class VibToolFilter
    implements FileFilter {
        private int buildNum = -1;
        private File greatest;
        private List<File> commands = new ArrayList<File>();
        private Pattern dir_pattern = Pattern.compile("vibtools-.*-(\\d+)");

        VibToolFilter() {
        }

        @Override
        public boolean accept(File f) {
            File cmd;
            Matcher m;
            boolean accept = false;
            if (f.isDirectory() && (m = this.dir_pattern.matcher(f.getName())).matches() && (cmd = new File(String.valueOf(f.getAbsolutePath()) + File.separator + BulletinSpecificPage.BIN_VIBAUTHOR)).canExecute()) {
                int build = Integer.parseInt(m.group(1));
                if (build > this.buildNum) {
                    this.buildNum = build;
                    this.greatest = cmd;
                }
                this.commands.add(cmd);
                accept = true;
            }
            return accept;
        }

        public File getGratest() {
            return this.greatest;
        }

        public List<File> getCommands() {
            return this.commands;
        }
    }
}

