/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.menu;

import com.vmware.vide.project.config.devkit.ProjectMenu;
import com.vmware.vide.project.manager.ProjectManager;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public abstract class ProjectMenuExpression
extends Expression {
    protected EvaluationResult evaluate(IEvaluationContext context, ProjectMenu menu, IProject project, String[] projectNatures) throws CoreException {
        if (project == null) {
            project = this.getProject(context);
        }
        if (project == null) {
            return EvaluationResult.FALSE;
        }
        if (!project.isAccessible()) {
            return EvaluationResult.FALSE;
        }
        if (!project.hasNature("com.vmware.vide.core.devkitnature")) {
            return EvaluationResult.FALSE;
        }
        String projectDevkitId = ProjectManager.getDevkitId(project);
        if (projectDevkitId == null) {
            return EvaluationResult.FALSE;
        }
        if (!projectDevkitId.equals(menu.getDevkitId())) {
            return EvaluationResult.FALSE;
        }
        if (projectNatures == null || projectNatures.length == 0) {
            return EvaluationResult.TRUE;
        }
        if (this.hasNature(project, projectNatures) && menu.isVisible(project)) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }

    private boolean hasNature(IProject project, String[] projectNatures) throws CoreException {
        int i = 0;
        while (i < projectNatures.length) {
            if (project.hasNature(projectNatures[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IProject getProject(IEvaluationContext context) {
        Object var;
        IProject project = null;
        if (context != null && context.getDefaultVariable() != null && (var = context.getDefaultVariable()) instanceof List) {
            IProject resProj = null;
            for (Object o : (List)var) {
                if (o instanceof IResource) {
                    resProj = ((IResource)o).getProject();
                } else {
                    IResource res;
                    if (!(o instanceof IAdaptable) || (res = (IResource)((IAdaptable)o).getAdapter(IResource.class)) == null) continue;
                    resProj = res.getProject();
                }
                if (project == null) {
                    project = resProj;
                    continue;
                }
                if (resProj.equals((Object)project)) continue;
                return null;
            }
        }
        return project;
    }
}

