/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.menu;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.ProjectMenu;
import com.vmware.vide.project.menu.DynamicGroupMenuVisibleWhenExpression;
import com.vmware.vide.project.menu.DynamicMenuVisibleWhenExpression;
import com.vmware.vide.project.menu.GroupPopupMenuVisibleWhenExpression;
import com.vmware.vide.project.menu.GroupProjectMenuVisibleWhenExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicMenuContributionFactory
extends ExtensionContributionFactory {
    private static final String ID_MENU = "com.vmware.vide.project.dynamicmenu";
    private static final String ID_COMMAND = "com.vmware.vide.project.command";
    private static final String ID_NULL_COMMAND = "com.vmware.vide.project.command.null";
    private static final String GROUP_MENU_PREFIX = "com.vmware.vide.project.dynamicmenu.group.";

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        Map<String, Set<ProjectMenu>> allMenues = ProjectPlugin.getConfig().getAllDynamicMenus();
        for (Map.Entry<String, Set<ProjectMenu>> menus : allMenues.entrySet()) {
            this.createDevkitMenus(serviceLocator, additions, menus.getValue(), menus.getKey());
        }
    }

    private void createDevkitMenus(IServiceLocator locator, IContributionRoot root, Set<ProjectMenu> menus, String devkitId) {
        Map<String, List<ProjectMenu>> groups = this.extractGroupMenus(menus);
        for (ProjectMenu menu : menus) {
            if (menu.isGroup()) {
                if (!groups.containsKey(menu.getGroupName())) continue;
                String groupName = menu.getGroupName();
                List<ProjectMenu> menuList = groups.get(groupName);
                this.createGroupMenuDelegate(locator, root, devkitId, groupName, menuList);
                groups.remove(groupName);
                continue;
            }
            this.createCommandContributionItem(locator, root, menu);
        }
    }

    private Map<String, List<ProjectMenu>> extractGroupMenus(Set<ProjectMenu> menus) {
        HashMap<String, List<ProjectMenu>> groupMenus = new HashMap<String, List<ProjectMenu>>();
        for (ProjectMenu menu : menus) {
            if (!menu.isGroup()) continue;
            String groupName = menu.getGroupName();
            ArrayList<ProjectMenu> menuList = (ArrayList<ProjectMenu>)groupMenus.get(groupName);
            if (menuList == null) {
                menuList = new ArrayList<ProjectMenu>();
                groupMenus.put(groupName, menuList);
            }
            menuList.add(menu);
        }
        return groupMenus;
    }

    private void createGroupMenuDelegate(IServiceLocator locator, IContributionRoot root, String devkitId, String groupName, List<ProjectMenu> menus) {
        String groupMenuId = DynamicMenuContributionFactory.getGroupMenuId(groupName);
        CommandContributionItemParameter param = new CommandContributionItemParameter(locator, groupMenuId, ID_NULL_COMMAND, 8);
        param.label = "group." + groupName;
        CommandContributionItem contributionItem = new CommandContributionItem(param);
        DynamicGroupMenuVisibleWhenExpression visibleWhen = null;
        visibleWhen = this.isPopupMenu() ? new GroupPopupMenuVisibleWhenExpression(devkitId, groupName, menus) : new GroupProjectMenuVisibleWhenExpression(devkitId, groupName, menus);
        root.addContributionItem((IContributionItem)contributionItem, (Expression)visibleWhen);
    }

    private CommandContributionItem createCommandContributionItem(IServiceLocator serviceLocator, IContributionRoot root, ProjectMenu menu) {
        CommandContributionItemParameter param = new CommandContributionItemParameter(serviceLocator, ID_MENU, ID_COMMAND, 8);
        param.label = menu.getTitle();
        CommandContributionItem contributionItem = new CommandContributionItem(param);
        String[] natureids = menu.getProjectNatureIds();
        DynamicMenuVisibleWhenExpression visibleWhen = new DynamicMenuVisibleWhenExpression(natureids, menu);
        root.addContributionItem((IContributionItem)contributionItem, (Expression)visibleWhen);
        return contributionItem;
    }

    static String getGroupMenuId(String groupName) {
        StringBuilder sb = new StringBuilder(GROUP_MENU_PREFIX).append(groupName);
        return sb.toString();
    }

    private boolean isPopupMenu() {
        String location = this.getLocation();
        return location.startsWith("popup:");
    }
}

