/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.wizard.AbstractContent;
import com.vmware.vide.project.config.wizard.AbstractWizardType;
import com.vmware.vide.project.config.wizard.WizardCategory;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.utils.Utils;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.ResourcesPlugin;

public abstract class AbstractWizardData
extends AbstractContent {
    public static final String DATATYPE_PROJECT = "projectinfo";
    private static final String PROP_WORKSPACE_LOC = "WORKSPACE_LOC";
    public static Hashtable<String, String> globalInfo = new Hashtable();
    private static final String[] datatypes;
    private String datatype;
    private DevkitInfo devkitinfo = null;
    protected Hashtable<String, String> properties = new Hashtable();
    protected boolean isvalid;
    protected WizardCategory parent;

    static {
        globalInfo.put(PROP_WORKSPACE_LOC, ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        datatypes = new String[]{DATATYPE_PROJECT};
    }

    public abstract String[] getPropertyTypes();

    public abstract String[] getRequiredPropertyTypes();

    public AbstractWizardData(WizardCategory parent, String type, Object config) {
        this.parent = parent;
        this.datatype = type;
        this.refreshConfig(config);
    }

    public boolean isValid() {
        return this.isvalid;
    }

    public String getTitle() {
        return this.parent.getTitle();
    }

    public String getDescription() {
        return this.parent.getDescription();
    }

    public String getType() {
        return this.datatype;
    }

    public String getProperty(String type, boolean searchparent) {
        if (this.properties.containsKey(type)) {
            return Utils.replaceContent(this.properties.get(type), globalInfo);
        }
        if (searchparent) {
            return this.parent.getProperty(type, searchparent);
        }
        return null;
    }

    public void refreshConfig(Object config) {
        this.isvalid = false;
        if (config == null) {
            return;
        }
        try {
            String[] types = this.getPropertyTypes();
            if (types != null) {
                int i = 0;
                while (i < types.length) {
                    String value = ConfigUtil.lookupString((Object)config, (String)types[i]);
                    if (value != null && !value.isEmpty()) {
                        this.properties.put(types[i], value);
                    }
                    ++i;
                }
            }
            this.isvalid = true;
            String[] reqtypes = this.getRequiredPropertyTypes();
            int i = 0;
            while (i < reqtypes.length) {
                String value = this.getProperty(reqtypes[i], true);
                if (value == null || value.isEmpty()) {
                    this.isvalid = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.isvalid = false;
            e.printStackTrace();
        }
    }

    public DevkitInfo getDevkitInfo() {
        if (this.devkitinfo != null) {
            return this.devkitinfo;
        }
        Object obj = this.parent.getParent();
        while (obj instanceof WizardCategory) {
            obj = ((WizardCategory)obj).getParent();
        }
        if (obj instanceof AbstractWizardType) {
            this.devkitinfo = ((AbstractWizardType)obj).getDevkitInfo();
        }
        return this.devkitinfo;
    }

    public static ArrayList<AbstractWizardData> createWizardData(WizardCategory parent, Object config) {
        ArrayList<AbstractWizardData> data = new ArrayList<AbstractWizardData>();
        int i = 0;
        while (i < datatypes.length) {
            ArrayList types = ConfigUtil.lookupList((Object)config, (String)datatypes[i]);
            if (types != null && types.size() != 0 && datatypes[i].equals(DATATYPE_PROJECT)) {
                int j = 0;
                while (j < types.size()) {
                    ProjectData project = new ProjectData(parent, types.get(j));
                    if (project.isValid()) {
                        data.add(project);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return data;
    }

    @Override
    public Object[] getChildren() {
        return new Object[0];
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public String getText() {
        return this.datatype;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }
}

