/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config;

import com.vmware.vide.init.IConfigChangeListener;
import com.vmware.vide.init.InitPlugin;
import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.DevkitInfo;
import com.vmware.vide.project.config.devkit.MenuResource;
import com.vmware.vide.project.config.devkit.ProjectMenu;
import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.config.wizard.AbstractWizardType;
import com.vmware.vide.project.manager.ProjectManager;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Configuration {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    public static final String RESOURCE_VIB = "vib";
    public static final String RESOURCE_FILE = "file";
    public static final String RESOURCE_PROJECT_PROPERTY = "project_property";
    private static final String KEYPATH_ENABLED = "wizard.enabled";
    private static final String KEYPATH_WIZARDTYPE = "wizard.type";
    private static final String KEYPATH_VIB = "vib";
    private static final String TAG_TYPE = "type";
    private static final String KEYPATH_PROJECTMENU = "project.menu";
    private static Hashtable<String, ArrayList<AbstractWizardType>> configs = new Hashtable();
    private static Hashtable<String, ArrayList<VIBData>> vibinfos = new Hashtable();
    private static Map<String, Set<ProjectMenu>> devkitmenus = new HashMap<String, Set<ProjectMenu>>();
    private static ArrayList<DevkitInfo> devkits = new ArrayList();

    public Configuration() {
        this.refreshConfig();
        InitPlugin.getDefault().addEventListener((IConfigChangeListener)new ConfigChangeListener());
    }

    public void refreshConfig() {
        int i;
        configs.clear();
        vibinfos.clear();
        devkits.clear();
        devkitmenus.clear();
        String[] kitids = InitPlugin.getDefault().getKitIdsMatching(KEYPATH_ENABLED, "true", false);
        if (kitids != null) {
            i = 0;
            while (i < kitids.length) {
                Map kitinfo = InitPlugin.getDefault().getKitInfo(kitids[i]);
                try {
                    DevkitInfo devkitinfo = new DevkitInfo(kitids[i], kitinfo);
                    devkits.add(devkitinfo);
                }
                catch (Exception e) {
                    System.err.print("Failed to add new development kit: " + e.getMessage());
                }
                ++i;
            }
        }
        i = 0;
        while (i < devkits.size()) {
            ArrayList menus;
            ArrayList vibs;
            String devkitid = devkits.get(i).getId();
            ArrayList wizards = InitPlugin.getDefault().getAllNodeValues(devkitid, KEYPATH_WIZARDTYPE);
            if (wizards != null) {
                int j = 0;
                while (j < wizards.size()) {
                    Map node = (Map)wizards.get(j);
                    if (node != null) {
                        for (String type : node.keySet()) {
                            if (!type.equals(TAG_TYPE)) continue;
                            Object wizardinfo = node.get(type);
                            AbstractWizardType config = AbstractWizardType.createWizardType(devkits.get(i), wizardinfo);
                            if (config == null || !config.isValid()) continue;
                            String wizardtype = config.getWizardType();
                            if (configs.containsKey(wizardtype)) {
                                configs.get(wizardtype).add(config);
                                continue;
                            }
                            ArrayList<AbstractWizardType> array = new ArrayList<AbstractWizardType>();
                            array.add(config);
                            configs.put(wizardtype, array);
                        }
                    }
                    ++j;
                }
            }
            if ((vibs = InitPlugin.getDefault().getAllNodeValues(devkitid, "vib")) != null) {
                int j = 0;
                while (j < vibs.size()) {
                    Map node = (Map)vibs.get(j);
                    if (node != null) {
                        for (String key : node.keySet()) {
                            VIBData data = new VIBData(node.get(key));
                            if (!data.isValid()) continue;
                            if (vibinfos.containsKey(devkitid)) {
                                vibinfos.get(devkitid).add(data);
                            } else {
                                ArrayList<VIBData> vibdata = new ArrayList<VIBData>();
                                vibdata.add(data);
                                vibinfos.put(devkitid, vibdata);
                            }
                            devkits.get(i).addResource("vib", data);
                        }
                    }
                    ++j;
                }
            }
            if ((menus = InitPlugin.getDefault().getAllNodeValues(devkitid, KEYPATH_PROJECTMENU)) != null) {
                HashSet<ProjectMenu> projMenus = new HashSet<ProjectMenu>();
                int j = 0;
                while (j < menus.size()) {
                    Map node = (Map)menus.get(j);
                    if (node != null) {
                        for (String key : node.keySet()) {
                            ProjectMenu menu = new ProjectMenu(devkits.get(i), node.get(key));
                            if (!menu.isValid()) continue;
                            projMenus.add(menu);
                        }
                    }
                    ++j;
                }
                devkitmenus.put(devkitid, projMenus);
            }
            ++i;
        }
    }

    public AbstractWizardType[] getWizardTypes(String type) {
        if (configs.containsKey(type)) {
            ArrayList<AbstractWizardType> wizardtypes = configs.get(type);
            return wizardtypes.toArray(new AbstractWizardType[wizardtypes.size()]);
        }
        return new AbstractWizardType[0];
    }

    public ArrayList<VIBData> getVIBData(String devkitid) {
        if (vibinfos.containsKey(devkitid)) {
            return vibinfos.get(devkitid);
        }
        return new ArrayList<VIBData>();
    }

    public Set<ProjectMenu> getDynamicMenus(String devkitid) {
        return devkitmenus.get(devkitid);
    }

    public Map<String, Set<ProjectMenu>> getAllDynamicMenus() {
        return devkitmenus;
    }

    public ProjectMenu getMenuInfoOfProject(String menutext, IProject project) {
        String devkitid = ProjectManager.getDevkitId(project);
        Set<ProjectMenu> menus = this.getDynamicMenus(devkitid);
        block2: for (ProjectMenu item : menus) {
            String[] natureids;
            if (!item.getTitle().equals(menutext)) continue;
            String[] stringArray = natureids = item.getProjectNatureIds();
            int n = natureids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    if (project.hasNature(id) && item.isRunnable(project, false) == MenuResource.STATUS.OK) {
                        return item;
                    }
                }
                catch (CoreException e) {
                    String msg = String.format("The specified project [%s] has been closed or deleted.", project.getName());
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg, (Throwable)e));
                    continue block2;
                }
                ++n2;
            }
        }
        this.dumpMenus(menus, project);
        return null;
    }

    private void dumpMenus(Set<ProjectMenu> menus, IProject project) {
        System.out.println("Dump project menus for the project " + project.getName());
        for (ProjectMenu item : menus) {
            System.out.println(item.toString());
        }
    }

    private class ConfigChangeListener
    implements IConfigChangeListener {
        private ConfigChangeListener() {
        }

        public void ConfigRefreshed(EventObject event) {
            Configuration.this.refreshConfig();
        }
    }
}

