/*
 * This file implements the RTP-MIB module.
 */
/* General includes */
#include <sys/types.h>

/* SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_debug.h>
#include <snmp_vars.h>


#include "covalent-snmp-config.h"
#include "rtp-mib/rtp-mib.h"

#ifdef RTP_MIB
void init_rtp_mib(void)
{
#ifdef RTP_SESSION_GROUP
   init_rtp_session_group();
#endif /* RTP_SESSION_GROUP */
#ifdef RTP_SENDER_GROUP
   init_rtp_sender_group();
#endif /* RTP_SESSION_GROUP */
#ifdef RTP_SENDER_GROUP
   init_rtp_receiver_group();
#endif /* RTP_RECEIVER_GROUP */
}
#endif /* RTP_MIB */
