/*
 * All functionality that handles temporary data storage
 * and functionality for restarts within Apache. DSO's
 * tend to loose the data. :-((
 */
/* Standard includes */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

/* SDBM includes */
#include <covalent_sdbm.h>

/* Covalent SNMP includes */
#include "covalent-snmp-config.h"
#include "apache-restarts.h"
#include "ap_config.h"

/*
 * Restart capability switch for disabling SNMP-SETs.
 */
static int restart_switch = ON;

ap_inline void
set_restart_capability(int set)
{
    restart_switch = set;
}

ap_inline int
check_restart_capability()
{
    return(restart_switch);
}

/*
 * Utils for the restarts of Apache.
 * Apache restarts loose data with DSOs.
 */
static DBM* shared_db = NULL;

void
shared_create(char *name)
{
char filename_array[512];

    if (shared_db) return; /* Already open */
    strcpy(filename_array, name);
    unlink(strcat(filename_array, DIRFEXT));
    strcpy(filename_array, name);
    unlink(strcat(filename_array, PAGFEXT));
    shared_db = covalent_sdbm_open(name, (O_CREAT | O_RDWR), 0664);
}

void
shared_open(char *name)
{
    if (shared_db) return; /* Already open */
    shared_db = covalent_sdbm_open(name, O_RDWR, 0664);
}


void
shared_close()
{
    if (!shared_db) return; /* Check if open */
    covalent_sdbm_close(shared_db);
    shared_db = NULL;
}

void *
shared_fetch(char *keystr, void *info_ptr, int info_size)  
{
datum key;
datum data;

    if (shared_db) { /* Check if open */
        key.dptr = keystr;
        key.dsize = strlen(keystr);
        data = covalent_sdbm_fetch(shared_db, key);
        if (data.dsize == info_size) {
            memcpy(info_ptr, data.dptr, info_size);
            return info_ptr;
	}
    }
    return(NULL);
}

int
shared_store(char *keystr, void *info_ptr, int info_size)
{
datum key;
datum data;

    if (shared_db) { /* Check if open */
        key.dptr = keystr;
        key.dsize = strlen(keystr);
        data.dptr = (char *)info_ptr;
        data.dsize = info_size;
        return(covalent_sdbm_store(shared_db, key, data, DBM_REPLACE));
    }
    return(0);
}


