/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.VMMetrics;
import java.util.Iterator;
import java.util.Map;
import org.hyperic.hq.plugin.xen.XenCollector;

public class XenVmCollector
extends XenCollector {
    public void collect() {
        try {
            Connection conn = this.connect();
            VM vm = VM.getByUuid(conn, this.getServerUUID());
            Types.VmPowerState state = vm.getPowerState(conn);
            double avail = state == Types.VmPowerState.RUNNING ? 1.0 : (state == Types.VmPowerState.PAUSED || state == Types.VmPowerState.SUSPENDED ? -0.01 : 0.0);
            this.setAvailability(avail);
            VMMetrics metrics = vm.getMetrics(conn);
            VMMetrics.Record record = metrics.getRecord(conn);
            this.setValue("MemoryActual", record.memoryActual.longValue());
            long startTime = record.startTime.getTime();
            this.setValue("StartTime", startTime);
            this.setValue("Uptime", System.currentTimeMillis() - startTime);
            Map<Long, Double> cpus = record.VCPUsUtilisation;
            double usage = 0.0;
            Iterator<Double> it = cpus.values().iterator();
            while (it.hasNext()) {
                usage += it.next().doubleValue();
            }
            this.setValue("CPUUsage", usage);
        }
        catch (Exception e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
        }
    }
}

