/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.xen.XenUtil;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.util.config.ConfigResponse;

public class XenHostDetector
extends PlatformDetector {
    private static final Log _log = LogFactory.getLog((String)XenHostDetector.class.getName());
    private Properties _props;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this._props = new Properties();
        String[] xenProps = new String[]{"url", "user", "pass", "platform.uuid"};
        for (int i = 0; i < xenProps.length; ++i) {
            String val = manager.getProperty(xenProps[i]);
            if (val == null) continue;
            this._props.setProperty(xenProps[i], val);
        }
    }

    private void setValue(ConfigResponse config, String key, String val) {
        if (val == null) {
            return;
        }
        config.setValue(key, val);
    }

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        config.merge(new ConfigResponse((Map)this._props), false);
        String uuid = config.getValue("platform.uuid");
        PlatformResource platform = super.getPlatformResource(config);
        if (uuid == null) {
            return platform;
        }
        Properties props = config.toProperties();
        Connection conn = XenUtil.connect(props);
        Host host = XenUtil.getHost(conn, props);
        ConfigResponse cprops = new ConfigResponse();
        try {
            _log.debug((Object)("Connected to: " + host.getHostname(conn)));
            platform.setDescription(host.getNameDescription(conn));
            Map<String, String> version = host.getSoftwareVersion(conn);
            this.setValue(cprops, "version", version.get("product_version"));
            this.setValue(cprops, "brand", version.get("product_brand"));
            this.setValue(cprops, "build_id", version.get("hg_id"));
            this.setValue(cprops, "hostname", version.get("hostname"));
            this.setValue(cprops, "date", version.get("date"));
            this.setValue(cprops, "build_number", version.get("build_number"));
            this.setValue(cprops, "linux", version.get("linux"));
            platform.setCustomProperties(cprops);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return platform;
    }
}

