/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.commands;

import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;

public abstract class DeleteProperties_args
extends AgentRemoteValue {
    private static final String PARAM_PNAME = "propName";
    private static final String PARAM_NPROPS = "nProps";

    private void setup() {
        this.setNumProperties(0);
    }

    public DeleteProperties_args() {
        this.setup();
    }

    public DeleteProperties_args(AgentRemoteValue args) throws AgentRemoteException {
        this.setup();
        int nProps = args.getValueAsInt(PARAM_NPROPS);
        for (int i = 0; i < nProps; ++i) {
            String key = args.getValue(PARAM_PNAME + i);
            this.addProperty(key);
        }
    }

    public int getNumProperties() {
        String val = this.getValue(PARAM_NPROPS);
        return Integer.parseInt(val);
    }

    private void setNumProperties(int newMeas) {
        super.setValue(PARAM_NPROPS, Integer.toString(newMeas));
    }

    public void addProperty(String key) {
        int curProps = this.getNumProperties();
        super.setValue(PARAM_PNAME + curProps, key);
        this.setNumProperties(curProps + 1);
    }

    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public String getPropertyName(int propNum) {
        String qval = PARAM_PNAME + propNum;
        return this.getValue(qval);
    }
}

