/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.agent.AgentCommandsAPI;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.AgentStreamPair;
import org.hyperic.hq.agent.FileData;
import org.hyperic.hq.agent.FileDataResult;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.client.AgentConnection;
import org.hyperic.hq.agent.client.FileStreamMultiplexer;
import org.hyperic.hq.agent.commands.AgentBundle_args;
import org.hyperic.hq.agent.commands.AgentBundle_result;
import org.hyperic.hq.agent.commands.AgentDie_args;
import org.hyperic.hq.agent.commands.AgentPing_args;
import org.hyperic.hq.agent.commands.AgentReceiveFileData_args;
import org.hyperic.hq.agent.commands.AgentRemoveFileData_args;
import org.hyperic.hq.agent.commands.AgentRestart_args;
import org.hyperic.hq.agent.commands.AgentUpgrade_args;
import org.hyperic.hq.agent.commands.AgentUpgrade_result;
import org.hyperic.hq.agent.commands.FileRemoval_result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyAgentCommandsClientImpl
implements AgentCommandsClient {
    private AgentConnection agentConn;
    private AgentCommandsAPI verAPI;

    public LegacyAgentCommandsClientImpl(AgentConnection agentConn) {
        this.agentConn = agentConn;
        this.verAPI = new AgentCommandsAPI();
    }

    @Override
    public long ping() throws AgentRemoteException, AgentConnectionException {
        AgentPing_args args = new AgentPing_args();
        long sendTime = System.currentTimeMillis();
        this.agentConn.sendCommand("agent:ping", this.verAPI.getVersion(), args, false);
        long recvTime = System.currentTimeMillis();
        return recvTime - sendTime;
    }

    @Override
    public void restart() throws AgentRemoteException, AgentConnectionException {
        AgentRestart_args args = new AgentRestart_args();
        this.agentConn.sendCommand("agent:restart", this.verAPI.getVersion(), args);
    }

    @Override
    public void die() throws AgentRemoteException, AgentConnectionException {
        AgentDie_args args = new AgentDie_args();
        this.agentConn.sendCommand("agent:die", this.verAPI.getVersion(), args);
    }

    @Override
    public FileDataResult[] agentSendFileData(FileData[] destFiles, InputStream[] streams) throws AgentRemoteException, AgentConnectionException {
        String cmd = "agent:receive_file";
        if (destFiles.length != streams.length) {
            throw new IllegalArgumentException("Streams and dest files arrays must be the same length");
        }
        AgentReceiveFileData_args args = new AgentReceiveFileData_args();
        for (int i = 0; i < destFiles.length; ++i) {
            args.addFileData(destFiles[i]);
        }
        AgentStreamPair sPair = this.agentConn.sendCommandHeaders(cmd, this.verAPI.getVersion(), args);
        try {
            FileStreamMultiplexer muxer = new FileStreamMultiplexer();
            FileDataResult[] rs = muxer.sendData(sPair.getOutputStream(), destFiles, streams);
            this.agentConn.getCommandResult(sPair);
            FileDataResult[] fileDataResultArray = rs;
            return fileDataResultArray;
        }
        catch (IOException exc) {
            throw new AgentRemoteException("IO Exception while sending file data: " + exc.getMessage());
        }
        finally {
            try {
                sPair.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public Map upgrade(String tarFile, String destination) throws AgentRemoteException, AgentConnectionException {
        AgentUpgrade_args args = new AgentUpgrade_args(tarFile, destination);
        AgentRemoteValue cmdRes = this.agentConn.sendCommand("agent:upgrade", this.verAPI.getVersion(), args);
        AgentUpgrade_result upgradeResult = new AgentUpgrade_result(cmdRes);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("version", upgradeResult.getAgentVersion());
        result.put("bundleName", upgradeResult.getAgentBundleName());
        return result;
    }

    @Override
    public String getCurrentAgentBundle() throws AgentRemoteException, AgentConnectionException {
        AgentBundle_args args = new AgentBundle_args();
        AgentRemoteValue cmdRes = this.agentConn.sendCommand("agent:getCurrentAgentBundle", this.verAPI.getVersion(), args);
        return new AgentBundle_result(cmdRes).getCurrentAgentBundle();
    }

    @Override
    public Map<String, Boolean> agentRemoveFile(Collection<String> files) throws AgentRemoteException, AgentConnectionException {
        AgentRemoveFileData_args args = new AgentRemoveFileData_args(files);
        AgentRemoteValue res = this.agentConn.sendCommand("agent:remove_file", this.verAPI.getVersion(), args);
        return new FileRemoval_result(res).getResult();
    }
}

