/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.FileData;
import org.hyperic.hq.agent.FileDataResult;
import org.hyperic.util.math.MathUtil;

public class FileStreamMultiplexer {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final int _bufferSize;

    public FileStreamMultiplexer() {
        this(8192);
    }

    public FileStreamMultiplexer(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("buffer size must be greater than zero: " + bufferSize);
        }
        this._bufferSize = bufferSize;
    }

    public FileDataResult[] sendData(OutputStream outStream, FileData[] destFiles, InputStream[] streams) throws IOException, AgentRemoteException {
        FileDataResult[] res = new FileDataResult[destFiles.length];
        byte[] sendBuf = new byte[this._bufferSize];
        for (int i = 0; i < destFiles.length; ++i) {
            int nBytes;
            long startTime = System.currentTimeMillis();
            for (long toSend = destFiles[i].getSize(); toSend > 0L; toSend -= (long)nBytes) {
                int nToRead = streams[i].available();
                if (nToRead == 0) {
                    throw new AgentRemoteException("No available bytes to read for '" + destFiles[i].getDestFile() + "' - needed " + toSend + " more bytes to complete");
                }
                nBytes = streams[i].read(sendBuf, 0, nToRead = MathUtil.clamp((int)nToRead, (int)1, (int)sendBuf.length));
                if (nBytes == -1) {
                    throw new AgentRemoteException("Error reading from for '" + destFiles[i].getDestFile() + "' - read returned -1");
                }
                outStream.write(sendBuf, 0, nBytes);
            }
            long sendTime = System.currentTimeMillis() - startTime;
            res[i] = new FileDataResult(destFiles[i].getDestFile(), destFiles[i].getSize(), sendTime);
        }
        return res;
    }
}

