/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.plugin.system.OperatingSystemReflection;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class VMwareGuestInfo {
    private static final String PTQL_QUERY = "State.Name.eq=" + (OperatingSystemReflection.IS_WIN32() ? "VMwareService" : "vmware-guestd");

    private static String findGuestd(Sigar sigar) {
        long[] pids;
        try {
            pids = ProcessFinder.find((Sigar)sigar, (String)PTQL_QUERY);
        }
        catch (SigarException e) {
            return null;
        }
        for (int i = 0; i < pids.length; ++i) {
            try {
                return sigar.getProcExe(pids[i]).getName();
            }
            catch (SigarException e) {
                try {
                    String[] args = sigar.getProcArgs(pids[i]);
                    if (args.length <= 0) continue;
                    return args[0];
                }
                catch (SigarException sigarException) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getGuestInfo(Sigar sigar) {
        String id;
        HashMap<String, String> info = new HashMap<String, String>();
        String guestd = VMwareGuestInfo.findGuestd(sigar);
        if (guestd == null) {
            return null;
        }
        String[] props = new String[]{"platform.name", "platform.fqdn", "platform.ip", "platform.id"};
        String[] argv = new String[]{guestd, "--cmd", null};
        for (int i = 0; i < props.length; ++i) {
            String key = props[i];
            argv[2] = "info-get guestinfo.hq." + key;
            BufferedReader in = null;
            try {
                String line;
                Process proc = Runtime.getRuntime().exec(argv);
                in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("Warning:") || line.startsWith("No value found")) continue;
                    info.put(key, line);
                }
                continue;
            }
            catch (IOException e) {
                break;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if ((id = (String)info.get("platform.id")) == null) {
            return null;
        }
        try {
            Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return info;
    }

    public static void main(String[] args) {
        Sigar sigar = new Sigar();
        System.out.println(VMwareGuestInfo.getGuestInfo(sigar));
        sigar.close();
    }
}

