/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.system.SystemServerDetector;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class ProcessorDetector
extends SystemServerDetector {
    private static final String PROP_NO_MHZ = "system.cpu.disable_mhz_naming";

    protected String getServerType() {
        return "ProcessServer";
    }

    public boolean isMhzNamingDisabled() {
        return "true".equals(this.getManagerProperty(PROP_NO_MHZ));
    }

    private ArrayList getSystemCPUValues(Sigar sigar) throws SigarException {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        CpuInfo[] cpus = sigar.getCpuInfoList();
        boolean isMhzNamingDisabled = this.isMhzNamingDisabled();
        for (int i = 0; i < cpus.length; ++i) {
            CpuInfo cpu = cpus[i];
            String mhz = "";
            int id = i + 1;
            if (!isMhzNamingDisabled && cpu.getMhz() > 0) {
                mhz = cpu.getMhz() + "Mhz ";
            }
            String info = "CPU " + id + " (" + mhz + cpu.getVendor() + " " + cpu.getModel() + ")";
            AIServiceValue svc = this.createSystemService("CPU", this.getFullServiceName(info), "cpu", String.valueOf(i));
            services.add(svc);
        }
        return services;
    }

    private ConfigResponse getProcessProperties(Sigar sigar, String ptql) {
        String cwd;
        long pid;
        ConfigResponse cprops = new ConfigResponse();
        try {
            long[] pids = ProcessFinder.find((SigarProxy)ProcessorDetector.getSigar(), (String)ptql);
            if (pids.length != 1) {
                return cprops;
            }
            pid = pids[0];
        }
        catch (SigarException e) {
            return cprops;
        }
        try {
            ProcCredName cred = sigar.getProcCredName(pid);
            cprops.setValue("user", cred.getUser());
            cprops.setValue("group", cred.getGroup());
        }
        catch (SigarException e) {
            this.getLog().debug((Object)("ProcCredName(" + pid + ") failed: " + e.getMessage()));
        }
        String exe = ProcessorDetector.getProcExe((long)pid);
        if (exe != null) {
            cprops.setValue("exe", exe);
        }
        if ((cwd = ProcessorDetector.getProcCwd((long)pid)) != null) {
            cprops.setValue("cwd", cwd);
        }
        return cprops;
    }

    private ArrayList getSystemProcessValues(Sigar sigar) throws SigarException {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        if (!ProcessorDetector.isWin32()) {
            String[] pidFiles = new String[]{"/var/run/sshd.pid", "/var/run/samba/smbd.pid", "/var/run/samba/nmbd.pid", "/var/run/slapd.pid", "/usr/local/var/run/sshd.pid", "/usr/local/var/run/samba/smbd.pid", "/usr/local/var/run/samba/nmbd.pid", "/usr/local/var/run/slapd.pid"};
            for (int i = 0; i < pidFiles.length; ++i) {
                File pidFile = new File(pidFiles[i]);
                if (!pidFile.exists() || !pidFile.canRead()) continue;
                String filename = pidFile.getName();
                String info = filename.substring(0, filename.lastIndexOf(46)) + " " + "Process";
                String ptql = "Pid.PidFile.eq=" + pidFiles[i];
                AIServiceValue svc = this.createSystemService("Process", this.getFullServiceName(info), "process.query", ptql);
                ConfigResponse cprops = this.getProcessProperties(sigar, ptql);
                try {
                    svc.setCustomProperties(cprops.encode());
                }
                catch (EncodingException e) {
                    // empty catch block
                }
                services.add(svc);
            }
        }
        return services;
    }

    private ArrayList getManualProcessValues(Sigar sigar) throws SigarException {
        String type = "Process";
        String prop = "process.query";
        List serviceConfigs = this.getServiceConfigs(type);
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        for (int i = 0; i < serviceConfigs.size(); ++i) {
            ConfigResponse serviceConfig = (ConfigResponse)serviceConfigs.get(i);
            String name = serviceConfig.getValue("resource.name");
            String ptql = serviceConfig.getValue(prop);
            AIServiceValue svc = this.createSystemService(type, name);
            ConfigResponse cprops = this.getProcessProperties(sigar, ptql);
            try {
                svc.setCustomProperties(cprops.encode());
            }
            catch (EncodingException e) {
                // empty catch block
            }
            services.add(svc);
        }
        return services;
    }

    private ArrayList getSystemUserValues(Sigar sigar) throws SigarException {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        HashMap<String, Boolean> names = new HashMap<String, Boolean>();
        String fqdn = sigar.getFQDN();
        long[] pids = sigar.getProcList();
        for (int i = 0; i < pids.length; ++i) {
            String name;
            try {
                ProcCredName cred = sigar.getProcCredName(pids[i]);
                name = cred.getUser();
                if (names.get(name) == Boolean.TRUE) {
                }
            }
            catch (SigarException e) {}
            continue;
            names.put(name, Boolean.TRUE);
            AIServiceValue svc = this.createSystemService("MultiProcess", fqdn + " User " + name, "process.query", "CredName.User.eq=" + name);
            services.add(svc);
        }
        return services;
    }

    protected ArrayList getSystemServiceValues(Sigar sigar, ConfigResponse config) throws SigarException {
        ArrayList cpus = this.getSystemCPUValues(sigar);
        ArrayList processes = this.getSystemProcessValues(sigar);
        ArrayList services = new ArrayList();
        services.addAll(cpus);
        services.addAll(processes);
        services.addAll(this.getManualProcessValues(sigar));
        String enableUserAI = config.getValue("autodiscover.users");
        if (enableUserAI == null) {
            enableUserAI = this.props.getProperty("autodiscover.users");
        }
        if ("true".equals(enableUserAI)) {
            log.debug((Object)"User AI is enabled");
            services.addAll(this.getSystemUserValues(sigar));
        } else {
            log.debug((Object)("User AI is disabled=" + enableUserAI));
        }
        return services;
    }
}

