/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.plugin.system;

import com.hyperic.hq.plugin.system.VMGuestAppMonitor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.bizapp.shared.lather.ControlSendCommandResult_args;
import org.hyperic.hq.context.Bootstrap;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.file.FileUtil;

public class SystemPlugin
extends org.hyperic.hq.plugin.system.SystemPlugin {
    private static final String VM_HA_CLIENT_BIN_RELATIVE_PATH = "/vm-ha-client-bin";
    private static final String LIBRARIES_LOADED_FLAG_KEY = "vm.hq.client.lib.loaded";
    private static VMGuestAppMonitor haClient;
    private static boolean supportsHAClientActions;
    private static final String RESTART_PLATFORM = "restart_platform";
    private static final String RESET_VM = "reset_VM";
    private static final List<String> actions;

    public GenericPlugin getPlugin(String type, TypeInfo info) {
        Object plugin = super.getPlugin(type, info);
        if (plugin == null && supportsHAClientActions && type.equals("control") && info.getType() == 1) {
            plugin = new VMLifecycleControlPlugin();
        } else if (plugin == null && type.equals("control") && info.getType() == 1) {
            plugin = new SystemControlPlugin();
        }
        return plugin;
    }

    protected final boolean hasPlatformControlActions() {
        return true;
    }

    public final void init(PluginManager manager) throws PluginException {
        try {
            if (!Bootstrap.isServer() && haClient == null) {
                PlatformType.initVMActions(((Object)((Object)this)).getClass());
                haClient = new VMGuestAppMonitor();
                supportsHAClientActions = haClient.isClientSupported();
                if (!supportsHAClientActions) {
                    PlatformType.disposeVMActions();
                    this.getLog().warn((Object)"Platform Does not support VM actions");
                } else {
                    this.getLog().warn((Object)"Platform supports VM actions");
                }
            }
            super.init(manager);
        }
        catch (Throwable t) {
            this.getLog().error((Object)t);
        }
    }

    public final void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
    }

    public static void main(String[] args) throws Throwable {
        String[] arr;
        String parent = "/work/workspaces/master-complete/Tests/RestartVM/src";
        for (String l : arr = new String[]{"libvmGuestLib.so", "libappmonitorlib.so", "libVMGuestAppMonitorNative.so"}) {
            System.load(new File("/work/workspaces/master-complete/Tests/RestartVM/src", l).getAbsolutePath());
        }
        new VMGuestAppMonitor().postState("sdf");
    }

    static {
        actions = Arrays.asList(RESTART_PLATFORM, RESET_VM);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VMLifecycleControlPlugin
    extends ControlPlugin {
        private static AtomicBoolean isActionInProgress = new AtomicBoolean();
        private static final Map<String, Method> methodsCache = new ConcurrentHashMap<String, Method>();

        public final List<String> getActions() {
            return actions;
        }

        private final boolean concurrentActionInProgress(final String actionName, File persistedControlResponsesDir) {
            if (isActionInProgress.get()) {
                return true;
            }
            File[] controlResponses = null;
            return persistedControlResponsesDir.exists() && (controlResponses = persistedControlResponsesDir.listFiles(new FileFilter(){

                public final boolean accept(File pathname) {
                    return pathname.getName().startsWith(actionName + '_');
                }
            })) == null;
        }

        public void doAction(String action, ControlSendCommandResult_args resultsMetadata) throws PluginException {
            this.doAction(action, null, resultsMetadata);
        }

        public void doAction(String action, String[] args, ControlSendCommandResult_args resultsMetadata) throws PluginException {
            Log log = this.getLog();
            File persistedControlResponsesDir = new File(AgentConfig.PERSISTED_CONTROL_RESPONSES_DIR);
            persistedControlResponsesDir.mkdir();
            File persistedControlActionFile = new File(persistedControlResponsesDir, action + '_' + resultsMetadata.getId() + ".ser");
            try {
                if (this.concurrentActionInProgress(action, persistedControlResponsesDir)) {
                    throw new PluginException("Multiple " + action + " exeutions is unsupported");
                }
                isActionInProgress.set(true);
                Method actionMethod = methodsCache.get(action);
                if (actionMethod == null) {
                    actionMethod = VMGuestAppMonitor.class.getDeclaredMethod(action, (Class<?>)(args == null || args.length == 0 ? new Class[]{} : String[].class));
                    methodsCache.put(action, actionMethod);
                }
                log.info((Object)("About to persist a successful control response for action " + action + " to file " + persistedControlActionFile));
                resultsMetadata.setResult(0);
                FileUtil.persistObject((Serializable)resultsMetadata, (File)persistedControlActionFile);
                actionMethod.invoke((Object)haClient, (Object[])args);
                this.setResult(0);
            }
            catch (Throwable t) {
                log.error((Object)("An Error Had occured during the execution of platform action " + action + ", removing persited control action response file " + persistedControlActionFile), t);
                persistedControlActionFile.delete();
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                this.setExceptionMessage(t);
                throw t instanceof PluginException ? (PluginException)t : new PluginException(t);
            }
            finally {
                isActionInProgress.set(false);
            }
        }

        protected final boolean useConfigSchema(TypeInfo info) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SystemControlPlugin
    extends ControlPlugin {
        private static AtomicBoolean isActionInProgress = new AtomicBoolean();

        public final List<String> getActions() {
            return actions;
        }

        private final boolean concurrentActionInProgress(final String actionName, File persistedControlResponsesDir) {
            if (isActionInProgress.get()) {
                return true;
            }
            File[] controlResponses = null;
            return persistedControlResponsesDir.exists() && (controlResponses = persistedControlResponsesDir.listFiles(new FileFilter(){

                public final boolean accept(File pathname) {
                    return pathname.getName().startsWith(actionName + '_');
                }
            })) == null;
        }

        public void doAction(String action, ControlSendCommandResult_args resultsMetadata) throws PluginException {
            this.doAction(action, null, resultsMetadata);
        }

        public void doAction(String action, String[] args, ControlSendCommandResult_args resultsMetadata) throws PluginException {
            Log log = this.getLog();
            File persistedControlResponsesDir = new File(AgentConfig.PERSISTED_CONTROL_RESPONSES_DIR);
            persistedControlResponsesDir.mkdir();
            File persistedControlActionFile = new File(persistedControlResponsesDir, action + '_' + resultsMetadata.getId() + ".ser");
            try {
                if (this.concurrentActionInProgress(action, persistedControlResponsesDir)) {
                    throw new PluginException("Multiple " + action + " exeutions is unsupported");
                }
                isActionInProgress.set(true);
                log.info((Object)("About to persist a successful control response for action " + action + " to file " + persistedControlActionFile));
                resultsMetadata.setResult(0);
                FileUtil.persistObject((Serializable)resultsMetadata, (File)persistedControlActionFile);
                if (action.equalsIgnoreCase(SystemPlugin.RESTART_PLATFORM) || action.equalsIgnoreCase(SystemPlugin.RESET_VM)) {
                    if (PlatformType.currentPlatform() == PlatformType.Win32 || PlatformType.currentPlatform() == PlatformType.Win64) {
                        log.info((Object)"Restarting machine");
                        String[] cmd = new String[]{"shutdown", "-r"};
                        Runtime.getRuntime().exec(cmd);
                    } else if (PlatformType.currentPlatform() == PlatformType.Unix32 || PlatformType.currentPlatform() == PlatformType.Unix64) {
                        log.info((Object)"Restarting machine");
                        Runtime.getRuntime().exec("reboot");
                    }
                }
                this.setResult(0);
            }
            catch (Throwable t) {
                log.error((Object)("An Error Had occured during the execution of platform action " + action + ", removing persited control action response file " + persistedControlActionFile), t);
                persistedControlActionFile.delete();
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                this.setExceptionMessage(t);
                throw t instanceof PluginException ? (PluginException)t : new PluginException(t);
            }
            finally {
                isActionInProgress.set(false);
            }
        }

        protected final boolean useConfigSchema(TypeInfo info) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PlatformType {
        Win32{

            public final boolean is64x() {
                return false;
            }

            public final boolean isUnix() {
                return false;
            }
        }
        ,
        Win64{

            public final boolean is64x() {
                return true;
            }

            public final boolean isUnix() {
                return false;
            }
        }
        ,
        Unix32{

            public final boolean is64x() {
                return false;
            }

            public final boolean isUnix() {
                return true;
            }
        }
        ,
        Unix64{

            public final boolean is64x() {
                return true;
            }

            public final boolean isUnix() {
                return true;
            }
        };

        private static final Map<String, PlatformType> reverseMapping;

        private static final PlatformType currentPlatform() {
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            return reverseMapping.get("" + !osName.toLowerCase().startsWith("win") + osArch.endsWith("64"));
        }

        public abstract boolean isUnix();

        public abstract boolean is64x();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final void initVMActions(Class<?> pluginClass) throws Throwable {
            if (System.getProperty(SystemPlugin.LIBRARIES_LOADED_FLAG_KEY) != null) {
                return;
            }
            URL pluginsDir = SystemPlugin.class.getClassLoader().getResource(".");
            if (pluginsDir == null) {
                pluginsDir = SystemPlugin.class.getClassLoader().getResource("");
            }
            File destParent = new File(pluginsDir.getFile(), SystemPlugin.VM_HA_CLIENT_BIN_RELATIVE_PATH);
            Log pluginLog = LogFactory.getLog(pluginClass);
            pluginLog.info((Object)("vm ha client bin directory is -->" + destParent));
            String LIB_DIR_NAME = "/vm-ha-client/lib/" + (Object)((Object)PlatformType.currentPlatform()) + "/";
            InputStream loadSequenceFileIS = SystemPlugin.class.getResourceAsStream(LIB_DIR_NAME + "load-sequence.txt");
            StringBuilder loadSequence = new StringBuilder();
            try {
                while (loadSequenceFileIS.available() > 0) {
                    loadSequence.append((char)loadSequenceFileIS.read());
                }
            }
            finally {
                loadSequenceFileIS.close();
            }
            String[] libraryNames = loadSequence.toString().trim().split(",");
            File[] existingLibraries = destParent.listFiles();
            if (!destParent.exists() || existingLibraries == null || existingLibraries.length != libraryNames.length) {
                if (existingLibraries != null) {
                    for (File existingLibrary : existingLibraries) {
                        existingLibrary.delete();
                    }
                }
                destParent.mkdirs();
                PlatformType.loadLibrariesFromJar(libraryNames, destParent, LIB_DIR_NAME);
            } else {
                PlatformType.loadLibrariesFromFS(libraryNames, destParent);
            }
            System.setProperty(SystemPlugin.LIBRARIES_LOADED_FLAG_KEY, "1");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void loadLibrariesFromJar(String[] libraryLoadSequence, File destParent, String LIB_DIR_NAME) throws Throwable {
            URL fileURL = null;
            File destFile = null;
            ReadableByteChannel rbc = null;
            Channel wbc = null;
            for (String libraryName : libraryLoadSequence) {
                fileURL = SystemPlugin.class.getResource(LIB_DIR_NAME + libraryName);
                destFile = new File(destParent, libraryName);
                try {
                    rbc = Channels.newChannel(fileURL.openStream());
                    wbc = Channels.newChannel(new FileOutputStream(destFile));
                    PlatformType.fastChannelCopy(rbc, (WritableByteChannel)wbc);
                }
                finally {
                    if (rbc != null) {
                        rbc.close();
                    }
                    if (wbc != null) {
                        wbc.close();
                    }
                }
                System.load(destFile.getAbsolutePath());
            }
        }

        private static final void loadLibrariesFromFS(String[] libraryLoadSequence, File destParent) throws Throwable {
            File destFile = null;
            for (String libraryName : libraryLoadSequence) {
                destFile = new File(destParent, libraryName);
                System.load(destFile.getAbsolutePath());
            }
        }

        public static final void disposeVMActions() throws Throwable {
        }

        private static final void fastChannelCopy(ReadableByteChannel source, WritableByteChannel dest) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (source.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }

        static {
            reverseMapping = new HashMap<String, PlatformType>(4);
            for (PlatformType enumPlatformType : PlatformType.values()) {
                reverseMapping.put("" + enumPlatformType.isUnix() + enumPlatformType.is64x(), enumPlatformType);
            }
        }
    }
}

