/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.diagnostics.AgentDiagnosticObject;
import org.hyperic.hq.agent.diagnostics.AgentDiagnostics;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorSimple;
import org.hyperic.hq.agent.stats.AgentStatsCollector;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.measurement.TimingVoodoo;
import org.hyperic.hq.measurement.agent.ScheduledMeasurement;
import org.hyperic.hq.measurement.agent.server.Sender;
import org.hyperic.hq.measurement.agent.server.ServerTimeDiff;
import org.hyperic.hq.product.MeasurementValueGetter;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.util.properties.PropertiesUtil;
import org.hyperic.util.TimeUtil;
import org.hyperic.util.collection.IntHashMap;
import org.hyperic.util.schedule.EmptyScheduleException;
import org.hyperic.util.schedule.Schedule;
import org.hyperic.util.schedule.ScheduleException;
import org.hyperic.util.schedule.ScheduledItem;
import org.hyperic.util.schedule.UnscheduledItemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleThread
extends AgentMonitorSimple
implements Runnable,
AgentDiagnosticObject {
    private static final String SCHEDULE_THREAD_METRICS_COLLECTED_TIME = "SCHEDULE_THREAD_METRICS_COLLECTED_TIME";
    private static final String SCHEDULE_THREAD_METRIC_TASKS_SUBMITTED = "SCHEDULE_THREAD_METRIC_TASKS_SUBMITTED";
    private static final String SCHEDULE_THREAD_METRIC_COLLECT_FAILED = "SCHEDULE_THREAD_METRIC_COLLECT_FAILED";
    static final String PROP_POOLSIZE = "scheduleThread.poolsize.";
    static final String PROP_FETCH_LOG_TIMEOUT = "scheduleThread.fetchLogTimeout";
    static final String PROP_CANCEL_TIMEOUT = "scheduleThread.cancelTimeout";
    static final String PROP_QUEUE_SIZE = "scheduleThread.queuesize.";
    private boolean deductServerTimeDiff = true;
    private static final int ONE_SECOND = 1000;
    private static final int POLL_PERIOD = 1000;
    private static final int UNREACHABLE_EXPIRE = 300000;
    private static final long FETCH_TIME = 2000L;
    private static final long CANCEL_TIME = 5000L;
    private static final int EXECUTOR_QUEUE_SIZE = 10000;
    private long logFetchTimeout = 2000L;
    private long cancelTimeout = 5000L;
    private static final Log log = LogFactory.getLog((String)ScheduleThread.class.getName());
    private final Map<String, ResourceSchedule> schedules = new HashMap<String, ResourceSchedule>();
    private final AtomicBoolean shouldDie = new AtomicBoolean(false);
    private final Object interrupter = new Object();
    private final HashMap<String, String> errors = new HashMap();
    private final Properties agentConfig;
    private final HashMap<String, ThreadPoolExecutor> executors = new HashMap();
    private final HashMap<Future<?>, MetricTask> metricCollections = new HashMap();
    private final ScheduledExecutorService metricVerificationService;
    private final ScheduledFuture<?> metricVerificationTask;
    private final ScheduledFuture<?> metricLoggingTask;
    private final MeasurementValueGetter manager;
    private final Sender sender;
    private final Set<Integer> scheduled = new HashSet<Integer>();
    private final Object statsLock = new Object();
    private long statNumMetricsFetched = 0L;
    private long statNumMetricsFailed = 0L;
    private long statTotFetchTime = 0L;
    private long statNumMetricsScheduled = 0L;
    private long statMaxFetchTime = Long.MIN_VALUE;
    private long statMinFetchTime = Long.MAX_VALUE;
    private final AgentStatsCollector statsCollector;
    private final Random rand = new Random();
    private final int offset;
    private final Map<AppdefEntityID, DiagInfo> diagInfo = new HashMap<AppdefEntityID, DiagInfo>();
    private static final SimpleDateFormat diagInfoTimeFormat = new SimpleDateFormat("HH:mm");

    ScheduleThread(Sender sender, MeasurementValueGetter manager, Properties config) throws AgentStartException {
        String sCancelTimeout;
        this.statsCollector = AgentStatsCollector.getInstance();
        this.statsCollector.register(SCHEDULE_THREAD_METRIC_COLLECT_FAILED);
        this.statsCollector.register(SCHEDULE_THREAD_METRIC_TASKS_SUBMITTED);
        this.statsCollector.register(SCHEDULE_THREAD_METRICS_COLLECTED_TIME);
        this.agentConfig = config;
        this.manager = manager;
        this.sender = sender;
        int tmp = this.getFudgeFactor();
        if (tmp <= 0) {
            this.offset = 1000;
        } else {
            this.offset = tmp;
            log.info((Object)("fudgeFactor is set to " + this.offset + " ms"));
        }
        String sLogFetchTimeout = this.agentConfig.getProperty(PROP_FETCH_LOG_TIMEOUT);
        if (sLogFetchTimeout != null) {
            try {
                this.logFetchTimeout = Integer.parseInt(sLogFetchTimeout);
                log.info((Object)("Log fetch timeout set to " + this.logFetchTimeout));
            }
            catch (NumberFormatException exc) {
                log.error((Object)("Invalid setting for scheduleThread.fetchLogTimeout value=" + sLogFetchTimeout + ", using defaults."));
            }
        }
        if ((sCancelTimeout = this.agentConfig.getProperty(PROP_CANCEL_TIMEOUT)) != null) {
            try {
                this.cancelTimeout = Integer.parseInt(sCancelTimeout);
                log.info((Object)("Cancel timeout set to " + this.cancelTimeout));
            }
            catch (NumberFormatException exc) {
                log.error((Object)("Invalid setting for scheduleThread.cancelTimeout value=" + sCancelTimeout + ", using defaults."));
            }
        }
        this.metricVerificationService = Executors.newSingleThreadScheduledExecutor();
        this.metricVerificationTask = this.metricVerificationService.scheduleAtFixedRate(new MetricVerificationTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.metricLoggingTask = this.metricVerificationService.scheduleAtFixedRate(new MetricLoggingTask(), 1L, 600L, TimeUnit.SECONDS);
        AgentDiagnostics.getInstance().addDiagnostic((AgentDiagnosticObject)this);
        Boolean deductServerOffset = PropertiesUtil.getBooleanValue((String)this.agentConfig.getProperty("agent.deductServerTimeDiff"), (boolean)true);
        this.deductServerTimeDiff = deductServerOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceSchedule getSchedule(ScheduledMeasurement meas) {
        ResourceSchedule schedule;
        String key = meas.getEntity().getAppdefKey();
        Map<String, ResourceSchedule> map = this.schedules;
        synchronized (map) {
            schedule = this.schedules.get(key);
            if (schedule == null) {
                schedule = new ResourceSchedule();
                schedule.id = meas.getEntity();
                this.schedules.put(key, schedule);
                log.debug((Object)("Created ResourceSchedule for: " + key));
            }
        }
        return schedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptMe() {
        Object object = this.interrupter;
        synchronized (object) {
            this.interrupter.notify();
        }
    }

    void die() {
        this.shouldDie.set(true);
        for (String s : this.executors.keySet()) {
            ThreadPoolExecutor executor = this.executors.get(s);
            List<Runnable> queuedMetrics = executor.shutdownNow();
            log.info((Object)("Shut down executor service for plugin '" + s + "'" + " with " + queuedMetrics.size() + " queued collections"));
        }
        this.metricLoggingTask.cancel(true);
        this.metricVerificationTask.cancel(true);
        List<Runnable> pending = this.metricVerificationService.shutdownNow();
        log.info((Object)("Shutdown metric verification task with " + pending.size() + " tasks"));
        this.interruptMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleMeasurements(AppdefEntityID ent) throws UnscheduledItemException {
        ResourceSchedule rs;
        String key = ent.getAppdefKey();
        Set<Integer> set = this.schedules;
        synchronized (set) {
            rs = this.schedules.remove(key);
        }
        if (rs == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No measurement schedule for: " + key));
            }
            return;
        }
        this.setDiagScheduled(rs, false);
        ScheduledItem[] items = rs.schedule.getScheduledItems();
        log.debug((Object)("Un-scheduling " + items.length + " metrics for " + ent));
        set = this.statsLock;
        synchronized (set) {
            this.statNumMetricsScheduled -= (long)items.length;
        }
        set = this.scheduled;
        synchronized (set) {
            for (ScheduledItem item : items) {
                ScheduledMeasurement meas = (ScheduledMeasurement)item.getObj();
                this.scheduled.remove(meas.getDerivedID());
                ParsedTemplate tmpl = ScheduleThread.getParsedTemplate(meas);
                if (tmpl == null || tmpl.metric == null) continue;
                tmpl.metric.setInterval(-1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleMeasurement(ScheduledMeasurement meas) {
        int mid = meas.getDerivedID();
        Set<Integer> set = this.scheduled;
        synchronized (set) {
            if (this.scheduled.contains(mid)) {
                return;
            }
            this.scheduled.add(mid);
        }
        ResourceSchedule rs = this.getSchedule(meas);
        this.setDiagScheduled(rs, true);
        try {
            Object timeOfNext;
            rs.schedule.scheduleItem((Object)meas, meas.getInterval(), true, true);
            if (log.isDebugEnabled()) {
                try {
                    timeOfNext = rs.schedule.getTimeOfNext();
                }
                catch (EmptyScheduleException e) {
                    timeOfNext = null;
                }
                log.debug((Object)("scheduleMeasurement timeOfNext=" + TimeUtil.toString((long)((Long)timeOfNext)) + ", template=" + ScheduleThread.getParsedTemplate((ScheduledMeasurement)meas).metric.toDebugString()));
            }
            timeOfNext = this.statsLock;
            synchronized (timeOfNext) {
                ++this.statNumMetricsScheduled;
            }
        }
        catch (ScheduleException e) {
            log.error((Object)("Unable to schedule metric '" + ScheduleThread.getParsedTemplate(meas) + "', skipping. Cause is " + (Object)((Object)e)), (Throwable)e);
            Set<Integer> set2 = this.scheduled;
            synchronized (set2) {
                this.scheduled.remove(mid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCache(String basicMsg, ParsedTemplate tmpl, String msg, Exception exc, boolean printStack) {
        String oldMsg;
        boolean isDebug = log.isDebugEnabled();
        HashMap<String, String> hashMap = this.errors;
        synchronized (hashMap) {
            oldMsg = this.errors.get(tmpl.metric.toString());
        }
        if (!isDebug && oldMsg != null && oldMsg.equals(msg)) {
            return;
        }
        if (isDebug) {
            log.error((Object)(basicMsg + " while processing Metric '" + tmpl + "'"), (Throwable)exc);
        } else {
            log.error((Object)(basicMsg + ": " + msg));
            if (printStack) {
                log.error((Object)"Stack trace follows:", (Throwable)exc);
            }
        }
        hashMap = this.errors;
        synchronized (hashMap) {
            this.errors.put(tmpl.metric.toString(), msg);
        }
    }

    private void logCache(String basicMsg, ParsedTemplate tmpl, Exception exc) {
        this.logCache(basicMsg, tmpl, exc.getMessage(), exc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLogCache(ParsedTemplate tmpl) {
        HashMap<String, String> hashMap = this.errors;
        synchronized (hashMap) {
            this.errors.remove(tmpl.metric.toString());
        }
    }

    static ParsedTemplate getParsedTemplate(ScheduledMeasurement meas) {
        ParsedTemplate tmpl = new ParsedTemplate();
        String template = meas.getDSN();
        int ix = template.indexOf(":");
        if (ix < 0) {
            return tmpl;
        }
        tmpl.plugin = template.substring(0, ix);
        String metric = template.substring(ix + 1, template.length());
        tmpl.metric = Metric.parse((String)metric);
        return tmpl;
    }

    private ParsedTemplate toParsedTemplate(ScheduledMeasurement meas) {
        AppdefEntityID aid = meas.getEntity();
        if (aid == null) {
            return null;
        }
        int id = aid.getID();
        int type = aid.getType();
        ParsedTemplate tmpl = ScheduleThread.getParsedTemplate(meas);
        if (tmpl == null || tmpl.metric == null) {
            return null;
        }
        tmpl.metric.setId(type, id);
        tmpl.metric.setCategory(meas.getCategory());
        tmpl.metric.setInterval(meas.getInterval());
        return tmpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiagInfo(MetricValue data, ParsedTemplate dsn, ResourceSchedule rs, int mid) {
        AppdefEntityID aeid = rs.id;
        Map<AppdefEntityID, DiagInfo> map = this.diagInfo;
        synchronized (map) {
            DiagInfo tmp = this.diagInfo.get(aeid);
            if (tmp == null) {
                tmp = new DiagInfo(rs.id);
                this.diagInfo.put(aeid, tmp);
            }
            tmp.add(new MetricValuePlusId(mid, data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiagScheduled(ResourceSchedule rs, boolean incrementSchedules) {
        Map<AppdefEntityID, DiagInfo> map = this.diagInfo;
        synchronized (map) {
            DiagInfo tmp = this.diagInfo.get(rs.id);
            if (tmp == null) {
                tmp = new DiagInfo(rs.id);
                this.diagInfo.put(rs.id, tmp);
            }
            if (incrementSchedules) {
                tmp.incrementSchedules();
            } else {
                tmp.incrementUnSchedules();
            }
        }
    }

    private int getQueueSize(String plugin) {
        String prop = PROP_QUEUE_SIZE + plugin;
        String sQueueSize = this.agentConfig.getProperty(prop);
        if (sQueueSize != null) {
            try {
                return Integer.parseInt(sQueueSize);
            }
            catch (NumberFormatException exc) {
                log.error((Object)("Invalid setting for " + prop + " value=" + sQueueSize + " using defaults."));
            }
        }
        return 10000;
    }

    private int getPoolSize(String plugin) {
        String prop = PROP_POOLSIZE + plugin;
        String sPoolSize = this.agentConfig.getProperty(prop);
        if (sPoolSize != null) {
            try {
                return Integer.parseInt(sPoolSize);
            }
            catch (NumberFormatException exc) {
                log.error((Object)("Invalid setting for " + prop + " value=" + sPoolSize + " using defaults."));
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(ResourceSchedule rs, List<ScheduledMeasurement> items) {
        boolean debug = log.isDebugEnabled();
        for (int i = 0; i < items.size() && !this.shouldDie.get(); ++i) {
            ThreadPoolExecutor executor;
            String plugin;
            ScheduledMeasurement meas = items.get(i);
            ParsedTemplate tmpl = this.toParsedTemplate(meas);
            if (tmpl == null) {
                log.warn((Object)("template for meas id=" + meas.getDerivedID() + " is null"));
                continue;
            }
            HashMap<String, ThreadPoolExecutor> hashMap = this.executors;
            synchronized (hashMap) {
                try {
                    ProductPlugin p = this.manager.getPlugin(tmpl.plugin).getProductPlugin();
                    plugin = p.getName();
                }
                catch (PluginNotFoundException e) {
                    if (debug) {
                        log.debug((Object)("Could not find plugin name from template '" + tmpl.plugin + "'. Associated plugin might not be initialized yet."));
                    }
                    continue;
                }
                executor = this.executors.get(plugin);
                if (executor == null) {
                    int poolSize = this.getPoolSize(plugin);
                    int queueSize = this.getQueueSize(plugin);
                    log.info((Object)("Creating executor for plugin '" + plugin + "' with a poolsize=" + poolSize + " queuesize=" + queueSize));
                    ThreadFactory factory = this.getFactory(plugin);
                    executor = new ThreadPoolExecutor(poolSize, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), factory, new ThreadPoolExecutor.AbortPolicy());
                    this.executors.put(plugin, executor);
                }
            }
            MetricTask metricTask = new MetricTask(rs, meas);
            this.statsCollector.addStat(1L, SCHEDULE_THREAD_METRIC_TASKS_SUBMITTED);
            try {
                Future<?> task = executor.submit(metricTask);
                HashMap<Future<?>, MetricTask> hashMap2 = this.metricCollections;
                synchronized (hashMap2) {
                    this.metricCollections.put(task, metricTask);
                    continue;
                }
            }
            catch (RejectedExecutionException e) {
                log.warn((Object)("Executor[" + plugin + "] rejected metric task " + metricTask));
                ++this.statNumMetricsFailed;
            }
        }
    }

    private ThreadFactory getFactory(final String plugin) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            private final AtomicLong num = new AtomicLong();

            public Thread newThread(Runnable r) {
                Thread rtn = new Thread(group, r);
                rtn.setDaemon(true);
                rtn.setName(plugin + "-" + this.num.getAndIncrement());
                return rtn;
            }
        };
    }

    private long collect(ResourceSchedule rs) {
        List items;
        long timeOfNext;
        long now = System.currentTimeMillis();
        Schedule schedule = rs.schedule;
        try {
            timeOfNext = schedule.getTimeOfNext();
        }
        catch (EmptyScheduleException e) {
            return 1000L + now;
        }
        if (rs.lastUnreachble != 0L && now - rs.lastUnreachble > 300000L) {
            rs.lastUnreachble = 0L;
            log.info((Object)("Re-enabling metrics for: " + rs.id));
        }
        rs.collected.clear();
        if (rs.retry.size() != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrying " + rs.retry.size() + " items (MetricValue.FUTUREs)"));
            }
            this.collect(rs, rs.retry);
            rs.retry.clear();
        }
        if (now < timeOfNext) {
            return timeOfNext;
        }
        try {
            items = schedule.consumeNextItems();
            timeOfNext = schedule.getTimeOfNext();
        }
        catch (EmptyScheduleException e) {
            return 1000L + now;
        }
        this.collect(rs, items);
        return timeOfNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collect() {
        long timeOfNext = 0L;
        HashMap<String, ResourceSchedule> schedules = null;
        Map<String, ResourceSchedule> map = this.schedules;
        synchronized (map) {
            if (this.schedules.size() == 0) {
                timeOfNext = 1000L + System.currentTimeMillis();
            } else {
                schedules = new HashMap<String, ResourceSchedule>(this.schedules);
            }
        }
        if (schedules != null) {
            Iterator it = schedules.values().iterator();
            while (it.hasNext() && !this.shouldDie.get()) {
                ResourceSchedule rs = (ResourceSchedule)it.next();
                try {
                    long next = this.collect(rs);
                    if (timeOfNext == 0L) {
                        timeOfNext = next;
                        continue;
                    }
                    timeOfNext = Math.min(next, timeOfNext);
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                }
            }
        }
        return timeOfNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebug = log.isDebugEnabled();
        int fudgeFactor = this.getFudgeFactor();
        while (!this.shouldDie.get()) {
            long now;
            long timeOfNext = this.collect();
            if (fudgeFactor > 0) {
                timeOfNext += (long)this.rand.nextInt(fudgeFactor);
            }
            if (timeOfNext <= (now = System.currentTimeMillis())) continue;
            long wait = timeOfNext - now;
            if (isDebug) {
                log.debug((Object)("Waiting " + wait + " ms until " + TimeUtil.toString((long)(now + wait))));
            }
            try {
                Object object = this.interrupter;
                synchronized (object) {
                    this.interrupter.wait(wait);
                }
            }
            catch (InterruptedException e) {
                log.debug((Object)"Schedule thread kicked");
            }
        }
        log.info((Object)"Schedule thread shut down");
    }

    private int getFudgeFactor() {
        String val = this.agentConfig.getProperty("agent.dsl.fudge", "0");
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            log.debug((Object)("val=" + val + " is not a valid number.  Fudge factor will be 0 seconds"));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNumMetricsScheduled() throws AgentMonitorException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.statNumMetricsScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNumMetricsFetched() throws AgentMonitorException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.statNumMetricsFetched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNumMetricsFailed() throws AgentMonitorException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.statNumMetricsFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotFetchTime() throws AgentMonitorException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.statTotFetchTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxFetchTime() throws AgentMonitorException {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.statMaxFetchTime == Long.MIN_VALUE) {
                return Double.NaN;
            }
            return this.statMaxFetchTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinFetchTime() throws AgentMonitorException {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.statMinFetchTime == Long.MAX_VALUE) {
                return Double.NaN;
            }
            return this.statMinFetchTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDiagStatus() {
        StringBuilder rtn = new StringBuilder();
        Map<AppdefEntityID, DiagInfo> map = this.diagInfo;
        synchronized (map) {
            for (Map.Entry<AppdefEntityID, DiagInfo> entry : this.diagInfo.entrySet()) {
                AppdefEntityID aeid = entry.getKey();
                DiagInfo d = entry.getValue();
                rtn.append(aeid).append(":").append(d).append("\n");
                d.clear();
            }
        }
        return rtn.toString();
    }

    public String getDiagName() {
        return "Schedule Thread Diagnostics";
    }

    private class MetricValuePlusId {
        private final int mid;
        private final MetricValue value;

        private MetricValuePlusId(int mid, MetricValue value) {
            this.mid = mid;
            this.value = value;
        }

        public double getValue() {
            return this.value.getValue();
        }

        public long getTimestamp() {
            return this.value.getTimestamp();
        }
    }

    private class DiagInfo {
        private final AppdefEntityID aeid;
        private final List<MetricValuePlusId> collected = new ArrayList<MetricValuePlusId>();
        private int numSchedules = 0;
        private int numUnSchedules = 0;

        private DiagInfo(AppdefEntityID aeid) {
            this.aeid = aeid;
        }

        private void add(MetricValuePlusId data) {
            this.collected.add(data);
        }

        private void clear() {
            this.collected.clear();
            this.numUnSchedules = 0;
            this.numSchedules = 0;
        }

        private void incrementUnSchedules() {
            ++this.numUnSchedules;
        }

        private void incrementSchedules() {
            ++this.numSchedules;
        }

        public String toString() {
            StringBuilder rtn = new StringBuilder();
            rtn.append("(").append(this.numSchedules).append("-").append(this.numUnSchedules).append(")");
            for (MetricValuePlusId m : this.collected) {
                rtn.append("(").append(m.mid).append("-").append(diagInfoTimeFormat.format(new Date(m.getTimestamp()))).append("=").append(m.getValue()).append(")");
            }
            return rtn.toString();
        }
    }

    private class MetricTask
    implements Runnable {
        ResourceSchedule rs;
        ScheduledMeasurement meas;
        long executeStartTime = 0L;
        long executeEndTime = 0L;

        MetricTask(ResourceSchedule rs, ScheduledMeasurement meas) {
            this.rs = rs;
            this.meas = meas;
        }

        public String toString() {
            return ScheduleThread.getParsedTemplate((ScheduledMeasurement)this.meas).metric.toDebugString();
        }

        public long getExecutionDuration() {
            if (this.executeStartTime == 0L) {
                return this.executeStartTime;
            }
            if (this.executeEndTime == 0L) {
                return System.currentTimeMillis() - this.executeStartTime;
            }
            return this.executeEndTime - this.executeStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            boolean isDebug = log.isDebugEnabled();
            AppdefEntityID aid = this.meas.getEntity();
            String category = this.meas.getCategory();
            ParsedTemplate dsn = ScheduleThread.this.toParsedTemplate(this.meas);
            MetricValue data = null;
            this.executeStartTime = System.currentTimeMillis();
            boolean success = false;
            if (this.rs.lastUnreachble != 0L && !category.equals("AVAILABILITY")) {
                ScheduleThread.this.statsCollector.addStat(1L, ScheduleThread.SCHEDULE_THREAD_METRIC_COLLECT_FAILED);
                ScheduleThread.this.statNumMetricsFailed++;
                return;
            }
            try {
                int mid = this.meas.getDsnID();
                if (this.rs.collected.get(mid) == Boolean.TRUE) {
                    if (isDebug) {
                        log.debug((Object)("Skipping duplicate mid=" + mid + ", aid=" + this.rs.id));
                    }
                    return;
                }
                long lastCollected = this.meas.getLastCollected();
                long now = this.now();
                long nowRounded = TimingVoodoo.roundDownTime((long)now, (long)60000L);
                if (lastCollected + this.meas.getInterval() > nowRounded) {
                    if (isDebug) {
                        log.debug((Object)("ALREADY COLLECTED meas=" + this.meas + " @ " + TimeUtil.toString((long)lastCollected)));
                    }
                    return;
                }
                if (isDebug) {
                    log.debug((Object)("collecting data for meas=" + this.meas));
                }
                data = ScheduleThread.this.manager.getValue(dsn.plugin, dsn.metric);
                if (ScheduleThread.this.deductServerTimeDiff && Math.abs(ServerTimeDiff.getInstance().getServerTimeDiff()) > 30000L) {
                    data.setTimestamp(data.getTimestamp() + ServerTimeDiff.getInstance().getServerTimeDiff());
                }
                long time = TimingVoodoo.roundDownTime((long)now, (long)this.meas.getInterval());
                this.meas.setLastCollected(time);
                if (data == null) {
                    log.warn((Object)("Plugin returned null value for metric: " + dsn));
                    data = MetricValue.NONE;
                }
                this.rs.collected.put(mid, (Object)Boolean.TRUE);
                ScheduleThread.this.setDiagInfo(data, dsn, this.rs, mid);
                success = true;
                ScheduleThread.this.clearLogCache(dsn);
            }
            catch (PluginNotFoundException exc) {
                ScheduleThread.this.logCache("Plugin not found", dsn, (Exception)((Object)exc));
            }
            catch (PluginException exc) {
                ScheduleThread.this.logCache("Measurement plugin error", dsn, (Exception)((Object)exc));
            }
            catch (MetricInvalidException exc) {
                ScheduleThread.this.logCache("Invalid Metric requested", dsn, (Exception)((Object)exc));
            }
            catch (MetricNotFoundException exc) {
                ScheduleThread.this.logCache("Metric Value not found", dsn, (Exception)((Object)exc));
            }
            catch (MetricUnreachableException exc) {
                ScheduleThread.this.logCache("Metric unreachable", dsn, (Exception)((Object)exc));
                this.rs.lastUnreachble = this.executeStartTime;
                log.warn((Object)("Disabling metrics for: " + this.rs.id));
            }
            catch (Exception exc) {
                ScheduleThread.this.logCache("Error getting measurement value", dsn, exc.toString(), exc, true);
            }
            Long timeDiff = System.currentTimeMillis() - this.executeStartTime;
            ScheduleThread.this.statsCollector.addStat(timeDiff.longValue(), ScheduleThread.SCHEDULE_THREAD_METRICS_COLLECTED_TIME);
            Object lastCollected = ScheduleThread.this.statsLock;
            synchronized (lastCollected) {
                ScheduleThread.this.statTotFetchTime += timeDiff;
                if (timeDiff > ScheduleThread.this.statMaxFetchTime) {
                    ScheduleThread.this.statMaxFetchTime = timeDiff;
                }
                if (timeDiff < ScheduleThread.this.statMinFetchTime) {
                    ScheduleThread.this.statMinFetchTime = timeDiff;
                }
            }
            if (timeDiff > ScheduleThread.this.logFetchTimeout) {
                log.warn((Object)("Collection of metric: '" + dsn + "' took: " + timeDiff + "ms"));
            }
            if (success) {
                if (isDebug) {
                    String debugDsn = ScheduleThread.getParsedTemplate((ScheduledMeasurement)this.meas).metric.toDebugString();
                    String msg = "[" + aid + ":" + category + "] Metric='" + debugDsn + "' -> " + data;
                    log.debug((Object)(msg + " timestamp=" + data.getTimestamp()));
                }
                if (data.isNone()) {
                    return;
                }
                if (data.isFuture()) {
                    this.rs.retry.add(this.meas);
                    return;
                }
                ScheduleThread.this.sender.processData(this.meas.getDsnID(), data, this.meas.getDerivedID(), "AVAILABILITY".equals(category));
                object = ScheduleThread.this.statsLock;
                synchronized (object) {
                    ScheduleThread.this.statNumMetricsFetched++;
                }
            }
            object = ScheduleThread.this.statsLock;
            synchronized (object) {
                ScheduleThread.this.statNumMetricsFailed++;
            }
        }

        private long now() {
            return System.currentTimeMillis();
        }
    }

    static class ParsedTemplate {
        String plugin;
        Metric metric;

        ParsedTemplate() {
        }

        public String toString() {
            return this.plugin + ":" + this.metric.toDebugString();
        }
    }

    private static class ResourceSchedule {
        private final Schedule schedule = new Schedule();
        private AppdefEntityID id;
        private long lastUnreachble = 0L;
        private final List<ScheduledMeasurement> retry = new ArrayList<ScheduledMeasurement>();
        private final IntHashMap collected = new IntHashMap();

        private ResourceSchedule() {
        }
    }

    private class MetricVerificationTask
    implements Runnable {
        private MetricVerificationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean isDebugEnabled = log.isDebugEnabled();
            HashMap hashMap = ScheduleThread.this.metricCollections;
            synchronized (hashMap) {
                if (isDebugEnabled && ScheduleThread.this.metricCollections.size() > 0) {
                    log.debug((Object)(ScheduleThread.this.metricCollections.size() + " metrics to validate."));
                }
                Iterator i = ScheduleThread.this.metricCollections.keySet().iterator();
                while (i.hasNext()) {
                    Future t = (Future)i.next();
                    MetricTask mt = (MetricTask)ScheduleThread.this.metricCollections.get(t);
                    if (t.isDone()) {
                        if (isDebugEnabled) {
                            log.debug((Object)("Metric task '" + mt + "' complete, duration: " + mt.getExecutionDuration()));
                        }
                        i.remove();
                        continue;
                    }
                    if (mt.getExecutionDuration() <= ScheduleThread.this.cancelTimeout) continue;
                    boolean res = t.cancel(true);
                    log.error((Object)("Metric '" + mt + "' took too long to run (" + mt.getExecutionDuration() + "ms), cancelled (result=" + res + ")"));
                    ParsedTemplate pt = ScheduleThread.getParsedTemplate(mt.meas);
                    if (!pt.metric.isAvail()) continue;
                    MetricValue data = new MetricValue(0.0);
                    ScheduleThread.this.sender.processData(mt.meas.getDsnID(), data, mt.meas.getDerivedID(), true);
                }
            }
        }
    }

    private class MetricLoggingTask
    implements Runnable {
        private MetricLoggingTask() {
        }

        public void run() {
            for (String plugin : ScheduleThread.this.executors.keySet()) {
                ThreadPoolExecutor executor = (ThreadPoolExecutor)ScheduleThread.this.executors.get(plugin);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin=" + plugin + ", " + "CompletedTaskCount=" + executor.getCompletedTaskCount() + ", " + "ActiveCount=" + executor.getActiveCount() + ", " + "TaskCount=" + executor.getTaskCount() + ", " + "PoolSize=" + executor.getPoolSize()));
            }
        }
    }
}

