/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ContainerTag;
import org.hyperic.hq.product.pluginxml.MetricTag;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;

class MetricsTag
extends ContainerTag
implements XmlEndAttrHandler {
    private static final String[] OPTIONAL_ATTRS = new String[]{"name", "include"};
    private static final Log log = LogFactory.getLog(MetricsTag.class);
    String metricsName;
    private PluginData data;

    public String getName() {
        return "metrics";
    }

    MetricsTag(BaseTag parent) {
        super(parent);
        this.data = parent.data;
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    public XmlTagInfo[] getSubTags() {
        return this.getMergedSubTags(super.getSubTags(), new XmlTagInfo((XmlTagHandler)new MetricTag(this), 3));
    }

    public void endAttributes() throws XmlAttrException {
        if (!this.collectMetrics) {
            return;
        }
        String name = this.getAttribute("name");
        if (this.isResourceParent()) {
            if (name != null) {
                String msg = "metric 'name' attribute not allowed when nested in a " + this.parent.getName() + " tag";
                throw new XmlAttrException(msg);
            }
            this.metricsName = ((ResourceTag)this.parent).typeName;
        } else {
            if (name == null) {
                throw new XmlAttrException("missing metrics 'name' attribute");
            }
            this.metricsName = name;
        }
        MetricsTag.includeMetrics(this.data, this.metricsName, this.getAttribute("include"));
    }

    public void endTag() {
        if (!this.collectMetrics) {
            return;
        }
        for (int i = 0; i < this.includes.size(); ++i) {
            String include = (String)this.includes.get(i);
            MetricsTag.includeMetrics(this.data, this.metricsName, include);
        }
    }

    static void includeMetrics(PluginData data, String name, String includes) {
        if (includes != null) {
            List metrics = data.getMetrics(name, true);
            StringTokenizer tok = new StringTokenizer(includes, ",");
            while (tok.hasMoreTokens()) {
                MetricsTag.includeMetrics(data, name, metrics, tok.nextToken());
            }
        }
    }

    private static void includeMetrics(PluginData data, String name, List metrics, String include) {
        List includes = data.getMetrics(include, false);
        if (includes == null) {
            log.warn((Object)(name + " include not found: " + include));
        } else {
            log.trace((Object)(includes.size() + " metrics added for " + name + " (included from " + include + ")"));
            for (int i = 0; i < includes.size(); ++i) {
                MeasurementInfo metric = (MeasurementInfo)includes.get(i);
                metric = (MeasurementInfo)metric.clone();
                metric.setTemplate(data.applyFilters(metric.getTemplate()));
                metrics.add(metric);
            }
        }
    }
}

