/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceTypeValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.PluginUpdater;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.ServiceType;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.AutoApproveConfig;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.file.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class ServerDetector
extends GenericPlugin
implements RuntimeDiscoverer {
    private static final String SERVER_SIGS = "etc/hq-server-sigs.properties";
    static final String VERSION_FILE = "VERSION_FILE";
    static final String INSTALLPATH_MATCH = "INSTALLPATH_MATCH";
    static final String INSTALLPATH_NOMATCH = "INSTALLPATH_NOMATCH";
    protected static final String INSTALLPATH = "INSTALLPATH";
    protected static final String INVENTORY_ID = "INVENTORY_ID";
    protected static final String AUTOINVENTORY_NAME = "AUTOINVENTORY_NAME";
    private static final String[] NO_ARGS = new String[0];
    private static final long[] NO_PIDS = new long[0];
    private static final List NO_MODULES = Arrays.asList(NO_ARGS);
    private static final Set EMPTY_SET = new HashSet(0, 1.0f);
    private static Sigar sigarImpl = null;
    private static SigarProxy sigar = null;
    private ServerSignature sig = null;
    private ProductPluginManager ppm;
    private AutoinventoryPluginManager manager;
    private ConfigResponse cprops = null;
    private String description = null;
    private Properties properties;
    private PluginUpdater pluginUpdater = new PluginUpdater();
    private AutoApproveConfig autoApproveConfig;

    public void setAutoApproveConfig(AutoApproveConfig autoApproveConfig) {
        this.autoApproveConfig = autoApproveConfig;
    }

    public RuntimeDiscoverer getRuntimeDiscoverer() {
        return this;
    }

    public boolean isRuntimeDiscoverySupported() {
        return true;
    }

    private AIPlatformValue getPlatform(HashMap platforms, String fqdn) {
        AIPlatformValue platform = (AIPlatformValue)platforms.get(fqdn);
        if (platform != null) {
            return platform;
        }
        platform = new AIPlatformValue();
        platform.setFqdn(fqdn);
        platforms.put(fqdn, platform);
        return platform;
    }

    private RuntimeResourceReport discoverServerResources(int serverId, AIPlatformValue sPlatform, ConfigResponse config, List servers) throws PluginException {
        if (servers.size() == 0) {
            return null;
        }
        HashMap<String, AIPlatformValue> platforms = new HashMap<String, AIPlatformValue>();
        RuntimeResourceReport rrr = new RuntimeResourceReport(serverId);
        for (int i = 0; i < servers.size(); ++i) {
            AIPlatformValue platform;
            ServerResource server = (ServerResource)servers.get(i);
            AIServerExtValue resource = (AIServerExtValue)server.getResource();
            String fqdn = server.getPlatformFqdn();
            if (fqdn != null) {
                platform = this.getPlatform(platforms, fqdn);
            } else {
                platform = sPlatform;
                platforms.put("__DEFAULT__", platform);
            }
            resource.setServicesAutomanaged(true);
            AIServiceValue[] services = new AIServiceValue[server.services.size()];
            server.services.toArray(services);
            resource.setAIServiceValues(services);
            resource.setAiServiceTypes(server.serviceTypes.toArray(new AIServiceTypeValue[server.serviceTypes.size()]));
            platform.addAIServerValue(resource);
        }
        for (AIPlatformValue platform : platforms.values()) {
            rrr.addAIPlatform(platform);
        }
        return rrr;
    }

    public RuntimeResourceReport discoverResources(int serverId, AIPlatformValue platform, ConfigResponse config) throws PluginException {
        this.cprops = null;
        List servers = this.discoverServers(config);
        if (servers != null) {
            this.getLog().debug((Object)("discovered " + servers.size() + " servers"));
            return this.discoverServerResources(serverId, platform, config, servers);
        }
        Set serviceTypes = this.discoverServiceTypes(config);
        ArrayList<AIServiceTypeValue> serviceTypeValues = new ArrayList<AIServiceTypeValue>(serviceTypes.size());
        for (ServiceType serviceType : serviceTypes) {
            serviceType.getAIServiceTypeValue().setServerId(serverId);
            serviceTypeValues.add(serviceType.getAIServiceTypeValue());
        }
        this.pluginUpdater.updateServiceTypes(this.getProductPlugin(), serviceTypes);
        List services = this.discoverServices(config);
        if (services == null) {
            this.getLog().debug((Object)"no services discovered");
            return null;
        }
        this.getLog().debug((Object)("discovered " + services.size() + " services"));
        Long timeNow = new Long(System.currentTimeMillis());
        RuntimeResourceReport rrr = new RuntimeResourceReport(serverId);
        AIServiceValue[] values = new AIServiceValue[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ServiceResource service = (ServiceResource)services.get(i);
            service.resource.setCTime(timeNow);
            service.resource.setServerId(serverId);
            values[i] = service.resource;
        }
        AIServerExtValue server = new AIServerExtValue();
        if (this.cprops != null) {
            try {
                server.setCustomProperties(this.cprops.encode());
            }
            catch (EncodingException e) {
                this.getLog().error((Object)("Error encoding cprops: " + e.getMessage()));
            }
        }
        if (this.description != null) {
            server.setDescription(this.description);
        }
        server.setPlaceholder(true);
        server.setId(new Integer(serverId));
        server.setAIServiceValues(values);
        server.setAiServiceTypes(serviceTypeValues.toArray(new AIServiceTypeValue[serviceTypeValues.size()]));
        platform.addAIServerValue(server);
        rrr.addAIPlatform(platform);
        return rrr;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setCustomProperties(ConfigResponse cprops) {
        this.cprops = cprops;
    }

    protected List discoverServers(ConfigResponse config) throws PluginException {
        return null;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        return null;
    }

    protected Set discoverServiceTypes(ConfigResponse config) throws PluginException {
        return EMPTY_SET;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.manager = (AutoinventoryPluginManager)manager;
        this.ppm = (ProductPluginManager)manager.getParent();
        this.properties = manager.getProperties();
    }

    public AutoinventoryPluginManager getManager() {
        return this.manager;
    }

    public String getTypeProperty(String type, String name) {
        String value = this.ppm.getProperty(type + "." + name);
        if (value != null) {
            return value;
        }
        return super.getTypeProperty(type, name);
    }

    public List getRegistryScanKeys() {
        List keys;
        if (this.data != null && (keys = this.data.getRegistryScanKeys(this.getTypeInfo().getName())) != null) {
            return keys;
        }
        return new ArrayList();
    }

    public ServerSignature getServerSignature() {
        if (this.sig != null) {
            return this.sig;
        }
        Properties props = this.loadProperties();
        if (props == null) {
            String name = this.getTypeInfo().getName();
            if (this.data != null) {
                List matches = this.data.getFileScanIncludes(name);
                List regkeys = this.data.getRegistryScanIncludes(name);
                this.sig = new ServerSignature(name, matches, null, regkeys);
            } else {
                this.sig = this instanceof AutoServerDetector ? new ServerSignature(name, new String[0], new String[0], new String[0]) : new ServerSignature();
            }
            return this.sig;
        }
        ArrayList<String> matches = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> regkeys = new ArrayList<String>();
        Enumeration<?> propNames = props.propertyNames();
        String type = this.getTypeInfo().getName();
        String typeName = TypeInfo.formatName(type);
        String matchPrefix = typeName + ".filescan.include.";
        String excludePrefix = typeName + ".filescan.exclude.";
        String regMatchPrefix = typeName + ".regscan.include.";
        while (propNames.hasMoreElements()) {
            String prop = (String)propNames.nextElement();
            if (prop.startsWith(matchPrefix)) {
                matches.add(props.getProperty(prop));
                continue;
            }
            if (prop.startsWith(excludePrefix)) {
                excludes.add(props.getProperty(prop));
                continue;
            }
            if (!prop.startsWith(regMatchPrefix)) continue;
            regkeys.add(props.getProperty(prop));
        }
        this.sig = new ServerSignature(type, matches, excludes, regkeys);
        this.getLog().debug((Object)("Loaded ServerSignature for: " + this.getName()));
        return this.sig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        Properties properties;
        InputStream is = null;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            is = cl.getResourceAsStream(SERVER_SIGS);
            if (is == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties props = new Properties();
            props.load(is);
            String msg = "Loaded etc/hq-server-sigs.properties for: " + this.getName();
            this.getLog().debug((Object)msg);
            properties = props;
        }
        catch (IOException e) {
            String msg = "Unable to load etc/hq-server-sigs.properties for: " + this.getName() + ": " + e.getMessage();
            this.getLog().error((Object)msg, (Throwable)e);
            Properties properties3 = null;
            return properties3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    protected File findVersionFile(File dir, Pattern pattern) {
        if (dir.isDirectory() && dir.canRead()) {
            File[] files = dir.listFiles();
            HashSet<File> subDirs = new HashSet<File>();
            for (File file : files) {
                if (file.isDirectory()) {
                    subDirs.add(file);
                    continue;
                }
                if (!pattern.matcher(file.getAbsolutePath()).find()) continue;
                return file;
            }
            for (File subDir : subDirs) {
                File versionFile = this.findVersionFile(subDir, pattern);
                if (versionFile == null) continue;
                return versionFile;
            }
        } else {
            this.getLog().debug((Object)("[findVersionFile] Unable to acces to '" + dir + "'"));
        }
        return null;
    }

    protected boolean isInstallTypeVersion(String installpath) {
        String versionFile = this.getTypeProperty(VERSION_FILE);
        String installPathMatch = this.getTypeProperty(INSTALLPATH_MATCH);
        String installPathNoMatch = this.getTypeProperty(INSTALLPATH_NOMATCH);
        if (versionFile != null) {
            if (versionFile.startsWith("**/")) {
                Pattern pattern = Pattern.compile(versionFile = versionFile.substring(3));
                File f = this.findVersionFile(new File(installpath), pattern);
                if (f == null) {
                    return false;
                }
                this.getLog().debug((Object)("VERSION_FILE=" + versionFile + " matches -> " + f));
                Matcher m = pattern.matcher(f.getAbsolutePath());
                m.find();
                if (m.groupCount() != 0 && !this.getTypeInfo().getVersion().equals(m.group(1))) {
                    this.getLog().debug((Object)(installpath + " not a match for version " + this.getTypeInfo().getVersion() + ", skipping"));
                    return false;
                }
            } else {
                File file;
                File instPath = new File(installpath);
                if (instPath.isFile() && !instPath.isDirectory()) {
                    instPath = instPath.getParentFile();
                }
                File file2 = file = instPath != null ? new File(instPath, versionFile) : new File(versionFile);
                if (!file.exists()) {
                    String[] expanded = PluginLoader.expand((File)file);
                    if (expanded == null || expanded.length == 0) {
                        this.getLog().debug((Object)(file + " does not exist, skipping"));
                        return false;
                    }
                    this.getLog().debug((Object)("VERSION_FILE=" + versionFile + " matches -> " + expanded[0]));
                }
            }
        }
        if (installPathMatch != null && installpath.indexOf(installPathMatch) == -1) {
            this.getLog().debug((Object)(installpath + " not a match for " + installPathMatch + ", skipping"));
            return false;
        }
        if (installPathNoMatch != null && installpath.indexOf(installPathNoMatch) != -1) {
            this.getLog().debug((Object)(installpath + " is a match for " + installPathNoMatch + ", skipping"));
            return false;
        }
        return true;
    }

    protected ServerResource createServerResource(String installpath) {
        String aiid;
        ServerResource server = new ServerResource();
        String type = this.getTypeInfo().getName();
        server.setType(type);
        server.setName(ServerDetector.getPlatformName() + " " + type);
        if (new File(installpath).isAbsolute()) {
            installpath = ServerDetector.getCanonicalPath(installpath);
        }
        server.setInstallPath(installpath);
        installpath = this.getTypeProperty(INSTALLPATH);
        if (installpath != null) {
            server.setInstallPath(installpath);
        }
        if ((aiid = this.getTypeProperty(INVENTORY_ID)) == null) {
            aiid = server.getInstallPath();
        }
        server.setIdentifier(aiid);
        return server;
    }

    protected ServiceResource createServiceResource(String type) {
        ServiceResource service = new ServiceResource();
        service.setType(this, type);
        return service;
    }

    protected String formatName(String name, ConfigResponse parentConfig, ConfigResponse config, ConfigResponse cprops) {
        if (parentConfig != null) {
            name = Metric.translate(name, parentConfig);
        }
        if (config != null) {
            name = Metric.translate(name, config);
        }
        if (cprops != null) {
            name = Metric.translate(name, cprops);
        }
        return name;
    }

    protected String formatAutoInventoryName(String type, ConfigResponse parentConfig, ConfigResponse config, ConfigResponse cprops) {
        String name = this.getTypeProperty(type, AUTOINVENTORY_NAME);
        if (name == null) {
            if (cprops != null) {
                name = cprops.getValue(AUTOINVENTORY_NAME);
            }
            if (name == null) {
                return null;
            }
        }
        return this.formatName(name, parentConfig, config, cprops);
    }

    protected static String getParentDir(String path) {
        return FileUtil.getParentDir((String)path);
    }

    protected static String getParentDir(String path, int levels) {
        return FileUtil.getParentDir((String)path, (int)levels);
    }

    protected static String getCanonicalPath(String installpath) {
        if (installpath.charAt(0) == '\"') {
            int idx = installpath.indexOf("\"", 1);
            installpath = idx == -1 ? installpath.substring(1) : installpath.substring(1, idx);
        }
        try {
            installpath = new File(installpath).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return installpath;
    }

    protected static SigarProxy getSigar() {
        if (sigar == null) {
            int timeout = 600000;
            sigarImpl = new Sigar();
            sigar = SigarProxyCache.newInstance((Sigar)sigarImpl, (int)timeout);
        }
        return sigar;
    }

    protected String getListenAddress(String port) {
        return this.getListenAddress(Long.parseLong(port));
    }

    protected String getListenAddress(long port) {
        String type;
        String address = null;
        if (this.isNetStatEnabled()) {
            try {
                address = ServerDetector.getSigar().getNetListenAddress(port);
            }
            catch (SigarException e) {}
        } else {
            this.getLog().debug((Object)("ListenAddress detection for port " + port + " is disabled"));
        }
        if (address == null || NetFlags.isLoopback((String)address) || NetFlags.isAnyAddress((String)address)) {
            address = "localhost";
            type = "default";
        } else {
            type = "discovered";
        }
        this.getLog().debug((Object)("ListenAddress for port " + port + "=" + address + " (" + type + ")"));
        return address;
    }

    static void clearSigarCache() {
        if (sigar == null) {
            return;
        }
        SigarProxyCache.clear((Object)sigar);
        sigarImpl.close();
        sigar = null;
    }

    protected static String[] getProcArgs(long pid) {
        try {
            return ServerDetector.getSigar().getProcArgs(pid);
        }
        catch (SigarException e) {
            return NO_ARGS;
        }
    }

    protected static List getProcModules(long pid) {
        try {
            return ServerDetector.getSigar().getProcModules(pid);
        }
        catch (SigarException e) {
            return NO_MODULES;
        }
    }

    protected static String getProcExe(long pid) {
        return ServerDetector.getProcExe(pid, null);
    }

    protected static String getProcExe(long pid, String name) {
        List modules;
        ProcExe pexe = null;
        try {
            pexe = ServerDetector.getSigar().getProcExe(pid);
            String exe = pexe.getName();
            if (new File(exe).exists()) {
                return exe;
            }
        }
        catch (SigarException e) {
            // empty catch block
        }
        String argv0 = null;
        String[] args = ServerDetector.getProcArgs(pid);
        if (args.length != 0) {
            argv0 = args[0];
            File bin = new File(argv0);
            if (bin.exists() && bin.isAbsolute()) {
                return argv0;
            }
            if (pexe != null && (bin = new File(pexe.getCwd(), argv0)).exists() && bin.isAbsolute()) {
                try {
                    return bin.getCanonicalPath();
                }
                catch (IOException e) {
                    return bin.getPath();
                }
            }
        }
        if ((modules = ServerDetector.getProcModules(pid)).size() > 0) {
            if (name == null) {
                return (String)modules.get(0);
            }
            name = File.separator + name;
            for (int i = 0; i < modules.size(); ++i) {
                String bin = (String)modules.get(i);
                if (!bin.endsWith(name)) continue;
                return bin;
            }
        }
        return argv0;
    }

    protected static String getProcCwd(long pid) {
        try {
            return ServerDetector.getSigar().getProcExe(pid).getCwd();
        }
        catch (SigarException e) {
            return null;
        }
    }

    protected static long[] getPids(String query) {
        try {
            return ProcessFinder.find((SigarProxy)ServerDetector.getSigar(), (String)query);
        }
        catch (SigarException e) {
            return NO_PIDS;
        }
    }

    public boolean isWin32ServiceRunning(String name) {
        if (!ServerDetector.isWin32()) {
            return false;
        }
        return Win32MeasurementPlugin.isServiceRunning(name);
    }

    public boolean isSSLPort(String port) {
        return port.endsWith("443");
    }

    public String getConnectionProtocol(String port) {
        if (port.equals("21")) {
            return "ftp";
        }
        return "http";
    }

    protected Document getDocument(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(fis);
            return document;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            fis.close();
        }
    }

    protected String getXPathValue(Node node, String xpath) {
        try {
            String val = XPathAPI.eval((Node)node, (String)xpath).toString();
            if (val == null || val.length() == 0) {
                return null;
            }
            return val;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getXPathValue(File file, String xpath) {
        try {
            return this.getXPathValue(this.getDocument(file), xpath);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ConfigSchema getConfigSchema(String name, int type) {
        if (this.data == null) {
            return null;
        }
        return this.data.getConfigSchema(name, type);
    }

    private void mergeConfigDefaults(ConfigResponse config, ConfigSchema schema) {
        this.mergeConfigDefaults(config, schema, true);
    }

    private void mergeConfigDefaults(ConfigResponse config, ConfigSchema schema, boolean allowOverride) {
        List options = schema.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            String defval;
            String propValue;
            ConfigOption opt = (ConfigOption)options.get(i);
            String key = opt.getName();
            if (allowOverride && (propValue = this.properties.getProperty(key)) != null) {
                config.setValue(key, propValue);
                continue;
            }
            if (config.getValue(key) != null || (defval = opt.getDefault()) == null || defval.length() == 0) continue;
            config.setValue(key, opt.getDefault());
        }
    }

    private void mergeConfigDefaults(String name, int type, ConfigResponse config) {
        ConfigSchema schema = this.getConfigSchema(name, type);
        if (schema == null) {
            return;
        }
        this.mergeConfigDefaults(config, schema);
    }

    private void mergeConfigDefaults(String name, PluginManager manager, ConfigResponse config) {
        ConfigSchema schema;
        TypeInfo type = this.getTypeInfo();
        try {
            GenericPlugin plugin = manager.getPlugin(name);
            schema = plugin.getConfigSchema(type, config);
        }
        catch (PluginNotFoundException e) {
            this.getLog().error((Object)("'" + name + "' " + manager.getName() + " plugin not found"), (Throwable)((Object)e));
            return;
        }
        this.mergeConfigDefaults(config, schema);
    }

    protected void setProductConfig(ServerResource server, ConfigResponse config) {
        String name = this.getProductPlugin(server.getType()).getName();
        this.mergeConfigDefaults(name, this.ppm, config);
        AIServerValue aiServerValue = (AIServerValue)server.getResource();
        String resourceName = aiServerValue.getServerTypeName();
        if (this.autoApproveConfig != null) {
            Properties autoApproveProps = this.autoApproveConfig.getPropertiesForResource(resourceName);
            for (Object keyRef : autoApproveProps.keySet()) {
                String key = (String)keyRef;
                config.setValue(key, autoApproveProps.getProperty(key));
            }
        }
        server.setProductConfig(config);
    }

    protected void setMeasurementConfig(ServerResource server, ConfigResponse config) {
        PluginManager manager = this.ppm.getMeasurementPluginManager();
        this.mergeConfigDefaults(this.getName(), manager, config);
        manager = this.ppm.getLogTrackPluginManager();
        if (manager.getPlugins().get(this.getName()) != null) {
            this.mergeConfigDefaults(this.getName(), manager, config);
        }
        if ((manager = this.ppm.getConfigTrackPluginManager()).getPlugins().get(this.getName()) != null) {
            this.mergeConfigDefaults(this.getName(), manager, config);
        }
        server.setMeasurementConfig(config);
    }

    protected void setCustomProperties(ServerResource server, ConfigResponse config) {
        ConfigSchema cprops = this.getCustomPropertiesSchema();
        this.mergeConfigDefaults(config, cprops, false);
        server.setCustomProperties(config);
    }

    protected void setControlConfig(ServerResource server, ConfigResponse config) {
        ControlPluginManager manager = this.ppm.getControlPluginManager();
        this.mergeConfigDefaults(this.getName(), manager, config);
        server.setControlConfig(config);
    }

    protected void setProductConfig(ServiceResource service, ConfigResponse config) {
        this.mergeConfigDefaults(service.getType(), 0, config);
        service.setProductConfig(config);
    }

    protected void setMeasurementConfig(ServiceResource service, ConfigResponse config) {
        this.mergeConfigDefaults(service.getType(), 1, config);
        service.setMeasurementConfig(config);
    }

    protected void setControlConfig(ServiceResource service, ConfigResponse config) {
        this.mergeConfigDefaults(service.getType(), 2, config);
        service.setControlConfig(config);
    }

    public Map getServiceInventoryPlugins() {
        TypeInfo type = this.getTypeInfo();
        return this.data.getServiceInventoryPlugins(type.getName());
    }

    public List getServiceConfigs(String type) {
        return this.getManager().getServiceConfigs(type);
    }

    public int getScanOrder() {
        return Integer.MAX_VALUE;
    }
}

