/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.Agent;
import org.hyperic.hq.hqapi1.types.CreatePlatformRequest;
import org.hyperic.hq.hqapi1.types.CreateResourceRequest;
import org.hyperic.hq.hqapi1.types.Ip;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResourceConfig;
import org.hyperic.hq.hqapi1.types.ResourcePrototype;
import org.hyperic.hq.hqapi1.types.ResourcePrototypeResponse;
import org.hyperic.hq.hqapi1.types.ResourcePrototypesResponse;
import org.hyperic.hq.hqapi1.types.ResourceResponse;
import org.hyperic.hq.hqapi1.types.ResourcesRequest;
import org.hyperic.hq.hqapi1.types.ResourcesResponse;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceApi
extends BaseApi {
    ResourceApi(HQConnection conn) {
        super(conn);
    }

    public ResourcePrototypesResponse getAllResourcePrototypes() throws IOException {
        return this.doGet("resource/getResourcePrototypes.hqu", new HashMap<String, String[]>(), new XmlResponseHandler<ResourcePrototypesResponse>(ResourcePrototypesResponse.class));
    }

    public ResourcePrototypesResponse getResourcePrototypes() throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("existing", new String[]{Boolean.toString(Boolean.TRUE)});
        return this.doGet("resource/getResourcePrototypes.hqu", params, new XmlResponseHandler<ResourcePrototypesResponse>(ResourcePrototypesResponse.class));
    }

    public ResourcePrototypeResponse getResourcePrototype(String name) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("name", new String[]{name});
        return this.doGet("resource/getResourcePrototype.hqu", params, new XmlResponseHandler<ResourcePrototypeResponse>(ResourcePrototypeResponse.class));
    }

    public ResourceResponse createPlatform(Agent agent, ResourcePrototype type, String name, String fqdn, List<Ip> ips, Map<String, String> config) throws IOException {
        Resource platform = new Resource();
        platform.setName(name);
        for (Map.Entry<String, String> e : config.entrySet()) {
            ResourceConfig c = new ResourceConfig();
            c.setKey(e.getKey());
            c.setValue(e.getValue());
            platform.getResourceConfig().add(c);
        }
        CreatePlatformRequest request = new CreatePlatformRequest();
        request.setAgent(agent);
        request.setResource(platform);
        request.setPrototype(type);
        request.setFqdn(fqdn);
        request.getIp().addAll(ips);
        return this.doPost("resource/createPlatform.hqu", request, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    private ResourceResponse createResource(ResourcePrototype type, Resource parent, String name, Map<String, String> config) throws IOException {
        Resource resource = new Resource();
        resource.setName(name);
        for (Map.Entry<String, String> e : config.entrySet()) {
            ResourceConfig c = new ResourceConfig();
            c.setKey(e.getKey());
            c.setValue(e.getValue());
            resource.getResourceConfig().add(c);
        }
        CreateResourceRequest request = new CreateResourceRequest();
        request.setParent(parent);
        request.setResource(resource);
        request.setPrototype(type);
        return this.doPost("resource/createResource.hqu", request, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    public ResourceResponse createServer(ResourcePrototype type, Resource parent, String name, Map<String, String> config) throws IOException {
        return this.createResource(type, parent, name, config);
    }

    public ResourceResponse createService(ResourcePrototype type, Resource parent, String name, Map<String, String> config) throws IOException {
        return this.createResource(type, parent, name, config);
    }

    public ResourceResponse getResource(int id, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/get.hqu", params, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    public ResourceResponse getResource(String aeid, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("aeid", new String[]{aeid});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/get.hqu", params, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    public ResourceResponse getPlatformResource(String name, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("platformName", new String[]{name});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/get.hqu", params, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    public ResourceResponse getPlatformResourceByFqdn(String fqdn, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("fqdn", new String[]{fqdn});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/get.hqu", params, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    public ResourceResponse getPlatformResource(int id, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("platformId", new String[]{Integer.toString(id)});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/get.hqu", params, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }

    public ResourcesResponse getResources(Agent agent, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("agentId", new String[]{Integer.toString(agent.getId())});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/find.hqu", params, new XmlResponseHandler<ResourcesResponse>(ResourcesResponse.class));
    }

    public ResourcesResponse getResources(ResourcePrototype pt, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("prototype", new String[]{pt.getName()});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/find.hqu", params, new XmlResponseHandler<ResourcesResponse>(ResourcesResponse.class));
    }

    public ResourcesResponse getResources(String description, boolean verbose, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("description", new String[]{description});
        params.put("verbose", new String[]{Boolean.toString(verbose)});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("resource/find.hqu", params, new XmlResponseHandler<ResourcesResponse>(ResourcesResponse.class));
    }

    public StatusResponse updateResource(Resource resource) throws IOException {
        ResourcesRequest request = new ResourcesRequest();
        request.getResource().add(resource);
        return this.doPost("resource/update.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse syncResources(List<Resource> resources) throws IOException {
        ResourcesRequest request = new ResourcesRequest();
        request.getResource().addAll(resources);
        return this.doPost("resource/sync.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse deleteResource(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("resource/delete.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse moveResource(Resource target, Resource destination) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("targetId", new String[]{Integer.toString(target.getId())});
        params.put("destinationId", new String[]{Integer.toString(destination.getId())});
        return this.doGet("resource/move.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public ResourceResponse getParent(Resource r) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("parentOf", new String[]{Integer.toString(r.getId())});
        return this.doGet("resource/get.hqu", params, new XmlResponseHandler<ResourceResponse>(ResourceResponse.class));
    }
}

