/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.MaintenanceResponse;
import org.hyperic.hq.hqapi1.types.MaintenanceState;
import org.hyperic.hq.hqapi1.types.MaintenancesResponse;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.StatusResponse;

public class MaintenanceApi
extends BaseApi {
    MaintenanceApi(HQConnection conn) {
        super(conn);
    }

    public MaintenanceResponse schedule(int groupId, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("groupId", new String[]{Integer.toString(groupId)});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("maintenance/schedule.hqu", params, new XmlResponseHandler<MaintenanceResponse>(MaintenanceResponse.class));
    }

    public MaintenanceResponse schedule(Resource resource, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{resource.getId().toString()});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("maintenance/schedule.hqu", params, new XmlResponseHandler<MaintenanceResponse>(MaintenanceResponse.class));
    }

    public StatusResponse unschedule(int groupId) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("groupId", new String[]{Integer.toString(groupId)});
        return this.doGet("maintenance/unschedule.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse unschedule(Resource resource) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{resource.getId().toString()});
        return this.doGet("maintenance/unschedule.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public MaintenanceResponse get(int groupId) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("groupId", new String[]{Integer.toString(groupId)});
        return this.doGet("maintenance/get.hqu", params, new XmlResponseHandler<MaintenanceResponse>(MaintenanceResponse.class));
    }

    public MaintenanceResponse get(Resource resource) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{resource.getId().toString()});
        return this.doGet("maintenance/get.hqu", params, new XmlResponseHandler<MaintenanceResponse>(MaintenanceResponse.class));
    }

    public MaintenancesResponse getAll(MaintenanceState state) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        if (state != null) {
            params.put("state", new String[]{state.value()});
        }
        return this.doGet("maintenance/getAll.hqu", params, new XmlResponseHandler<MaintenancesResponse>(MaintenancesResponse.class));
    }
}

