/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.net.URI;
import org.hyperic.hq.hqapi1.AgentApi;
import org.hyperic.hq.hqapi1.AlertApi;
import org.hyperic.hq.hqapi1.AlertDefinitionApi;
import org.hyperic.hq.hqapi1.ApplicationApi;
import org.hyperic.hq.hqapi1.AutodiscoveryApi;
import org.hyperic.hq.hqapi1.ControlApi;
import org.hyperic.hq.hqapi1.EscalationApi;
import org.hyperic.hq.hqapi1.EventApi;
import org.hyperic.hq.hqapi1.GroupApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.MaintenanceApi;
import org.hyperic.hq.hqapi1.MetricApi;
import org.hyperic.hq.hqapi1.MetricDataApi;
import org.hyperic.hq.hqapi1.ResourceApi;
import org.hyperic.hq.hqapi1.ResourceEdgeApi;
import org.hyperic.hq.hqapi1.RoleApi;
import org.hyperic.hq.hqapi1.ServerConfigApi;
import org.hyperic.hq.hqapi1.UserApi;

public class HQApi {
    private final UserApi _userApi;
    private final RoleApi _roleApi;
    private final MetricApi _metricApi;
    private final GroupApi _groupApi;
    private final EscalationApi _escalationApi;
    private final AutodiscoveryApi _autodiscoveryApi;
    private final ResourceApi _resourceApi;
    private final AgentApi _agentApi;
    private final AlertDefinitionApi _alertDefinitionApi;
    private final MaintenanceApi _maintenanceApi;
    private final ResourceEdgeApi _resourceEdgeApi;
    private final ServerConfigApi _serverConfigApi;
    private final AlertApi _alertApi;
    private final MetricDataApi _metricDataApi;
    private final EventApi _eventApi;
    private final ControlApi _controlApi;
    private final ApplicationApi _applApi;

    public HQApi(String host, int port, boolean isSecure, String user, String password) {
        this(new HQConnection(host, port, isSecure, user, password));
    }

    public HQApi(URI uri, String user, String password) {
        this(new HQConnection(uri, user, password));
    }

    public HQApi(HQConnection connection) {
        this._userApi = new UserApi(connection);
        this._roleApi = new RoleApi(connection);
        this._groupApi = new GroupApi(connection);
        this._metricApi = new MetricApi(connection);
        this._escalationApi = new EscalationApi(connection);
        this._autodiscoveryApi = new AutodiscoveryApi(connection);
        this._resourceApi = new ResourceApi(connection);
        this._agentApi = new AgentApi(connection);
        this._alertDefinitionApi = new AlertDefinitionApi(connection);
        this._maintenanceApi = new MaintenanceApi(connection);
        this._resourceEdgeApi = new ResourceEdgeApi(connection);
        this._serverConfigApi = new ServerConfigApi(connection);
        this._alertApi = new AlertApi(connection);
        this._metricDataApi = new MetricDataApi(connection);
        this._eventApi = new EventApi(connection);
        this._controlApi = new ControlApi(connection);
        this._applApi = new ApplicationApi(connection);
    }

    public UserApi getUserApi() {
        return this._userApi;
    }

    public ResourceApi getResourceApi() {
        return this._resourceApi;
    }

    public RoleApi getRoleApi() {
        return this._roleApi;
    }

    public GroupApi getGroupApi() {
        return this._groupApi;
    }

    public MetricApi getMetricApi() {
        return this._metricApi;
    }

    public MetricDataApi getMetricDataApi() {
        return this._metricDataApi;
    }

    public EscalationApi getEscalationApi() {
        return this._escalationApi;
    }

    public AutodiscoveryApi getAutodiscoveryApi() {
        return this._autodiscoveryApi;
    }

    public AgentApi getAgentApi() {
        return this._agentApi;
    }

    public AlertDefinitionApi getAlertDefinitionApi() {
        return this._alertDefinitionApi;
    }

    public MaintenanceApi getMaintenanceApi() {
        return this._maintenanceApi;
    }

    public ResourceEdgeApi getResourceEdgeApi() {
        return this._resourceEdgeApi;
    }

    public ServerConfigApi getServerConfigApi() {
        return this._serverConfigApi;
    }

    public AlertApi getAlertApi() {
        return this._alertApi;
    }

    public EventApi getEventApi() {
        return this._eventApi;
    }

    public ControlApi getControlApi() {
        return this._controlApi;
    }

    public ApplicationApi getApplicationApi() {
        return this._applApi;
    }
}

