/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.hyperic.hq.hqapi1.ResponseHandler;
import org.hyperic.hq.hqapi1.types.ResponseStatus;
import org.hyperic.hq.hqapi1.types.ServiceError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResponseHandler<T>
implements ResponseHandler<T> {
    private static Log _log = LogFactory.getLog(FileResponseHandler.class);
    private final File targetFile;
    private Class<T> clazz;

    public FileResponseHandler(File targetFile, Class<T> clazz) {
        this.targetFile = targetFile;
        this.clazz = clazz;
    }

    @Override
    public T getErrorResponse(ServiceError error) throws IOException {
        try {
            T ret = this.clazz.newInstance();
            Method setResponse = this.clazz.getMethod("setStatus", ResponseStatus.class);
            setResponse.invoke(ret, new Object[]{ResponseStatus.FAILURE});
            Method setError = this.clazz.getMethod("setError", ServiceError.class);
            setError.invoke(ret, error);
            return ret;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Error generating error response", (Throwable)e);
            }
            throw new IOException("Error generating Error response");
        }
    }

    private T getSuccessResponse() throws IOException {
        try {
            T ret = this.clazz.newInstance();
            Method setResponse = this.clazz.getMethod("setStatus", ResponseStatus.class);
            setResponse.invoke(ret, new Object[]{ResponseStatus.SUCCESS});
            return ret;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Error generating error response", (Throwable)e);
            }
            throw new IOException("Error generating Error response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T handleResponse(HttpResponse response) throws IOException {
        int responseCode = response.getStatusLine().getStatusCode();
        switch (responseCode) {
            case 200: {
                FileOutputStream fileOutputStream = null;
                InputStream in = response.getEntity().getContent();
                try {
                    int len;
                    fileOutputStream = new FileOutputStream(this.targetFile.getAbsolutePath());
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        fileOutputStream.write(buf, 0, len);
                    }
                    T t = this.getSuccessResponse();
                    return t;
                }
                catch (Exception e) {
                    ServiceError error = new ServiceError();
                    error.setErrorCode("UnexpectedError");
                    error.setReasonText("Unable to deserialize result");
                    _log.warn((Object)"Unable to deserialize result", (Throwable)e);
                    T t = this.getErrorResponse(error);
                    return t;
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e) {
                            _log.warn((Object)("Unable to close output stream to file: " + this.targetFile + ".  Cause: " + e.getMessage()));
                        }
                    }
                }
            }
            case 401: {
                ServiceError error = new ServiceError();
                error.setErrorCode("LoginFailure");
                error.setReasonText("The given username and password could not be validated");
                return this.getErrorResponse(error);
            }
        }
        ServiceError error = new ServiceError();
        error.setErrorCode("Unexpected Error");
        String reason = response.getStatusLine().getReasonPhrase();
        if (reason != null) {
            error.setReasonText(reason);
        } else {
            error.setReasonText("An unexpected error occurred");
        }
        return this.getErrorResponse(error);
    }
}

