/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.shell;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hyperic.util.PrintfFormat;
import org.hyperic.util.shell.ShellCommandBase;
import org.hyperic.util.shell.ShellCommandExecException;
import org.hyperic.util.shell.ShellCommandHandler;
import org.hyperic.util.shell.ShellCommandInitException;
import org.hyperic.util.shell.ShellCommandUsageException;

public class MultiwordShellCommand
extends ShellCommandBase {
    private Map itsSubHandlerMap = new TreeMap();

    public ShellCommandHandler getSubHandler(String subName) {
        return (ShellCommandHandler)this.itsSubHandlerMap.get(subName);
    }

    public Set getHandlerNames() {
        return this.itsSubHandlerMap.keySet();
    }

    public void registerSubHandler(String subName, ShellCommandHandler handler) throws ShellCommandInitException {
        if (!this.itsSubHandlerMap.containsValue(handler)) {
            handler.init(this.getCommandName() + " " + subName, this.getShell());
        }
        this.itsSubHandlerMap.put(subName, handler);
    }

    public void processCommand(String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        String cmdName = this.getCommandName();
        if (args.length < 1) {
            throw new ShellCommandUsageException(cmdName + " command " + "requires an argument.");
        }
        ShellCommandHandler handler = (ShellCommandHandler)this.itsSubHandlerMap.get(args[0].toLowerCase());
        if (handler == null) {
            throw new ShellCommandUsageException("don't know how to " + cmdName + " " + args[0]);
        }
        String[] subArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subArgs, 0, subArgs.length);
        handler.processCommand(subArgs);
    }

    public String getSyntaxArgs() {
        StringBuffer res = new StringBuffer();
        res.append("<");
        Iterator i = this.getHandlerNames().iterator();
        while (i.hasNext()) {
            res.append((String)i.next());
            if (!i.hasNext()) continue;
            res.append(" | ");
        }
        res.append(">");
        return res.toString();
    }

    public String getUsageHelp(String[] args) {
        if (args.length == 0) {
            StringBuffer res = new StringBuffer();
            Object[] fArgs = new Object[2];
            res.append("    " + this.getUsageShort());
            res.append(".\n    For further help on each subcommand, ");
            res.append("type 'help ");
            res.append(this.getCommandName() + " <subcommand>'\n\n");
            int maxLen = 0;
            for (String cmdName : this.getHandlerNames()) {
                if (cmdName.length() <= maxLen) continue;
                maxLen = cmdName.length();
            }
            String fmtStr = "      %-" + (maxLen + 1) + "s %s";
            PrintfFormat fmt = new PrintfFormat(fmtStr);
            Iterator i = this.getHandlerNames().iterator();
            while (i.hasNext()) {
                String cmdName;
                cmdName = (String)i.next();
                ShellCommandHandler sub = this.getSubHandler(cmdName);
                fArgs[0] = cmdName + ":";
                fArgs[1] = sub.getUsageShort();
                res.append(fmt.sprintf(fArgs));
                if (!i.hasNext()) continue;
                res.append("\n");
            }
            return res.toString();
        }
        ShellCommandHandler handler = this.getSubHandler(args[0].toLowerCase());
        if (handler == null) {
            return null;
        }
        String[] subArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subArgs, 0, subArgs.length);
        return handler.getUsageHelp(subArgs);
    }
}

