/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;
import org.hyperic.util.security.SSLProvider;
import org.hyperic.util.timer.StopWatch;

public class DefaultSSLProviderImpl
implements SSLProvider {
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private static final Log log = LogFactory.getLog(DefaultSSLProviderImpl.class);

    private KeyManagerFactory getKeyManagerFactory(KeyStore keystore, String password) throws KeyStoreException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, password.toCharArray());
            return keyManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException("The algorithm is not supported: " + e, e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyStoreException("Password for the keystore is invalid: " + e, e);
        }
    }

    private TrustManagerFactory getTrustManagerFactory(KeyStore keystore) throws KeyStoreException, IOException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            return trustManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("The algorithm is not supported: " + e), (Throwable)e);
            throw new KeyStoreException(e);
        }
    }

    public DefaultSSLProviderImpl(KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificates) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Keystore info: alias=" + keystoreConfig.getAlias() + ", acceptUnverifiedCertificates=" + acceptUnverifiedCertificates));
        }
        boolean debug = log.isDebugEnabled();
        StopWatch watch = new StopWatch();
        try {
            KeystoreManager keystoreMgr = KeystoreManager.getKeystoreManager();
            KeyStore trustStore = keystoreMgr.getKeyStore(keystoreConfig);
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(trustStore, keystoreConfig.getFilePassword());
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(trustStore);
            X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            X509TrustManager customTrustManager = keystoreMgr.getCustomTrustManager(defaultTrustManager, keystoreConfig, acceptUnverifiedCertificates, trustStore);
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{customTrustManager}, new SecureRandom());
            this.sslSocketFactory = new SSLSocketFactory(this.sslContext, this.getHostnameVerifier());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (debug) {
                log.debug((Object)("readCert: " + watch));
            }
        }
    }

    private X509HostnameVerifier getHostnameVerifier() {
        return new X509HostnameVerifier(){
            private AllowAllHostnameVerifier internalVerifier = new AllowAllHostnameVerifier();

            public boolean verify(String host, SSLSession session) {
                return this.internalVerifier.verify(host, session);
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                this.internalVerifier.verify(host, cns, subjectAlts);
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
                this.internalVerifier.verify(host, cert);
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
                try {
                    this.internalVerifier.verify(host, ssl);
                }
                catch (SSLPeerUnverifiedException e) {
                    SSLPeerUnverifiedException sslPeerUnverifiedException = new SSLPeerUnverifiedException("The authenticity of host '" + host + "' can't be established: " + e);
                    sslPeerUnverifiedException.initCause(e);
                    throw sslPeerUnverifiedException;
                }
            }
        };
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }
}

