/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.hyperic.util.file.ArchiveUpdater;
import org.hyperic.util.file.FileUtil;

public class TgzUpdater
extends ArchiveUpdater {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(File tgz, File out, String pathToReplace, InputStream replacement, long rsize) throws IOException {
        FileInputStream file_in = null;
        GZIPInputStream gzip_in = null;
        TarInputStream tar_in = null;
        FileOutputStream file_out = null;
        GZIPOutputStream gzip_out = null;
        TarOutputStream tar_out = null;
        boolean isOverwrite = false;
        if (out == null || out.equals(tgz)) {
            isOverwrite = true;
            out = File.createTempFile("TgzUpdater", ".tgz.tmp");
        }
        boolean completedOK = false;
        boolean didReplacement = false;
        byte[] buf = new byte[8192];
        try {
            file_in = new FileInputStream(tgz);
            gzip_in = new GZIPInputStream(new BufferedInputStream(file_in));
            tar_in = new TarInputStream((InputStream)gzip_in);
            file_out = new FileOutputStream(out);
            gzip_out = new GZIPOutputStream(new BufferedOutputStream(file_out));
            tar_out = new TarOutputStream((OutputStream)gzip_out);
            TarEntry entry = tar_in.getNextEntry();
            while (entry != null) {
                if (!didReplacement && this.matches(entry.getName(), pathToReplace)) {
                    this.addFile(entry, tar_out, replacement, rsize, buf);
                    didReplacement = true;
                } else {
                    tar_out.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        FileUtil.copyStream((InputStream)tar_in, (OutputStream)tar_out, buf);
                    }
                    tar_out.closeEntry();
                }
                entry = tar_in.getNextEntry();
            }
            if (!didReplacement) {
                entry = new TarEntry(pathToReplace);
                this.addFile(entry, tar_out, replacement, rsize, buf);
            }
            file_out.flush();
            gzip_out.flush();
            tar_out.flush();
            completedOK = true;
        }
        catch (Throwable throwable) {
            this.doClose((InputStream)tar_in);
            this.doClose(gzip_in);
            this.doClose(file_in);
            this.doClose((OutputStream)tar_out);
            this.doClose(gzip_out);
            this.doClose(file_out);
            if (!completedOK) {
                out.delete();
            }
            throw throwable;
        }
        this.doClose((InputStream)tar_in);
        this.doClose(gzip_in);
        this.doClose(file_in);
        this.doClose((OutputStream)tar_out);
        this.doClose(gzip_out);
        this.doClose(file_out);
        if (!completedOK) {
            out.delete();
        }
        if (isOverwrite && !out.renameTo(tgz)) {
            throw new IOException("Error renaming " + out.getPath() + " to " + tgz.getPath());
        }
    }

    private void addFile(TarEntry entry, TarOutputStream tar_out, InputStream in, long size, byte[] buf) throws IOException {
        entry.setModTime(System.currentTimeMillis());
        entry.setSize(size);
        tar_out.putNextEntry(entry);
        FileUtil.copyStream(in, (OutputStream)tar_out, buf);
        tar_out.closeEntry();
    }
}

