/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hyperic.util.file.WriterHandler;

class RewriteWriter
extends WriterHandler {
    private File destFile;
    private File backupFile;
    private InputStream inStream;
    private long length;
    private boolean copied;

    RewriteWriter(File destFile, InputStream inStream, long length) {
        this.destFile = destFile;
        this.backupFile = null;
        this.inStream = inStream;
        this.length = length;
        this.copied = false;
    }

    RewriteWriter(File destFile, byte[] data) {
        this(destFile, new ByteArrayInputStream(data), data.length);
    }

    public void rollback() throws IOException {
        super.rollback();
        if (this.backupFile != null) {
            if (this.copied) {
                RewriteWriter.copy(this.backupFile, this.destFile);
            }
            this.backupFile.delete();
        }
    }

    public void cleanup() {
        super.cleanup();
        this.backupFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        super.write();
        if (!this.destFile.exists()) {
            throw new FileNotFoundException(this.destFile + " does not " + "exist for rewrite");
        }
        this.backupFile = File.createTempFile("fwrite", "tmp");
        RewriteWriter.copy(this.destFile, this.backupFile);
        this.copied = true;
        FileOutputStream fOs = new FileOutputStream(this.destFile);
        try {
            RewriteWriter.copyStream(this.inStream, fOs, this.length);
        }
        finally {
            try {
                fOs.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void copy(File in, File out) throws IOException {
        FileInputStream is = new FileInputStream(in);
        FileOutputStream os = new FileOutputStream(out);
        int count = 0;
        byte[] b = new byte[8192];
        while ((count = is.read(b)) != -1) {
            os.write(b, 0, count);
        }
        is.close();
        os.close();
    }
}

