/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.hyperic.util.config.ArrayConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class RegexArrayConfigOption
extends ArrayConfigOption
implements Serializable {
    public static final char DELIM = ' ';
    public static final String DELIM_STR = " ";

    public RegexArrayConfigOption(String optName, String optDesc, String defValue) {
        super(optName, optDesc, defValue, ' ');
    }

    private int countChars(String str, char c) {
        int j = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++j;
        }
        return j;
    }

    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        if (value == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(value, DELIM_STR);
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            if (pattern.startsWith("|") && pattern.endsWith("|") && this.countChars(pattern, '|') == 3) continue;
            throw this.invalidOption(" pattern must use the format |pattern|sub|");
        }
    }
}

