/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final char QUOTE = '\'';
    private static final char DOUBLEQUOTE = '\"';
    private static final char BACKSLASH = '\\';

    public static String replace(String source, String find, String replace) {
        int idx;
        if (source == null || find == null || replace == null) {
            return source;
        }
        int sourceLen = source.length();
        int findLen = find.length();
        if (sourceLen == 0 || findLen == 0) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int fromIndex = 0;
        while ((idx = source.indexOf(find, fromIndex)) != -1) {
            buffer.append(source.substring(fromIndex, idx));
            buffer.append(replace);
            fromIndex = idx + findLen;
        }
        if (fromIndex == 0) {
            return source;
        }
        buffer.append(source.substring(fromIndex));
        return buffer.toString();
    }

    public static String remove(String source, String find) {
        if (source == null || find == null) {
            return source;
        }
        String retVal = null;
        int sourceLen = source.length();
        int findLen = find.length();
        StringBuffer remove = new StringBuffer(source);
        try {
            if (source != null && sourceLen > 0 && find != null && findLen > 0) {
                int fromIndex = 0;
                int idx = 0;
                while ((fromIndex = source.indexOf(find, idx)) != -1) {
                    remove.delete(fromIndex, findLen + fromIndex);
                    idx = fromIndex + findLen;
                }
                retVal = remove.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            retVal = null;
        }
        return retVal;
    }

    public static String iteratorToString(Iterator i, String delim) {
        return StringUtil.iteratorToString(i, delim, "");
    }

    public static String iteratorToString(Iterator i, String delim, String quoteChar) {
        Object elt = null;
        StringBuffer rstr = new StringBuffer();
        while (i.hasNext()) {
            if (rstr.length() > 0) {
                rstr.append(delim);
            }
            if ((elt = (Object)i.next()) == null) {
                rstr.append("NULL");
                continue;
            }
            String s = elt.toString();
            if (quoteChar != null) {
                rstr.append(quoteChar).append(s).append(quoteChar);
                continue;
            }
            rstr.append(s);
        }
        return rstr.toString();
    }

    public static String listToString(List list, String delim) {
        if (list == null) {
            return "NULL";
        }
        Iterator i = list.iterator();
        return StringUtil.iteratorToString(i, delim, null);
    }

    public static String listToString(List list) {
        return StringUtil.listToString(list, ",");
    }

    public static String arrayToString(Object[] array) {
        return StringUtil.arrayToString(array, ',');
    }

    public static String arrayToString(boolean[] array) {
        if (array == null) {
            return "null";
        }
        String rstr = "";
        char delim = ',';
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                rstr = rstr + delim;
            }
            rstr = rstr + array[i];
        }
        return rstr;
    }

    public static String arrayToString(Object[] array, char delim) {
        if (array == null) {
            return "null";
        }
        String rstr = "";
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                rstr = rstr + delim;
            }
            rstr = rstr + array[i];
        }
        return rstr;
    }

    public static String arrayToString(int[] array) {
        if (array == null) {
            return "null";
        }
        String rstr = "";
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                rstr = rstr + ",";
            }
            rstr = rstr + array[i];
        }
        return rstr;
    }

    public static String implode(List objs, String delim) {
        StringBuffer buf = new StringBuffer();
        int size = objs.size();
        for (int i = 0; i < size - 1; ++i) {
            buf.append(objs.get(i).toString() + delim);
        }
        if (size != 0) {
            buf.append(objs.get(size - 1).toString());
        }
        return buf.toString();
    }

    public static List<String> explode(String s, String delim) {
        ArrayList<String> res = new ArrayList<String>();
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, delim);
            while (tok.hasMoreTokens()) {
                res.add(tok.nextToken());
            }
        }
        return res;
    }

    private static boolean spctabnl(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    private static int skipSingleQuoted(String str, int slen, int sind) {
        int i;
        for (i = sind; i < slen && str.charAt(i) != '\''; ++i) {
        }
        if (i < slen) {
            ++i;
        }
        return i;
    }

    private static int skipDoubleQuoted(String str, int slen, int sind) {
        int i = sind;
        int pass_next = 0;
        while (i < slen) {
            char c = str.charAt(i);
            if (pass_next != 0) {
                pass_next = 0;
                ++i;
                continue;
            }
            if (c == '\\') {
                ++pass_next;
                ++i;
                continue;
            }
            if (c == '\"') break;
            ++i;
        }
        if (i < slen) {
            ++i;
        }
        return i;
    }

    private static String extractDoubleQuoted(String str) {
        int slen = str.length();
        int pass_next = 0;
        boolean dquote = false;
        StringBuffer temp = new StringBuffer(slen);
        for (int i = 0; i < slen; ++i) {
            char c = str.charAt(i);
            if (pass_next != 0) {
                if (!dquote) {
                    temp.append('\\');
                }
                pass_next = 0;
                temp.append(c);
                continue;
            }
            if (c == '\\') {
                ++pass_next;
                continue;
            }
            if (c != '\"') {
                temp.append(c);
                continue;
            }
            dquote ^= true;
        }
        if (dquote) {
            throw new IllegalArgumentException("Unbalanced quotation marks");
        }
        return temp.toString();
    }

    private static String extractSingleQuoted(String str) {
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        if (first == '\'') {
            if (last == '\'') {
                return str.substring(1, str.length() - 1);
            }
            throw new IllegalArgumentException("Unbalanced quotation marks");
        }
        return str;
    }

    public static String extractQuoted(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.charAt(0) == '\'') {
            str = StringUtil.extractSingleQuoted(str);
        } else if (str.charAt(0) == '\"') {
            str = StringUtil.extractDoubleQuoted(str);
        }
        return str;
    }

    private static String[] splitCommandLine(String str, boolean extract) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int tokstart = 0;
        if (str == null || (str = str.trim()).length() == 0) {
            return new String[0];
        }
        int slen = str.length();
        while (true) {
            char c;
            if ((c = i < slen ? str.charAt(i) : (char)'\u0000') == '\\') {
                if (++i >= slen) continue;
                ++i;
                continue;
            }
            if (c == '\'') {
                ++i;
                i = StringUtil.skipSingleQuoted(str, slen, i);
                continue;
            }
            if (c == '\"') {
                ++i;
                i = StringUtil.skipDoubleQuoted(str, slen, i);
                continue;
            }
            if (c == '\u0000' || StringUtil.spctabnl(c)) {
                String token = str.substring(tokstart, i);
                if (extract) {
                    token = StringUtil.extractQuoted(token);
                }
                list.add(token);
                while (i < slen && StringUtil.spctabnl(str.charAt(i))) {
                    ++i;
                }
                if (i >= slen) break;
                tokstart = i;
                continue;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] explodeQuoted(String arg) {
        return StringUtil.splitCommandLine(arg, true);
    }

    public static String removePrefix(String value, String prefix) {
        if (!value.startsWith(prefix)) {
            return value;
        }
        return value.substring(prefix.length()).trim();
    }

    public static String pluralize(String word) {
        if (word.endsWith("s") || word.endsWith("x") || word.endsWith("o") || word.endsWith("ch")) {
            return word + "es";
        }
        if (word.endsWith("y")) {
            if (word.length() == 1) {
                return word;
            }
            char next2last = word.charAt(word.length() - 2);
            if (next2last != 'a' && next2last != 'e' && next2last != 'i' && next2last != 'o' && next2last != 'u' && next2last != 'y') {
                return word.substring(0, word.length() - 1) + "ies";
            }
        }
        return word + "s";
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "THROWABLE-WAS-NULL (at " + StringUtil.getStackTrace(new Exception()) + ")";
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            Throwable cause = t.getCause();
            if (cause != null) {
                return sw.toString() + StringUtil.getStackTrace(cause);
            }
            return sw.toString();
        }
        catch (Exception e) {
            return "\n\nStringUtil.getStackTrace GENERATED EXCEPTION: '" + e.toString() + "' \n\n";
        }
    }

    public static String normalizePath(String s) {
        return StringUtil.replace(s, "/", File.separator);
    }

    public static String formatDuration(long duration) {
        return StringUtil.formatDuration(duration, 0, false);
    }

    public static String formatDuration(long duration, int scale, boolean minDigits) {
        long hours = duration / 3600000L;
        long mins = (duration -= hours * 3600000L) / 60000L;
        double millis = (double)(duration -= mins * 60000L) / 1000.0;
        StringBuffer buf = new StringBuffer();
        if (hours > 0L || !minDigits) {
            buf.append(hours < 10L && !minDigits ? "0" + hours : String.valueOf(hours)).append(':');
            minDigits = false;
        }
        if (mins > 0L || !minDigits) {
            buf.append(mins < 10L && !minDigits ? "0" + mins : String.valueOf(mins)).append(':');
            minDigits = false;
        }
        NumberFormat fmt = NumberFormat.getInstance();
        int digits = !minDigits || scale == 0 && millis >= 9.5 ? 2 : 1;
        fmt.setMinimumIntegerDigits(digits);
        fmt.setMaximumIntegerDigits(2);
        fmt.setMinimumFractionDigits(0);
        fmt.setMaximumFractionDigits(scale);
        buf.append(fmt.format(millis));
        return buf.toString();
    }

    public static String repeatChars(char c, int nTimes) {
        char[] arr = new char[nTimes];
        for (int i = 0; i < nTimes; ++i) {
            arr[i] = c;
        }
        return new String(arr);
    }

    public static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().equals("")) {
            return str;
        }
        String result = str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
        return result;
    }

    public static String dotProximate(String str, int maxLen) {
        int strLen = str.length();
        if (strLen <= maxLen) {
            return str;
        }
        if (maxLen <= 3) {
            return "...";
        }
        int toChop = strLen - maxLen + 3;
        return str.substring(0, strLen / 2 - toChop / 2 - 1) + "..." + str.substring(strLen / 2 + toChop / 2);
    }

    public static boolean stringDoesNotExist(String source, String sub) {
        return sub != null && sub.length() > 0 && source.toLowerCase().indexOf(sub.toLowerCase()) < 0;
    }

    public static String escapeForRegex(String source, boolean wildcard) {
        if (source == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(source);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else if (character == '|') {
                result.append("\\|");
            } else if (character == '*') {
                if (wildcard) {
                    result.append(".*");
                } else {
                    result.append("\\*");
                }
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

