/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.rt.agent.server;

import com.hyperic.hq.rt.agent.commands.RtPlugin_args;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.util.StringUtil;
import org.hyperic.util.encoding.Base64;

class RtSchedule {
    private static final String PROP_ARGS = "rt_schedule";
    private static final int PROP_RECSIZE = 4096;
    private AgentStorageProvider store;
    private Log log;

    RtSchedule(AgentStorageProvider store, Properties bootProps) {
        this.store = store;
        this.log = LogFactory.getLog(RtSchedule.class);
        String info = bootProps.getProperty(PROP_ARGS);
        if (info != null) {
            store.addOverloadedInfo(PROP_ARGS, info);
        }
        try {
            this.store.createList(PROP_ARGS, 4096);
        }
        catch (AgentStorageException ignore) {
            // empty catch block
        }
    }

    private String encodeArgs(RtPlugin_args arg) throws IOException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        arg.toStream((DataOutput)dOs);
        return Base64.encode((byte[])bOs.toByteArray());
    }

    private RtPlugin_args decodeArgs(String val) throws IOException, AgentRemoteException {
        AgentRemoteValue arg = new AgentRemoteValue();
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)val));
        DataInputStream dIs = new DataInputStream(bIs);
        return new RtPlugin_args(AgentRemoteValue.fromStream((DataInput)dIs));
    }

    public void storeRt(RtPlugin_args newColl) {
        try {
            String ident = newColl.getRtIdent();
            String coll = this.encodeArgs(newColl);
            this.store.addToList(PROP_ARGS, ident + ":" + coll);
            this.log.debug((Object)("Added record to Rt Schedule. " + newColl));
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to store data: " + e));
        }
    }

    public void deleteRt(String ident) {
        Iterator iterator = this.store.getListIterator(PROP_ARGS);
        while (iterator.hasNext()) {
            String stored = (String)iterator.next();
            if (!stored.startsWith(ident + ":")) continue;
            iterator.remove();
            break;
        }
    }

    public boolean findRt(String ident) {
        Iterator iterator = this.store.getListIterator(PROP_ARGS);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String stored = (String)iterator.next();
                if (!stored.startsWith(ident + ":")) continue;
                return true;
            }
        }
        return false;
    }

    public List getRtList() {
        Iterator i = this.store.getListIterator(PROP_ARGS);
        ArrayList<RtPlugin_args> l = new ArrayList<RtPlugin_args>();
        if (i == null) {
            return l;
        }
        try {
            String stored;
            while (i.hasNext() && (stored = (String)i.next()) != null) {
                List values = StringUtil.explode((String)stored, (String)":");
                RtPlugin_args rtargs = this.decodeArgs((String)values.get(1));
                l.add(rtargs);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to retreive data from store: " + e));
        }
        return l;
    }

    private class CorruptDataException
    extends Exception {
        CorruptDataException(String s) {
            super(s);
        }
    }
}

