/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.tomcat.JBossUtil;
import org.hyperic.hq.plugin.tomcat.TomcatServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.hq.product.jmx.ServiceTypeFactory;
import org.hyperic.util.config.ConfigResponse;

public class JBossWebServerDetector
extends TomcatServerDetector {
    private ServiceTypeFactory serviceTypeFactory = new ServiceTypeFactory();
    private static final String MEASUREMENT_CLASS_PROPERTY = "measurement-class";
    private static final String CONTROL_CLASS_PROPERTY = "control-class";
    private static final String TEMPLATE_PROPERTY = "template";

    public String getTypeProperty(String type, String name) {
        String val = super.getTypeProperty(type, name);
        if (name.equals("OBJECT_NAME")) {
            val = val.replace("Catalina", "jboss.web");
        }
        return val;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        this.getLog().debug((Object)("[discoverServices] serverConfig=" + serverConfig));
        try {
            mServer = JBossUtil.getMBeanServerConnection(serverConfig.toProperties());
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return this.discoverMxServices(mServer, serverConfig);
    }

    public Set discoverServiceTypes(ConfigResponse serverConfig) throws PluginException {
        MBeanServerConnection mServer;
        Set serviceTypes = new HashSet();
        if (this.getProductPlugin().getPluginData().getProperty(MEASUREMENT_CLASS_PROPERTY) == null || this.getProductPlugin().getPluginData().getProperty(CONTROL_CLASS_PROPERTY) == null || this.getProductPlugin().getPluginData().getProperty(TEMPLATE_PROPERTY) == null) {
            return serviceTypes;
        }
        try {
            mServer = JBossUtil.getMBeanServerConnection(serverConfig.toProperties());
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            Set<ObjectName> objectNames = mServer.queryNames(new ObjectName("spring.application:*"), null);
            serviceTypes = this.serviceTypeFactory.create(this.getProductPlugin(), (ServerTypeInfo)this.getTypeInfo(), mServer, objectNames);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return serviceTypes;
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.getLog().debug((Object)("[getServerResources] platformConfig=" + platformConfig));
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        List procs = this.getServerProcessList();
        for (int i = 0; i < procs.size(); ++i) {
            MxServerDetector.MxProcess process = (MxServerDetector.MxProcess)procs.get(i);
            String config = "default";
            List<String> args = Arrays.asList(process.getArgs());
            this.getLog().debug((Object)("[getServerResources] args=" + args));
            if (args.contains("-c")) {
                config = args.get(args.indexOf("-c") + 1);
            }
            String fileVersion = process.getInstallPath() + "/../server/" + config;
            this.getLog().debug((Object)("[getServerResources] fileVersion=" + fileVersion));
            if (!this.isInstallTypeVersion(fileVersion)) continue;
            ServerResource server = this.getServerResource(process);
            ConfigResponse cfg = new ConfigResponse();
            cfg.setValue("jmx.url", "jnp://127.0.0.1:1099");
            cfg.setValue("process.query", this.getProcQuery() + ",Args.*.ct=" + process.getInstallPath());
            this.setProductConfig(server, cfg);
            servers.add(server);
        }
        return servers;
    }

    protected boolean isInstallTypeVersion(String path) {
        String versionFile = this.getTypeProperty("VERSION_FILE");
        String jbossVersion = this.getTypeProperty("JBOSS_VERSION");
        boolean ok = false;
        String v = "null";
        File f = new File(path, versionFile);
        if (f.exists()) {
            try {
                JarFile jarfile = new JarFile(f);
                Manifest manifest = jarfile.getManifest();
                Attributes attrs = manifest.getMainAttributes();
                v = attrs.getValue("Specification-Version");
            }
            catch (IOException ex) {
                this.getLog().debug((Object)("[isInstallTypeVersion] " + ex.getMessage()), (Throwable)ex);
            }
        }
        ok = v.startsWith(jbossVersion);
        this.getLog().debug((Object)("[isInstallTypeVersion] ok=" + ok + " version=" + v + "(" + jbossVersion + ") file=" + f));
        return ok;
    }

    protected void setJmxUrl(MxServerDetector.MxProcess process, ConfigResponse config) {
    }
}

