/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.tomcat;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.hyperic.hq.plugin.tomcat.JBossUtil;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxCompositeData;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;
import org.hyperic.util.config.ConfigResponse;

public class JBossWebMeasurementPlugin
extends MxMeasurementPlugin {
    private static final String COMPOSITE_PREFIX = "Composite.";

    public MetricValue getJMXValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        return super.getValue(metric);
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Object objectVal = metric.getAttributeName().startsWith(COMPOSITE_PREFIX) ? JBossWebMeasurementPlugin.getCompositeMetric(metric) : JBossUtil.getRemoteMBeanValue(metric);
        String stringVal = objectVal.toString();
        String mappedVal = this.getTypeProperty(metric.getAttributeName() + "." + stringVal);
        double doubleVal = mappedVal != null ? this.doubleValue(mappedVal) : (objectVal instanceof Number ? ((Number)objectVal).doubleValue() : (objectVal instanceof Boolean ? ((Boolean)objectVal != false ? 1.0 : 0.0) : this.doubleValue(stringVal)));
        if (doubleVal == -1.0) {
            return new MetricValue(Double.NaN);
        }
        return new MetricValue(doubleVal);
    }

    private double doubleValue(Object obj) throws PluginException {
        try {
            return Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new PluginException("Cannot convert '" + obj + "' to double");
        }
    }

    static Object getCompositeMetric(Metric metric) {
        Object obj;
        String name = metric.getAttributeName().substring(COMPOSITE_PREFIX.length());
        int ix = name.indexOf(46);
        if (ix == -1) {
            throw new MetricInvalidException("Missing composite key");
        }
        String attr = name.substring(0, ix);
        String key = name.substring(ix + 1);
        try {
            MBeanServerConnection mServer = JBossUtil.getMBeanServerConnection(metric);
            ObjectName objName = new ObjectName(metric.getObjectName());
            obj = mServer.getAttribute(objName, attr);
        }
        catch (Exception ex) {
            throw new MetricInvalidException("[getCompositeMetric] errror: " + ex, (Throwable)ex);
        }
        if (obj instanceof CompositeData) {
            return MxCompositeData.getValue((CompositeData)((CompositeData)obj), (String)key);
        }
        throw new MetricInvalidException("Not CompositeData");
    }

    public String translate(String template, ConfigResponse config) {
        String metric = super.translate(template, config);
        metric = metric.replace("Catalina", "jboss.web");
        return metric;
    }
}

