/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.plugin.netdevice.SNMPCollector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;

public class IfTableCollector
extends SNMPCollector {
    private boolean _isVersion1;
    private String _columnName;
    private static HashMap counter64 = new HashMap();

    protected String getColumnName() {
        return this._columnName;
    }

    protected void init(SNMPSession session) throws PluginException {
        this._isVersion1 = "v1".equals(this._props.getProperty("snmpVersion"));
        this._columnName = super.getColumnName();
        if (this._columnName == null) {
            throw new PluginException("snmpColumn not defined: " + this.getProperties() + " (stale template?)");
        }
        if (this._isVersion1) {
            return;
        }
        String name = (String)counter64.get(this._columnName);
        if (name != null) {
            List list64 = null;
            try {
                list64 = session.getBulk(name);
            }
            catch (SNMPException e) {
                // empty catch block
            }
            if (this.isEmpty(list64, name)) {
                this.getLog().debug((Object)(this.getInfo() + " does not support Counter64: " + name));
            } else {
                this.getLog().debug((Object)("Switching to 64 bit counter: " + this._columnName + "->" + name + ": " + this.getInfo()));
                this._columnName = name;
            }
        }
        this.setSource(this._columnName + "@" + this.getInfo());
    }

    protected boolean isTotalCounter(String name) {
        return name.endsWith("Octets");
    }

    public void collect() {
        this.collectIndexedColumn();
    }

    static {
        counter64.put("ifInOctets", "ifHCInOctets");
        counter64.put("ifOutOctets", "ifHCOutOctets");
        counter64.put("ifInUcastPkts", "ifHCInUcastPkts");
        counter64.put("ifOutUcastPkts", "ifHCOutUcastPkts");
        counter64.put("ifInNUcastPkts", "ifInMulticastPkts");
        counter64.put("ifOutNUcastPkts", "ifOutMulticastPkts");
    }
}

