/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.Event;
import com.vmware.vim25.EventFilterSpec;
import com.vmware.vim25.EventFilterSpecByTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.appha.VSphereConnection;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class VSphereHostEventPlugin
extends LogTrackPlugin
implements Runnable {
    private static final long INTERVAL = 300000L;
    private static final Log _log = LogFactory.getLog((String)VSphereHostEventPlugin.class.getName());
    protected Properties _props;
    private long _lastCheck;

    private String getEventClass(Event event) {
        String name = event.getClass().getName();
        int ix = name.lastIndexOf(46);
        if (ix != -1) {
            name = name.substring(ix + 1);
        }
        return name;
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this._props = config.toProperties();
        this.setup();
        this.getManager().addRunnableTracker((Runnable)this);
    }

    private void setup() throws PluginException {
        this._lastCheck = System.currentTimeMillis();
    }

    public void shutdown() throws PluginException {
        super.shutdown();
    }

    private EventFilterSpecByTime getTimeFilter(long begin, long end) {
        EventFilterSpecByTime filter = new EventFilterSpecByTime();
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTimeInMillis(begin);
        filter.setBeginTime(beginCal);
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis(end);
        filter.setEndTime(endCal);
        return filter;
    }

    private void processEvents(Event[] events) {
        for (int i = 0; i < events.length; ++i) {
            long created;
            Event event = events[i];
            if (event == null || event.getHost() == null && event.getVm() == null || (created = event.getCreatedTime().getTimeInMillis()) < this._lastCheck) continue;
            this.reportEvent(created, 6, "Event ID=" + event.getKey() + ", " + "User=" + event.getUserName(), "[" + this.getEventClass(event) + "] " + event.getFullFormattedMessage());
        }
    }

    private Event[] getEvents() throws PluginException {
        VSphereConnection conn = null;
        try {
            conn = VSphereConnection.getPooledInstance(this._props);
            String hostname = this.getConfig("vm");
            boolean isVm = true;
            if (hostname == null) {
                hostname = this.getConfig("hostname");
                isVm = false;
            }
            if (hostname == null) {
                Event[] eventArray = new Event[]{};
                return eventArray;
            }
            _log.debug((Object)("querying events for vm=" + hostname));
            EventFilterSpec criteria = new EventFilterSpec();
            criteria.setTime(this.getTimeFilter(this._lastCheck, this.now()));
            Event[] events = conn.vim.getEventManager().queryEvents(criteria);
            if (events == null) {
                Event[] eventArray = new Event[]{};
                return eventArray;
            }
            ArrayList<Event> rtn = new ArrayList<Event>(events.length);
            for (Event event : events) {
                if (event.getVm() != null || event.getHost() != null) {
                    event.toString();
                }
                if (isVm && event.getVm() != null && event.getVm().getName().equals(hostname)) {
                    rtn.add(event);
                    continue;
                }
                if (isVm || event.getHost() == null || !event.getHost().getName().equals(hostname)) continue;
                rtn.add(event);
            }
            _log.debug((Object)("returning " + rtn.size() + " events"));
            Event[] eventArray = rtn.toArray(new Event[0]);
            return eventArray;
        }
        catch (Exception e) {
            throw new PluginException("getEvents: " + e, (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.release();
            }
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public void run() {
        try {
            long now = this.now();
            if (now - this._lastCheck < 300000L) {
                return;
            }
            this.setup();
            Event[] events = this.getEvents();
            this.processEvents(events);
            this._lastCheck = now;
        }
        catch (PluginException e) {
            _log.error((Object)("checkForEvents: " + (Object)((Object)e)), (Throwable)e);
        }
    }
}

