/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.appha;

import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.measurement.MeasurementConstants;
import org.hyperic.hq.plugin.appha.VSphereCollector;
import org.hyperic.hq.plugin.appha.VSphereUtil;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.collection.IntHashMap;

public class VSphereHostCollector
extends VSphereCollector {
    static final String TYPE = "HostSystem";
    private final Log _log = LogFactory.getLog(VSphereHostCollector.class);
    private static final Set<String> VALID_UNITS = new HashSet<String>(Arrays.asList(MeasurementConstants.VALID_UNITS));
    private static final HashMap<String, String> UNITS_MAP = new HashMap();
    private static final String[][] UNITS_ALIAS = new String[][]{{"Second", "sec"}, {"Millisecond", "ms"}, {"Percent", "percent"}};

    protected String getType() {
        return TYPE;
    }

    protected String getName() {
        return this.getHostname();
    }

    protected String getUuid() {
        return this.getProperties().getProperty("uuid");
    }

    protected void printXml(PerfCounterInfo info, String key) {
        String rollup = info.getRollupType().toString();
        String name = info.getNameInfo().getLabel();
        String units = info.getUnitInfo().getLabel();
        if (rollup.equals("minimum") || rollup.equals("maximum")) {
            return;
        }
        if (name.indexOf("peak") != -1) {
            return;
        }
        if (UNITS_MAP.containsKey(units)) {
            units = UNITS_MAP.get(units);
        }
        if (!VALID_UNITS.contains(units)) {
            System.out.println("    <!-- units=" + units + " -->");
            units = "none";
        }
        System.out.println("    <metric name=\"" + name + "\"");
        System.out.println("            alias=\"" + key + "\"");
        System.out.println("            units=\"" + units + "\"/>\n");
    }

    protected void init() throws PluginException {
        super.init();
    }

    protected void setAvailability(ManagedEntity entity) {
        HostSystem host = (HostSystem)entity;
        HostSystemPowerState powerState = host.getRuntime().getPowerState();
        double avail = powerState == HostSystemPowerState.poweredOn ? 1.0 : (powerState == HostSystemPowerState.poweredOff ? -0.02 : (powerState == HostSystemPowerState.standBy ? -0.01 : (powerState == HostSystemPowerState.unknown ? -0.02 : 0.0)));
        this.setValue("Availability", avail);
    }

    protected void collect(VSphereUtil vim) throws Exception {
        ManagedEntity mor;
        boolean printMetric = "true".equals(System.getProperty("vim.xml"));
        try {
            mor = this.getManagedEntity(vim);
            this.setAvailability(mor);
        }
        catch (Exception e) {
            this.setAvailability(false);
            this._log.error((Object)("Error setting availability for " + this.getName() + ": " + e.getMessage()));
            this._log.debug((Object)e, (Throwable)e);
            return;
        }
        if (mor == null) {
            return;
        }
        PerformanceManager perfManager = vim.getPerformanceManager();
        PerfMetricId[] ids = this.getPerfMetricIds(perfManager, mor);
        if (ids == null || ids.length == 0) {
            this._log.info((Object)("No available performance metrics for " + this.getType() + "[name=" + this.getName() + "]"));
            return;
        }
        Integer refreshRate = this.getRefreshRate(perfManager, mor);
        PerfQuerySpec spec = new PerfQuerySpec();
        spec.setEntity(mor.getMOR());
        spec.setMetricId(ids);
        spec.setMaxSample(new Integer(1));
        spec.setIntervalId(refreshRate);
        PerfQuerySpec[] query = new PerfQuerySpec[]{spec};
        PerfEntityMetricBase[] values = perfManager.queryPerf(query);
        if (values == null) {
            this._log.info((Object)("No performance metrics for " + this.getType() + "[name=" + this.getName() + ", refreshRate=" + refreshRate + ", availablePerfMetric=" + ids.length + "]"));
            return;
        }
        IntHashMap counters = this.getCounterInfo(perfManager);
        PerfEntityMetric metric = (PerfEntityMetric)values[0];
        PerfMetricSeries[] vals = metric.getValue();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this.getType() + "[name=" + this.getName() + ", refreshRate=" + refreshRate + ", availablePerfMetric=" + ids.length + ", perfQuery=" + (vals == null ? 0 : vals.length) + "]"));
        }
        for (int i = 0; vals != null && i < vals.length; ++i) {
            String type;
            PerfCounterInfo info = (PerfCounterInfo)counters.get(vals[i].getId().getCounterId());
            if (info == null || !(vals[i] instanceof PerfMetricIntSeries)) continue;
            PerfMetricIntSeries series = (PerfMetricIntSeries)vals[i];
            String key = this.getCounterKey(info);
            long val = series.getValue()[0];
            String instance = series.getId().getInstance();
            if (instance.length() != 0) {
                instance = instance.replaceAll(":", "_");
                key = key + "." + instance;
                this.setValue("Availability." + instance, 1.0);
            }
            if (info.getUnitInfo().getLabel().equals("Percent")) {
                val /= 100L;
            }
            if ((type = info.getStatsType().toString()).equals("absolute") || type.equals("rate") && info.getRollupType().toString().equals("average")) {
                this.setValue(key, val);
                if (!printMetric) continue;
                this.printXml(info, key);
                continue;
            }
            if (instance.length() == 0) continue;
            this.setValue(key, val);
        }
    }

    protected void setValue(String key, double val) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("key='" + key + "' val='" + val + "'"));
        }
        if (key.startsWith("mem.swap") && key.endsWith("Rate.average")) {
            String newKey = key.replace("Rate.", ".");
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("newKey='" + newKey + "' val='" + val + "'"));
            }
            super.setValue(newKey, val);
        }
        super.setValue(key, val);
    }

    static {
        for (int i = 0; i < UNITS_ALIAS.length; ++i) {
            UNITS_MAP.put(UNITS_ALIAS[i][0], UNITS_ALIAS[i][1]);
        }
    }
}

